/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.item;

import com.google.common.collect.Multimap;
import epicsquid.mysticallib.model.IModeledObject;
import epicsquid.mysticallib.util.Util;
import epicsquid.mysticalworld.MysticalWorld;
import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.entity.model.armor.ModelAntlerHat;
import epicsquid.mysticalworld.init.ModItems;
import epicsquid.mysticalworld.materials.Materials;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAntlerHat
extends ItemArmor
implements IModeledObject {
    public static AxisAlignedBB BOX = new AxisAlignedBB(-8.0, -8.0, -8.0, 9.0, 9.0, 9.0);

    public ItemAntlerHat(ItemArmor.ArmorMaterial materialIn, String name) {
        super(materialIn, 0, EntityEquipmentSlot.HEAD);
        this.func_77655_b(name);
        this.setRegistryName(new ResourceLocation("mysticalworld", name));
        this.func_77656_e(350);
        this.func_77637_a(MysticalWorld.tab);
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "handler"));
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap map = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.HEAD && ConfigManager.hats.antlerHealthBonus != -1.0f) {
            map.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(Materials.ARMOR_MODIFIERS[slot.func_188454_b()], "Healthiness", (double)ConfigManager.hats.antlerHealthBonus, 0));
        }
        return map;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (ConfigManager.hats.antlerFrequency == -1) {
            return;
        }
        if (!world.field_72995_K) {
            float f = player.func_110143_aJ();
            float f2 = ConfigManager.hats.antlerThreshold == -1 ? player.func_110138_aP() : player.func_110138_aP() - (float)ConfigManager.hats.antlerThreshold;
            if (f < f2 && Util.rand.nextInt(ConfigManager.hats.antlerFrequency) == 0) {
                if (player.func_70660_b(MobEffects.field_76428_l) != null) {
                    return;
                }
                player.func_70691_i(ConfigManager.hats.antlerHealing);
                player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, ConfigManager.hats.antlerRegenDuration, ConfigManager.hats.antlerRegenAmplifier, false, false));
                ItemStack head = player.func_184582_a(EntityEquipmentSlot.HEAD);
                if (ConfigManager.hats.antlerDamage != -1) {
                    head.func_77972_a(ConfigManager.hats.antlerDamage, (EntityLivingBase)player);
                }
            }
        }
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "mysticalworld:textures/model/armor/antler_hat.png";
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return ModelAntlerHat.instance;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return toRepair.func_77973_b() == this && repair.func_77973_b() == ModItems.antlers;
    }
}

