/*
 * Decompiled with CFR 0.152.
 */
package netherchest.common.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketConfirmTransaction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import netherchest.common.inventory.ContainerNetherChest;
import netherchest.common.network.NetworkUtils;

public class MessageClickWindowExtended
implements IMessage {
    private int windowId;
    private int slot;
    private int mouseButton;
    private short transactionId;
    private ItemStack clickedItem = ItemStack.field_190927_a;
    private ClickType mode;

    public MessageClickWindowExtended() {
    }

    public MessageClickWindowExtended(int windowId, int slot, int mouseButton, ClickType mode, ItemStack clickedItem, short transactionId) {
        this.windowId = windowId;
        this.slot = slot;
        this.mouseButton = mouseButton;
        this.mode = mode;
        this.clickedItem = clickedItem;
        this.transactionId = transactionId;
    }

    public void fromBytes(ByteBuf buf) {
        this.windowId = buf.readByte();
        this.slot = buf.readInt();
        this.mouseButton = buf.readByte();
        this.transactionId = buf.readShort();
        this.mode = ClickType.values()[buf.readInt()];
        try {
            this.clickedItem = NetworkUtils.readExtendedItemStack(buf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.windowId);
        buf.writeInt(this.slot);
        buf.writeByte(this.mouseButton);
        buf.writeShort((int)this.transactionId);
        buf.writeInt(this.mode.ordinal());
        NetworkUtils.writeExtendedItemStackFromClientToServer(buf, this.clickedItem);
    }

    public static class Handler
    implements IMessageHandler<MessageClickWindowExtended, IMessage> {
        public IMessage onMessage(final MessageClickWindowExtended message, MessageContext ctx) {
            final EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (player == null) {
                return null;
            }
            player.func_71121_q().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    this.processMessage(message, player);
                }
            });
            return null;
        }

        public void processMessage(MessageClickWindowExtended message, EntityPlayerMP player) {
            player.func_143004_u();
            Container container = player.field_71070_bA;
            if (container.field_75152_c == message.windowId && container.func_75129_b((EntityPlayer)player)) {
                if (player.func_175149_v()) {
                    if (container instanceof ContainerNetherChest) {
                        ((ContainerNetherChest)container).syncInventory(player);
                    } else {
                        NonNullList nonnulllist = NonNullList.func_191196_a();
                        for (int i = 0; i < container.field_75151_b.size(); ++i) {
                            nonnulllist.add((Object)((Slot)container.field_75151_b.get(i)).func_75211_c());
                        }
                        player.func_71110_a(container, nonnulllist);
                    }
                } else {
                    ItemStack itemstack2 = container.func_184996_a(message.slot, message.mouseButton, message.mode, (EntityPlayer)player);
                    if (ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)message.clickedItem, (ItemStack)itemstack2)) {
                        player.field_71135_a.func_147359_a((Packet)new SPacketConfirmTransaction(message.windowId, message.transactionId, true));
                        player.field_71137_h = true;
                        player.field_71070_bA.func_75142_b();
                        player.func_71113_k();
                        player.field_71137_h = false;
                    } else if (container instanceof ContainerNetherChest) {
                        ((ContainerNetherChest)container).syncInventory(player);
                    } else {
                        NonNullList nonnulllist1 = NonNullList.func_191196_a();
                        for (int j = 0; j < container.field_75151_b.size(); ++j) {
                            ItemStack itemstack = ((Slot)container.field_75151_b.get(j)).func_75211_c();
                            ItemStack itemstack1 = itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack;
                            nonnulllist1.add((Object)itemstack1);
                        }
                        player.func_71110_a(container, nonnulllist1);
                    }
                }
            }
        }
    }
}

