/*
 * Decompiled with CFR 0.152.
 */
package netherchest.common.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import netherchest.common.Config;
import netherchest.common.blocks.BlockNetherChest;
import netherchest.common.inventory.ContainerNetherChest;
import netherchest.common.inventory.ExtendedItemStackHandler;

public class TileEntityNetherChest
extends TileEntity
implements ITickable,
IWorldNameable {
    public float lidAngle = 0.0f;
    public float prevLidAngle = 0.0f;
    public int numPlayersUsing = 0;
    private int ticksSinceSync = 0;
    protected String customName;
    public int renderTick = 0;
    ExtendedItemStackHandler itemHandler = new ExtendedItemStackHandler(27){

        @Override
        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityNetherChest.this.field_145850_b.func_175641_c(TileEntityNetherChest.this.field_174879_c, TileEntityNetherChest.this.func_145838_q(), 1, TileEntityNetherChest.this.numPlayersUsing);
            TileEntityNetherChest.this.func_70296_d();
        }
    };

    public int getRenderTick() {
        return this.renderTick;
    }

    public int getComparatorSignal() {
        return this.itemHandler.calcRedstone();
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        ++this.renderTick;
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + i + j + k) % 200 == 0) {
            int recordedUsers = this.numPlayersUsing;
            this.numPlayersUsing = 0;
            float f = 5.0f;
            for (EntityPlayer entityplayer : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)i - 5.0f), (double)((float)j - 5.0f), (double)((float)k - 5.0f), (double)((float)(i + 1) + 5.0f), (double)((float)(j + 1) + 5.0f), (double)((float)(k + 1) + 5.0f)))) {
                TileEntityNetherChest tenc;
                if (!(entityplayer.field_71070_bA instanceof ContainerNetherChest) || !((Object)((Object)(tenc = ((ContainerNetherChest)entityplayer.field_71070_bA).getTile()))).equals((Object)this)) continue;
                ++this.numPlayersUsing;
            }
            if (this.numPlayersUsing != recordedUsers) {
                this.func_70296_d();
            }
        }
        this.prevLidAngle = this.lidAngle;
        float f1 = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184148_a((EntityPlayer)null, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f2 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            float f3 = 0.5f;
            if (this.lidAngle < 0.5f && f2 >= 0.5f) {
                this.field_145850_b.func_184148_a((EntityPlayer)null, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            this.func_70296_d();
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void openInventory(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
            this.func_70296_d();
        }
    }

    public void closeInventory(EntityPlayer player) {
        if (!player.func_175149_v() && this.func_145838_q() instanceof BlockNetherChest) {
            --this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
            this.func_70296_d();
        }
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        this.func_145843_s();
        if (this.itemHandler != null && !world.field_72995_K) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack == null || stack.func_190926_b()) continue;
                state.func_177230_c();
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
        }
        world.func_175690_a(pos, null);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("Items")) {
            this.itemHandler.deserializeNBT(compound.func_74775_l("Items"));
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.setCustomName(compound.func_74779_i("CustomName"));
        }
        if (compound.func_74764_b("numUsers")) {
            this.numPlayersUsing = compound.func_74762_e("numUsers");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Items", (NBTBase)this.itemHandler.serializeNBT());
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        compound.func_74782_a("numUsers", (NBTBase)new NBTTagInt(this.numPlayersUsing));
        return compound;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && Config.ENABLE_AUTOMATION || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && Config.ENABLE_AUTOMATION) {
            return (T)((Object)this.itemHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public ExtendedItemStackHandler getHandler() {
        return this.itemHandler;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.netherchest.nether_chest";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String p_190575_1_) {
        this.customName = p_190575_1_;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }
}

