/*
 * Decompiled with CFR 0.152.
 */
package com.clownvin.livingenchantment;

import com.clownvin.livingenchantment.command.CommandAddItemXP;
import com.clownvin.livingenchantment.command.CommandResetItem;
import com.clownvin.livingenchantment.command.CommandSetItemLevel;
import com.clownvin.livingenchantment.command.CommandSetItemXP;
import com.clownvin.livingenchantment.command.CommandSetPersonality;
import com.clownvin.livingenchantment.config.LivingConfig;
import com.clownvin.livingenchantment.enchantment.EnchantmentLiving;
import com.clownvin.livingenchantment.entity.item.EntityLivingXPOrb;
import com.clownvin.livingenchantment.personality.Personality;
import com.clownvin.livingenchantment.proxy.CommonProxy;
import com.clownvin.livingenchantment.world.storage.loot.LootInjector;
import com.clownvin.livingenchantment.world.storage.loot.functions.EnchantLiving;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommand;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(name="Living Enchantment", modid="livingenchantment", version="3.2.3", updateJSON="https://raw.githubusercontent.com/Clownvin/Living-Enchantment/1.12.2/update.json", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber(modid="livingenchantment")
public class LivingEnchantment {
    public static final String MODID = "livingenchantment";
    public static final String VERSION = "3.2.3";
    public static final String NAME = "Living Enchantment";
    public static final String PERSONALITY_NAME = "personalityName";
    public static final String PERSONALITY = "personality";
    public static final String LEVEL = "level";
    public static final String EFFECTIVENESS = "effectiveness";
    public static final String XP = "xp";
    public static final String LAST_TALK = "lasttalk";
    public static final String KILL_COUNT = "kills";
    public static final String HIT_COUNT = "hits";
    public static final String USAGE_COUNT = "uses";
    public static final int JUST_UNIQUES = 0;
    public static final int JUST_BOOKS = 2;
    public static final int GEN1 = 1;
    @Mod.Instance
    public static LivingEnchantment instance;
    @SidedProxy(clientSide="com.clownvin.livingenchantment.proxy.ClientProxy", serverSide="com.clownvin.livingenchantment.proxy.ServerProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public static void serverStartingEvent(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandAddItemXP());
        event.registerServerCommand((ICommand)new CommandSetItemXP());
        event.registerServerCommand((ICommand)new CommandSetItemLevel());
        event.registerServerCommand((ICommand)new CommandResetItem());
        event.registerServerCommand((ICommand)new CommandSetPersonality());
    }

    private static boolean isNewerVersion(String v1, String v2) {
        String[] v1s = v1.split("\\.");
        String[] v2s = v2.split("\\.");
        if (v2s.length > v1s.length) {
            return true;
        }
        System.out.println(v2s.length + ", " + v1s.length);
        for (int i = 0; i < v2s.length; ++i) {
            if (v2s[i].length() > v1s[i].length()) {
                return true;
            }
            if (v2s[i].compareTo(v1s[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onJoinGame(PlayerEvent.PlayerLoggedInEvent event) {
        if (!LivingConfig.general.showUpdateNotifications) {
            return;
        }
        ForgeVersion.CheckResult result = ForgeVersion.getResult((ModContainer)Loader.instance().activeModContainer());
        if (result.target == null || !LivingEnchantment.isNewerVersion(Loader.instance().activeModContainer().getVersion(), result.target.toString())) {
            return;
        }
        event.player.func_145747_a((ITextComponent)new TextComponentTranslation("text.new_update_notification", new Object[]{"livingenchantment, livingenchantment-" + result.target.toString()}));
    }

    public static int getWornLivingLevel(EntityLivingBase entity) {
        int cumulativeLivingLevel = 0;
        Iterable gear = entity.func_184209_aF();
        for (ItemStack stack : gear) {
            NBTTagCompound tag;
            if (!(stack.func_77973_b() instanceof ItemArmor) || (tag = LivingEnchantment.getEnchantmentNBTTag(stack)) == null) continue;
            cumulativeLivingLevel += tag.func_74762_e(LEVEL);
        }
        return cumulativeLivingLevel;
    }

    public static void addBlockCount(EntityLivingBase entity) {
        Iterable gear = entity.func_184209_aF();
        for (ItemStack stack : gear) {
            NBTTagCompound tag;
            if (!(stack.func_77973_b() instanceof ItemArmor) || (tag = LivingEnchantment.getEnchantmentNBTTag(stack)) == null) continue;
            tag.func_74768_a(HIT_COUNT, tag.func_74762_e(HIT_COUNT) + 1);
        }
    }

    public static String removeFormatting(String textIn) {
        String text = textIn;
        while (text.contains("\u00a7")) {
            int index = text.indexOf("\u00a7");
            text = text.replace(text.substring(index, index + 2), "");
        }
        return text;
    }

    public static int xpToLvl(double xp) {
        if (LivingConfig.general.xpFunction == 1) {
            return (int)Math.pow(5.0 * (xp / LivingConfig.general.levelExpModifier) / 4.0, 0.3333333432674408) + 1;
        }
        return (int)((Math.sqrt(9.0 * (xp / LivingConfig.general.levelExpModifier) + 4.0) + 2.0) / 9.0);
    }

    public static double lvlToXp(int lvl) {
        if (LivingConfig.general.xpFunction == 1) {
            return (double)Math.round(4.0 * Math.pow(lvl - 1, 3.0) / 5.0) * LivingConfig.general.levelExpModifier;
        }
        return (double)(9 * (lvl * lvl) - 4 * lvl) * LivingConfig.general.levelExpModifier;
    }

    public static float getToolEffectivenessModifier(NBTTagCompound tag) {
        return 1.0f + (float)((double)tag.func_74762_e(LEVEL) * LivingConfig.general.toolEffectivenessPerLevel);
    }

    public static float getWeaponEffectivenessModifier(NBTTagCompound tag) {
        return 1.0f + (float)((double)tag.func_74762_e(LEVEL) * LivingConfig.general.weaponEffectivenessPerLevel);
    }

    public static float getArmorEffectivenessModifier(int level) {
        return 1.0f + (float)(Math.log10((double)(level + 6) / 7.0) * 2.0 * LivingConfig.general.armorEffectivenessPerLevel * 0.666);
    }

    public static NBTTagCompound getEnchantmentNBTTag(ItemStack stack) {
        NBTTagCompound tag = null;
        for (NBTBase base : stack.func_77986_q()) {
            NBTTagCompound other = (NBTTagCompound)base;
            if (Enchantment.func_185262_c((int)other.func_74765_d("id")) != EnchantmentLiving.LIVING_ENCHANTMENT) continue;
            tag = other;
            break;
        }
        return tag;
    }

    public static void doTalking(EntityPlayer player, ItemStack item, NBTTagCompound tag, Event reason) {
        if (!LivingConfig.personalities.showDialogue) {
            return;
        }
        Personality personality = Personality.getPersonality(tag);
        float damagePercent = item.func_77958_k() <= 0 || item.func_77958_k() <= 0 ? 0.0f : (float)item.func_77952_i() / (float)item.func_77958_k();
        try {
            Entity source;
            if (damagePercent >= 0.9f) {
                LivingEnchantment.talk(player, item, personality.getFivePercent(), 3000);
            } else if (damagePercent >= 0.75f) {
                LivingEnchantment.talk(player, item, personality.getTwentyPercent(), 3000);
            }
            if (reason instanceof LivingDeathEvent && Math.random() * (double)personality.killOdds <= 1.0) {
                if (((LivingDeathEvent)reason).getEntityLiving().equals((Object)player)) {
                    LivingEnchantment.talk(player, item, personality.getOnDeath());
                } else {
                    LivingEnchantment.talk(player, item, personality.getOnKill());
                }
            } else if ((reason instanceof BlockEvent.BreakEvent || reason instanceof UseHoeEvent) && Math.random() * (double)personality.useOdds <= 1.0) {
                LivingEnchantment.talk(player, item, personality.getOnUse());
            } else if (reason instanceof LivingHurtEvent && Math.random() * (double)personality.hurtOdds <= 1.0 && (source = ((LivingHurtEvent)reason).getSource().func_76346_g()) != null && source.equals((Object)player)) {
                LivingEnchantment.talk(player, item, personality.getOnTargetHurt());
            }
        }
        catch (RuntimeException e) {
            LivingEnchantment.talk(player, item, "Herobrine says: " + e.getMessage());
        }
    }

    public static void talk(EntityPlayer player, ItemStack stack, String message) {
        LivingEnchantment.talk(player, stack, message, LivingConfig.personalities.minimumDialogueDelay);
    }

    public static void talk(EntityPlayer player, ItemStack stack, String message, int minimumDialogueDelay) {
        NBTTagCompound tag = LivingEnchantment.getEnchantmentNBTTag(stack);
        if (!LivingConfig.personalities.showDialogue) {
            return;
        }
        if (System.currentTimeMillis() - tag.func_74763_f(LAST_TALK) < (long)minimumDialogueDelay) {
            if (tag.func_74763_f(LAST_TALK) > System.currentTimeMillis()) {
                tag.func_74772_a(LAST_TALK, System.currentTimeMillis());
            }
            return;
        }
        tag.func_74772_a(LAST_TALK, System.currentTimeMillis());
        float durability = (1.0f - (float)stack.func_77952_i() / (float)stack.func_77958_k()) * 100.0f;
        message = message.replace("$user", player.func_70005_c_()).replace("$level", "" + tag.func_74762_e(LEVEL)).replace("$durability", String.format("%.1f", Float.valueOf(durability)) + "%");
        player.func_145747_a((ITextComponent)new TextComponentString(stack.func_82833_r() + ": " + message));
    }

    public static boolean isMaxLevel(NBTTagCompound tag) {
        return tag.func_74762_e(LEVEL) == LivingConfig.general.maxLevel && LivingEnchantment.xpToLvl(tag.func_74769_h(XP)) >= LivingConfig.general.maxLevel;
    }

    public static void resetItem(ItemStack item) {
        NBTTagCompound tag = LivingEnchantment.getEnchantmentNBTTag(item);
        if (tag == null) {
            return;
        }
        tag.func_74780_a(XP, 0.0);
        tag.func_74768_a(LEVEL, 0);
        tag.func_74776_a(EFFECTIVENESS, LivingEnchantment.getWeaponEffectivenessModifier(tag));
        tag.func_74776_a(PERSONALITY, 0.0f);
        tag.func_74778_a(PERSONALITY_NAME, "???");
        tag.func_74768_a(KILL_COUNT, 0);
        tag.func_74768_a(HIT_COUNT, 0);
        tag.func_74768_a(USAGE_COUNT, 0);
    }

    public static List<ItemStack> getAllEquipedLivingItems(EntityPlayer player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(5);
        for (ItemStack i : player.func_184209_aF()) {
            if (LivingEnchantment.getEnchantmentNBTTag(i) == null) continue;
            items.add(i);
        }
        return items;
    }

    public static boolean isToolEffective(ItemStack item, IBlockState state) {
        return item.func_77973_b().getToolClasses(item).contains(state.func_177230_c().getHarvestTool(state));
    }

    public static void doExpDrop(EntityPlayer player, BlockPos pos, double exp) {
        if (LivingConfig.general.xpStyle == 0) {
            return;
        }
        if (LivingConfig.general.xpStyle == 2) {
            player.field_70170_p.func_72838_d((Entity)new EntityLivingXPOrb(player.field_70170_p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, exp));
        } else if (LivingConfig.general.xpStyle == 1) {
            if (LivingConfig.general.xpShare) {
                LivingEnchantment.addExp(player, exp);
            } else {
                ItemStack enchantedItem = EnchantmentHelper.func_92099_a((Enchantment)EnchantmentLiving.LIVING_ENCHANTMENT, (EntityLivingBase)player);
                LivingEnchantment.addExp(player, enchantedItem, LivingEnchantment.getEnchantmentNBTTag(enchantedItem), exp);
            }
        }
    }

    public static void addExp(EntityPlayer player, double exp) {
        List<ItemStack> items = LivingEnchantment.getAllEquipedLivingItems(player);
        for (ItemStack stack : LivingEnchantment.getAllEquipedLivingItems(player)) {
            LivingEnchantment.addExp(player, stack, LivingEnchantment.getEnchantmentNBTTag(stack), exp / (double)items.size());
        }
    }

    public static void addExp(EntityPlayer player, ItemStack stack, NBTTagCompound tag, double exp) {
        int currLevel = LivingEnchantment.xpToLvl(tag.func_74769_h(XP));
        tag.func_74780_a(XP, tag.func_74769_h(XP) + exp);
        int newLevel = LivingEnchantment.xpToLvl(tag.func_74769_h(XP));
        Personality personality = Personality.getPersonality(tag);
        tag.func_74778_a(PERSONALITY_NAME, personality.name);
        if (LivingConfig.general.maxLevel <= newLevel) {
            tag.func_74768_a(LEVEL, LivingConfig.general.maxLevel);
            tag.func_74776_a(EFFECTIVENESS, LivingEnchantment.getWeaponEffectivenessModifier(tag));
        } else {
            tag.func_74768_a(LEVEL, newLevel);
            tag.func_74776_a(EFFECTIVENESS, LivingEnchantment.getWeaponEffectivenessModifier(tag));
        }
        if (newLevel == currLevel) {
            return;
        }
        player.field_70170_p.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187802_ec, player.func_184176_by(), 0.75f, 0.9f + (float)(Math.random() * (double)0.2f));
        if (LivingConfig.personalities.showDialogue) {
            LivingEnchantment.talk(player, stack, personality.getOnLevelUp(), 0);
        }
    }

    public static void setExp(EntityPlayer player, ItemStack stack, NBTTagCompound tag, double exp) {
        tag.func_74780_a(XP, 0.0);
        LivingEnchantment.addExp(player, stack, tag, exp);
    }

    @SubscribeEvent
    public static void onPlayerPickedUpXP(PlayerPickupXpEvent event) {
        int xp;
        if (event.getOrb().field_70170_p.field_72995_K) {
            return;
        }
        if (LivingConfig.general.xpStyle != 0) {
            return;
        }
        ItemStack stack = EnchantmentHelper.func_92099_a((Enchantment)EnchantmentLiving.LIVING_ENCHANTMENT, (EntityLivingBase)event.getEntityPlayer());
        if (stack.func_190926_b()) {
            return;
        }
        NBTTagCompound tag = LivingEnchantment.getEnchantmentNBTTag(stack);
        if (LivingEnchantment.isMaxLevel(tag)) {
            return;
        }
        int n = xp = event.getOrb().field_70530_e == 1 ? 1 : event.getOrb().field_70530_e / 2;
        if (LivingConfig.general.xpShare) {
            LivingEnchantment.addExp(event.getEntityPlayer(), (double)xp * 3.0);
        } else {
            LivingEnchantment.addExp(event.getEntityPlayer(), stack, tag, (double)xp * 3.0);
        }
        event.getOrb().field_70530_e -= xp;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        NBTTagCompound tag;
        int livingLevel;
        if (event.getEntityPlayer() == null) {
            return;
        }
        if (event.getItemStack().func_77973_b() instanceof ItemArmor && (livingLevel = LivingEnchantment.getWornLivingLevel((EntityLivingBase)event.getEntityPlayer())) != 0) {
            event.getToolTip().add(new TextComponentTranslation("tooltip.currently_worn", new Object[0]).func_150260_c());
            event.getToolTip().add(TextFormatting.BLUE + " " + new TextComponentTranslation("tooltip.damage_reduction", new Object[]{String.format("%.1f", Float.valueOf((1.0f - 1.0f / LivingEnchantment.getArmorEffectivenessModifier(livingLevel)) * 100.0f)) + "%" + TextFormatting.BLUE}).func_150260_c());
        }
        if ((tag = LivingEnchantment.getEnchantmentNBTTag(event.getItemStack())) == null) {
            return;
        }
        float multiplier = tag.func_74760_g(EFFECTIVENESS);
        if (!(event.getItemStack().func_77973_b() instanceof ItemArmor) && multiplier > 0.0f) {
            String attackDamageText = new TextComponentTranslation("tooltip.attack_damage", new Object[0]).func_150260_c();
            for (int i = event.getToolTip().size() - 1; i >= 0; --i) {
                if (!((String)event.getToolTip().get(i)).contains(attackDamageText)) continue;
                try {
                    String text = ((String)event.getToolTip().get(i)).replace(attackDamageText, "").replace(" ", "");
                    text = LivingEnchantment.removeFormatting(text);
                    float damage = multiplier * Float.parseFloat(text);
                    event.getToolTip().set(i, " " + String.format(damage % 1.0f == 0.0f ? "%.0f" : "%.1f", Float.valueOf(damage)) + " " + attackDamageText);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        event.getToolTip().add(1, TextFormatting.GOLD + new TextComponentTranslation("tooltip.lvl", new Object[]{TextFormatting.RESET.toString() + TextFormatting.GREEN.toString() + tag.func_74762_e(LEVEL) + TextFormatting.RESET}).func_150260_c());
        double xp = tag.func_74769_h(XP);
        double nextLevelXp = LivingEnchantment.lvlToXp(tag.func_74762_e(LEVEL) + 1);
        event.getToolTip().add(2, TextFormatting.GOLD + new TextComponentTranslation("tooltip.exp", new Object[]{TextFormatting.RESET.toString() + TextFormatting.GREEN.toString() + String.format("%.1f", xp) + TextFormatting.RESET + "/" + TextFormatting.GREEN.toString() + String.format("%.1f", nextLevelXp) + TextFormatting.RESET}).func_150260_c());
        int i = tag.func_74762_e(KILL_COUNT);
        if (i > 0) {
            event.getToolTip().add(i + new TextComponentTranslation("tooltip.things_killed", new Object[0]).func_150260_c());
        }
        if ((i = tag.func_74762_e(USAGE_COUNT)) > 0) {
            Item item = event.getItemStack().func_77973_b();
            if (item instanceof ItemPickaxe) {
                event.getToolTip().add(i + new TextComponentTranslation("tooltip.blocks_pickaxed", new Object[0]).func_150260_c());
            } else if (item instanceof ItemAxe) {
                event.getToolTip().add(i + new TextComponentTranslation("tooltip.blocks_axed", new Object[0]).func_150260_c());
            } else if (item instanceof ItemSpade) {
                event.getToolTip().add(i + new TextComponentTranslation("tooltip.blocks_shoveled", new Object[0]).func_150260_c());
            } else if (item instanceof ItemHoe) {
                event.getToolTip().add(i + new TextComponentTranslation("tooltip.blocks_hoed", new Object[0]).func_150260_c());
            } else {
                event.getToolTip().add(i + new TextComponentTranslation("tooltip.blocks_tooled", new Object[0]).func_150260_c());
            }
        }
        if ((i = tag.func_74762_e(HIT_COUNT)) > 0) {
            event.getToolTip().add(i + new TextComponentTranslation("tooltip.hits_taken", new Object[0]).func_150260_c());
        }
        if (!LivingConfig.personalities.showPersonalities) {
            return;
        }
        event.getToolTip().add(3, TextFormatting.GOLD + new TextComponentTranslation("tooltip.personality", new Object[]{TextFormatting.RESET + "" + TextFormatting.GREEN + tag.func_74779_i(PERSONALITY_NAME)}).func_150260_c());
    }

    @SubscribeEvent
    public static void onLivingKilled(LivingDeathEvent event) {
        ItemStack item;
        NBTTagCompound tag;
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (LivingConfig.personalities.showDialogue && event.getEntityLiving() instanceof EntityPlayer && event.getEntityLiving().func_184614_ca().func_77948_v() && (tag = LivingEnchantment.getEnchantmentNBTTag(event.getEntityLiving().func_184614_ca())) != null && LivingConfig.personalities.showDialogue) {
            LivingEnchantment.talk((EntityPlayer)event.getEntityLiving(), event.getEntityLiving().func_184614_ca(), Personality.getPersonality(tag).getOnDeath());
        }
        if (!(event.getSource().func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
        NBTTagCompound tag2 = null;
        if (event.getSource().field_76373_n.equals("arrow") && player.func_184592_cb().func_77973_b() instanceof ItemBow) {
            tag2 = LivingEnchantment.getEnchantmentNBTTag(player.func_184592_cb());
        }
        if (tag2 == null) {
            tag2 = LivingEnchantment.getEnchantmentNBTTag(player.func_184614_ca());
        }
        if (tag2 != null) {
            tag2.func_74768_a(KILL_COUNT, tag2.func_74762_e(KILL_COUNT) + 1);
        }
        if ((tag2 = LivingEnchantment.getEnchantmentNBTTag(item = EnchantmentHelper.func_92099_a((Enchantment)EnchantmentLiving.LIVING_ENCHANTMENT, (EntityLivingBase)player))) == null) {
            return;
        }
        LivingEnchantment.doExpDrop(player, event.getEntityLiving().func_180425_c(), LivingConfig.getXPForLiving(event.getEntityLiving()));
        LivingEnchantment.doTalking(player, item, tag2, (Event)event);
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        int targetLivingLevel = LivingEnchantment.getWornLivingLevel(event.getEntityLiving());
        if (targetLivingLevel > 0) {
            event.setAmount(event.getAmount() * (1.0f / LivingEnchantment.getArmorEffectivenessModifier(targetLivingLevel)));
            LivingEnchantment.addBlockCount(event.getEntityLiving());
            if (event.getEntityLiving() instanceof EntityPlayer) {
                ItemStack item = EnchantmentHelper.func_92099_a((Enchantment)EnchantmentLiving.LIVING_ENCHANTMENT, (EntityLivingBase)event.getEntityLiving());
                LivingEnchantment.doTalking((EntityPlayer)event.getEntityLiving(), item, LivingEnchantment.getEnchantmentNBTTag(item), (Event)event);
            }
        }
        if (!(event.getSource().func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
        ItemStack weapon = player.func_184614_ca();
        NBTTagCompound tag = LivingEnchantment.getEnchantmentNBTTag(weapon);
        if (tag == null) {
            return;
        }
        float multiplier = LivingEnchantment.getWeaponEffectivenessModifier(tag);
        event.setAmount(event.getAmount() * multiplier);
        LivingEnchantment.doTalking(player, weapon, tag, (Event)event);
    }

    @SubscribeEvent
    public static void onAnvilRepair(AnvilRepairEvent event) {
        NBTTagCompound outputTag = LivingEnchantment.getEnchantmentNBTTag(event.getItemResult());
        NBTTagCompound inputTag = LivingEnchantment.getEnchantmentNBTTag(event.getItemInput());
        if (outputTag == null || inputTag == null) {
            return;
        }
        outputTag.func_74780_a(XP, inputTag.func_74769_h(XP));
        outputTag.func_74768_a(LEVEL, LivingEnchantment.xpToLvl(outputTag.func_74769_h(XP)));
        outputTag.func_74776_a(EFFECTIVENESS, LivingEnchantment.getWeaponEffectivenessModifier(outputTag));
        outputTag.func_74776_a(PERSONALITY, inputTag.func_74760_g(PERSONALITY));
        outputTag.func_74778_a(PERSONALITY_NAME, Personality.getPersonality((NBTTagCompound)inputTag).name);
        outputTag.func_74768_a(KILL_COUNT, inputTag.func_74762_e(KILL_COUNT));
        outputTag.func_74768_a(HIT_COUNT, inputTag.func_74762_e(HIT_COUNT));
        outputTag.func_74768_a(USAGE_COUNT, inputTag.func_74762_e(USAGE_COUNT));
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        NBTTagCompound outputTag = LivingEnchantment.getEnchantmentNBTTag(event.getOutput());
        NBTTagCompound inputTag = LivingEnchantment.getEnchantmentNBTTag(event.getLeft());
        if (outputTag == null || inputTag == null) {
            return;
        }
        outputTag.func_74780_a(XP, inputTag.func_74769_h(XP));
        outputTag.func_74768_a(LEVEL, LivingEnchantment.xpToLvl(outputTag.func_74769_h(XP)));
        outputTag.func_74776_a(EFFECTIVENESS, LivingEnchantment.getWeaponEffectivenessModifier(outputTag));
        outputTag.func_74776_a(PERSONALITY, inputTag.func_74760_g(PERSONALITY));
        outputTag.func_74778_a(PERSONALITY_NAME, Personality.getPersonality((NBTTagCompound)inputTag).name);
        outputTag.func_74768_a(KILL_COUNT, inputTag.func_74762_e(KILL_COUNT));
        outputTag.func_74768_a(HIT_COUNT, inputTag.func_74762_e(HIT_COUNT));
        outputTag.func_74768_a(USAGE_COUNT, inputTag.func_74762_e(USAGE_COUNT));
    }

    @SubscribeEvent
    public static void onHoeUse(UseHoeEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ItemStack heldItem = player.func_184614_ca();
        NBTTagCompound tag = LivingEnchantment.getEnchantmentNBTTag(heldItem);
        if (tag == null) {
            return;
        }
        Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
        if (!(block instanceof BlockGrass) && block != Blocks.field_150346_d) {
            return;
        }
        tag.func_74768_a(USAGE_COUNT, tag.func_74762_e(USAGE_COUNT) + 1);
        LivingEnchantment.doExpDrop(player, event.getPos(), 1.0);
        LivingEnchantment.doTalking(player, heldItem, tag, (Event)event);
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        ItemStack heldItem = player.func_184614_ca();
        NBTTagCompound tag = LivingEnchantment.getEnchantmentNBTTag(heldItem);
        if (tag == null) {
            return;
        }
        if (!LivingEnchantment.isToolEffective(heldItem, event.getState())) {
            return;
        }
        tag.func_74768_a(USAGE_COUNT, tag.func_74762_e(USAGE_COUNT) + 1);
        LivingEnchantment.doExpDrop(player, event.getPos(), LivingConfig.getXPForBlock(player.field_70170_p, event.getPos(), event.getState()));
        LivingEnchantment.doTalking(player, heldItem, tag, (Event)event);
    }

    @SubscribeEvent
    public static void breakSpeedEvent(PlayerEvent.BreakSpeed event) {
        ItemStack item = event.getEntityPlayer().func_184614_ca();
        NBTTagCompound tag = LivingEnchantment.getEnchantmentNBTTag(item);
        if (tag == null) {
            return;
        }
        if (!LivingConfig.general.effectivenessAffectsAllBlocks && !LivingEnchantment.isToolEffective(item, event.getState())) {
            return;
        }
        float multiplier = LivingEnchantment.getToolEffectivenessModifier(tag);
        event.setNewSpeed(event.getNewSpeed() * multiplier);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        EnchantmentLiving.LIVING_ENCHANTMENT = new EnchantmentLiving(Enchantment.Rarity.VERY_RARE, EnumEnchantmentType.ALL, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.FEET, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.LEGS});
        Personality.HEROBRINE = new Personality(0.0f, "Herobrine", new String[]{"Herobrine"}, 10, new String[]{"Herobrine"}, 10, new String[]{"Herobrine"}, new String[]{"Herobrine"}, new String[]{"Herobrine"}, 10, new String[]{"Herobrine ($durability durability remaining)"}, new String[]{"Herobrine ($durability durability remaining)"});
        if (Loader.isModLoaded((String)"enderio")) {
            LivingConfig.createEnderIOEnchantRecipe();
        }
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "livingXPOrb"), EntityLivingXPOrb.class, (String)"livingXPOrb", (int)0, (Object)instance, (int)100, (int)1, (boolean)true);
        LootInjector.init();
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new EnchantLiving.Serializer());
        proxy.init(event);
        Blocks.field_150336_V.setHarvestLevel("pickaxe", 1);
        Blocks.field_150377_bs.setHarvestLevel("pickaxe", 1);
        Blocks.field_150320_F.setHarvestLevel("pickaxe", 0);
        Blocks.field_150331_J.setHarvestLevel("pickaxe", 0);
        Blocks.field_150460_al.setHarvestLevel("pickaxe", 0);
        Blocks.field_150470_am.setHarvestLevel("pickaxe", 0);
        Blocks.field_150472_an.setHarvestLevel("axe", 0);
        Blocks.field_150446_ar.setHarvestLevel("pickaxe", 1);
        Blocks.field_150454_av.setHarvestLevel("pickaxe", 1);
        Blocks.field_180405_aT.setHarvestLevel("axe", 0);
        Blocks.field_180404_aQ.setHarvestLevel("axe", 0);
        Blocks.field_180406_aS.setHarvestLevel("axe", 0);
        Blocks.field_180403_aR.setHarvestLevel("axe", 0);
        Blocks.field_150386_bk.setHarvestLevel("pickaxe", 0);
        Blocks.field_180407_aO.setHarvestLevel("axe", 0);
        Blocks.field_180408_aP.setHarvestLevel("axe", 0);
        Blocks.field_150426_aN.setHarvestLevel("pickaxe", 0);
        Blocks.field_150415_aT.setHarvestLevel("axe", 0);
        Blocks.field_150417_aV.setHarvestLevel("pickaxe", 1);
        Blocks.field_150411_aY.setHarvestLevel("pickaxe", 1);
        Blocks.field_150390_bg.setHarvestLevel("pickaxe", 1);
        Blocks.field_150389_bf.setHarvestLevel("pickaxe", 1);
        Blocks.field_150385_bj.setHarvestLevel("pickaxe", 1);
        Blocks.field_150387_bl.setHarvestLevel("pickaxe", 1);
        Blocks.field_150376_bx.setHarvestLevel("axe", 0);
        Blocks.field_150373_bw.setHarvestLevel("axe", 0);
        Blocks.field_150372_bz.setHarvestLevel("pickaxe", 1);
        Blocks.field_150400_ck.setHarvestLevel("axe", 0);
        Blocks.field_150463_bK.setHarvestLevel("pickaxe", 1);
        Blocks.field_150467_bQ.setHarvestLevel("pickaxe", 1);
        Blocks.field_150451_bX.setHarvestLevel("pickaxe", 1);
        Blocks.field_150438_bZ.setHarvestLevel("pickaxe", 1);
        Blocks.field_150371_ca.setHarvestLevel("pickaxe", 1);
        Blocks.field_150370_cb.setHarvestLevel("pickaxe", 1);
        Blocks.field_150409_cd.setHarvestLevel("pickaxe", 1);
        Blocks.field_150367_z.setHarvestLevel("pickaxe", 1);
        Blocks.field_150402_ci.setHarvestLevel("pickaxe", 1);
        Blocks.field_150476_ad.setHarvestLevel("axe", 0);
        Blocks.field_150462_ai.setHarvestLevel("axe", 0);
        Blocks.field_180387_bt.setHarvestLevel("axe", 0);
        Blocks.field_180392_bq.setHarvestLevel("axe", 0);
        Blocks.field_180385_bs.setHarvestLevel("axe", 0);
        Blocks.field_180386_br.setHarvestLevel("axe", 0);
        Blocks.field_180390_bo.setHarvestLevel("axe", 0);
        Blocks.field_180391_bp.setHarvestLevel("axe", 0);
        Blocks.field_150383_bp.setHarvestLevel("pickaxe", 1);
        Blocks.field_150375_by.setHarvestLevel("axe", 0);
        Blocks.field_150487_bG.setHarvestLevel("axe", 0);
        Blocks.field_150401_cl.setHarvestLevel("axe", 0);
        Blocks.field_150481_bH.setHarvestLevel("axe", 0);
        Blocks.field_150405_ch.setHarvestLevel("pickaxe", 1);
        Blocks.field_150406_ce.setHarvestLevel("pickaxe", 1);
        Blocks.field_180400_cw.setHarvestLevel("pickaxe", 1);
        Blocks.field_180397_cI.setHarvestLevel("pickaxe", 1);
        Blocks.field_180396_cN.setHarvestLevel("pickaxe", 1);
        Blocks.field_180388_cO.setHarvestLevel("pickaxe", 1);
        Blocks.field_180389_cP.setHarvestLevel("pickaxe", 1);
        Blocks.field_180410_as.setHarvestLevel("axe", 0);
        Blocks.field_180412_aq.setHarvestLevel("axe", 0);
        Blocks.field_180409_at.setHarvestLevel("axe", 0);
        Blocks.field_180411_ar.setHarvestLevel("axe", 0);
        Blocks.field_180413_ao.setHarvestLevel("axe", 0);
        Blocks.field_180414_ap.setHarvestLevel("axe", 0);
        Blocks.field_185765_cR.setHarvestLevel("axe", 0);
        Blocks.field_185767_cT.setHarvestLevel("pickaxe", 1);
        Blocks.field_185768_cU.setHarvestLevel("pickaxe", 1);
        Blocks.field_185769_cV.setHarvestLevel("pickaxe", 1);
        Blocks.field_185770_cW.setHarvestLevel("pickaxe", 1);
        Blocks.field_150485_bF.setHarvestLevel("axe", 0);
        Blocks.field_185771_cX.setHarvestLevel("pickaxe", 1);
        Blocks.field_185772_cY.setHarvestLevel("pickaxe", 1);
        Blocks.field_189879_dh.setHarvestLevel("pickaxe", 1);
        Blocks.field_189880_di.setHarvestLevel("pickaxe", 1);
        Blocks.field_190976_dk.setHarvestLevel("pickaxe", 1);
        Blocks.field_190975_dA.setHarvestLevel("pickaxe", 0);
        Blocks.field_190988_dw.setHarvestLevel("pickaxe", 0);
        Blocks.field_190989_dx.setHarvestLevel("pickaxe", 0);
        Blocks.field_190986_du.setHarvestLevel("pickaxe", 0);
        Blocks.field_190984_ds.setHarvestLevel("pickaxe", 0);
        Blocks.field_190990_dy.setHarvestLevel("pickaxe", 0);
        Blocks.field_190980_do.setHarvestLevel("pickaxe", 0);
        Blocks.field_190982_dq.setHarvestLevel("pickaxe", 0);
        Blocks.field_190979_dn.setHarvestLevel("pickaxe", 0);
        Blocks.field_190978_dm.setHarvestLevel("pickaxe", 0);
        Blocks.field_190983_dr.setHarvestLevel("pickaxe", 0);
        Blocks.field_190987_dv.setHarvestLevel("pickaxe", 0);
        Blocks.field_190991_dz.setHarvestLevel("pickaxe", 0);
        Blocks.field_190985_dt.setHarvestLevel("pickaxe", 0);
        Blocks.field_190977_dl.setHarvestLevel("pickaxe", 0);
        Blocks.field_190981_dp.setHarvestLevel("pickaxe", 0);
        Blocks.field_192442_dQ.setHarvestLevel("pickaxe", 1);
        Blocks.field_192438_dM.setHarvestLevel("pickaxe", 1);
        Blocks.field_192439_dN.setHarvestLevel("pickaxe", 1);
        Blocks.field_192436_dK.setHarvestLevel("pickaxe", 1);
        Blocks.field_192434_dI.setHarvestLevel("pickaxe", 1);
        Blocks.field_192440_dO.setHarvestLevel("pickaxe", 1);
        Blocks.field_192430_dE.setHarvestLevel("pickaxe", 1);
        Blocks.field_192432_dG.setHarvestLevel("pickaxe", 1);
        Blocks.field_192429_dD.setHarvestLevel("pickaxe", 1);
        Blocks.field_192428_dC.setHarvestLevel("pickaxe", 1);
        Blocks.field_192433_dH.setHarvestLevel("pickaxe", 1);
        Blocks.field_192437_dL.setHarvestLevel("pickaxe", 1);
        Blocks.field_192441_dP.setHarvestLevel("pickaxe", 1);
        Blocks.field_192435_dJ.setHarvestLevel("pickaxe", 1);
        Blocks.field_192427_dB.setHarvestLevel("pickaxe", 1);
        Blocks.field_192431_dF.setHarvestLevel("pickaxe", 1);
        Blocks.field_192443_dR.setHarvestLevel("pickaxe", 1);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        Personality.fillWeightedList();
    }
}

