/*
 * Decompiled with CFR 0.152.
 */
package com.clownvin.util;

import com.clownvin.util.Weighted;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class WeightedList<E extends Weighted>
implements List<E> {
    private final ArrayList<E> list = new ArrayList();
    private float totalWeights = 0.0f;

    public E get() {
        if (this.list.size() == 0) {
            return null;
        }
        float selected = (float)Math.random() * this.totalWeights;
        float soFar = 0.0f;
        float thisWeight = 0.0f;
        for (int i = 0; i < this.list.size(); ++i) {
            thisWeight = ((Weighted)this.list.get(i)).getWeight();
            if (selected == soFar || selected < soFar + thisWeight) {
                return (E)((Weighted)this.list.get(i));
            }
            System.out.println(soFar += thisWeight);
        }
        System.err.println("WeightedList: Failed to actually select weighted entry. Total entries: " + this.list.size() + ", Total Weight: " + this.totalWeights);
        return (E)((Weighted)this.list.get(0));
    }

    public E get(float val) {
        if (this.list.size() == 0 || val >= 1.0f) {
            return (E)((Weighted)this.list.get(0));
        }
        float selected = val * this.totalWeights;
        float soFar = 0.0f;
        float thisWeight = 0.0f;
        for (int i = 0; i < this.list.size(); ++i) {
            thisWeight = ((Weighted)this.list.get(i)).getWeight();
            if (selected == soFar || selected < soFar + thisWeight) {
                return (E)((Weighted)this.list.get(i));
            }
            soFar += thisWeight;
        }
        System.err.println("WeightedList: Failed to actually select weighted entry for " + selected + ". Total entries: " + this.list.size() + ", Total Weight: " + this.totalWeights);
        return (E)((Weighted)this.list.get(0));
    }

    public float getVal(E e) {
        float soFar = 0.0f;
        float thisWeight = 0.0f;
        for (int i = 0; i < this.list.size(); ++i) {
            thisWeight = ((Weighted)this.list.get(i)).getWeight();
            if (this.list.get(i) == e) {
                return (soFar + thisWeight / 2.0f) / this.totalWeights;
            }
            soFar += thisWeight;
        }
        return 0.0f;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public synchronized Object[] toArray() {
        int i = 0;
        Object[] array = new Object[this.list.size()];
        for (Weighted b : this.list) {
            array[i++] = b;
        }
        return array;
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        for (int i = 0; i < this.list.size() && i < a.length; ++i) {
            a[i] = this.list.get(i);
        }
        return a;
    }

    @Override
    public synchronized boolean add(E e) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (((Weighted)this.list.get(i)).getWeight() > e.getWeight()) continue;
            this.list.add(i, e);
            this.totalWeights += e.getWeight();
            return true;
        }
        this.list.add(e);
        this.totalWeights += e.getWeight();
        return true;
    }

    @Override
    public synchronized boolean remove(Object o) {
        if (!(o instanceof Weighted)) {
            return true;
        }
        Weighted w = (Weighted)o;
        for (int i = 0; i < this.list.size(); ++i) {
            if (((Weighted)this.list.get(i)).getWeight() != w.getWeight()) continue;
            boolean ret = this.list.remove(o);
            if (ret) {
                this.totalWeights += w.getWeight();
            }
            return ret;
        }
        return true;
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        block0: for (Object o : c) {
            if (!(o instanceof Weighted)) {
                return false;
            }
            Weighted w = (Weighted)o;
            for (int i = 0; i < this.list.size(); ++i) {
                if (((Weighted)this.list.get(i)).getWeight() != w.getWeight()) continue;
                if (this.list.contains(c)) continue block0;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (Weighted e : c) {
            if (this.add((E)e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException("Not allowed to choose index of placement.");
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("It's just not supported.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            this.remove(o);
        }
        return true;
    }

    @Override
    public synchronized void clear() {
        this.list.clear();
    }

    @Override
    public E get(int index) {
        throw new UnsupportedOperationException("Cannot pick index. Use get().");
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException("Cannot pick index. Use add(element).");
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException("Cannot pick index. Use add(element).");
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException("Cannot pick index. Use remove(element).");
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException("No object has an index.");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("No object has an index.");
    }

    @Override
    public ListIterator<E> listIterator() {
        return (ListIterator)this.iterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException("Not allowed to select an index.");
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("Not allowed to select a set of indices.");
    }
}

