/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.mirror;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.shadowfacts.mirror.Mirror;
import net.shadowfacts.mirror.MirrorClass;

public class MirrorMethod {
    private Method method;

    MirrorMethod(Method method) {
        this.method = method;
    }

    public Method unwrap() {
        return this.method;
    }

    public MirrorClass<?> declaringClass() {
        return Mirror.of(this.method.getDeclaringClass());
    }

    public String name() {
        return this.unwrap().getName();
    }

    public Object invoke(Object instance, Object ... args) {
        try {
            return this.method.invoke(instance, args);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public MirrorMethod setAccessible(boolean accessible) {
        this.method.setAccessible(accessible);
        return this;
    }

    public MirrorClass<?>[] parameterTypes() {
        return (MirrorClass[])Mirror.ofAllUnwrapped(this.method.getParameterTypes()).toArray(MirrorClass[]::new);
    }

    public MirrorClass<?> returnType() {
        return Mirror.of(this.method.getReturnType());
    }

    public int modifiers() {
        return this.method.getModifiers();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers());
    }

    public boolean isNotStatic() {
        return !this.isStatic();
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers());
    }

    public boolean isNotAbstract() {
        return !this.isAbstract();
    }

    public boolean hasModifier(int modifier) {
        return (this.method.getModifiers() & modifier) != 0;
    }

    public boolean hasAnnotation(Class<? extends Annotation> clazz) {
        return this.method.isAnnotationPresent(clazz);
    }

    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this.method.getAnnotation(clazz);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MirrorMethod that = (MirrorMethod)o;
        return this.method.equals(that.method);
    }

    public int hashCode() {
        return this.method.hashCode();
    }
}

