/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.compat;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.shadowfacts.shadowmc.compat.Compat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompatManager {
    private Logger log;
    private List<Class> modules = new ArrayList<Class>();

    public CompatManager(String owner) {
        this.log = LogManager.getLogger((String)(owner + "|Compat"));
    }

    public boolean registerModule(Class clazz) {
        if (clazz.isAnnotationPresent(Compat.class)) {
            Compat annotation = clazz.getAnnotation(Compat.class);
            if (Loader.isModLoaded((String)annotation.value())) {
                this.modules.add(clazz);
                return true;
            }
            this.log.info("The mod %s was not loaded, skipping compatibility module", (Object)annotation.value());
            return false;
        }
        this.log.error("Cannot register compatibility class %s missing @Compat annotation", (Object)clazz.getName());
        return false;
    }

    public void preInit(FMLPreInitializationEvent event) {
        this.log.info("Attempting to run pre-initialization methods for all registered compatibility modules");
        for (Class clazz : this.modules) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!Modifier.isStatic(m.getModifiers()) || !m.isAnnotationPresent(Compat.PreInit.class)) continue;
                try {
                    m.invoke(null, event);
                }
                catch (ReflectiveOperationException e) {
                    Compat annotation = clazz.getAnnotation(Compat.class);
                    this.log.error("There was an error trying to invoke the pre-initialization method for %s", (Object)e, (Object)annotation.value());
                }
            }
        }
    }

    public void init(FMLInitializationEvent event) {
        this.log.info("Attempting to run initialization methods for all registered compatibility modules");
        for (Class clazz : this.modules) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!Modifier.isStatic(m.getModifiers()) || !m.isAnnotationPresent(Compat.Init.class)) continue;
                try {
                    m.invoke(null, event);
                }
                catch (ReflectiveOperationException e) {
                    Compat annotation = clazz.getAnnotation(Compat.class);
                    this.log.error("There was an error trying to invoke the initialization method for %s", (Object)e, (Object)annotation.value());
                }
            }
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        this.log.info("Attempting to run post-initialization methods for all registered compatibility modules");
        for (Class clazz : this.modules) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!Modifier.isStatic(m.getModifiers()) || !m.isAnnotationPresent(Compat.PostInit.class)) continue;
                try {
                    m.invoke(null, event);
                }
                catch (ReflectiveOperationException e) {
                    Compat annotation = clazz.getAnnotation(Compat.class);
                    this.log.error("There was an error trying to invoke the post-initialization method for %s", (Object)e, (Object)annotation.value());
                }
            }
        }
    }
}

