/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.imc;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.shadowfacts.shadowmc.util.LogHelper;

public abstract class IMCHandler {
    private String owner;
    private LogHelper log;
    private Map<String, Consumer<NBTTagCompound>> handlers = new HashMap<String, Consumer<NBTTagCompound>>();

    protected IMCHandler(String owner) {
        this.owner = owner;
        this.log = new LogHelper(owner + "|IMCHandler");
        this.registerHandlers();
    }

    protected abstract void registerHandlers();

    protected void addMessageHandler(String id, Consumer<NBTTagCompound> handler) {
        this.handlers.put(id, handler);
    }

    public void handleIMCEvent(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!message.isNBTMessage()) {
                this.log.error("Cannot handle non-NBT IMC message");
                continue;
            }
            NBTTagCompound tag = message.getNBTValue();
            String id = tag.func_74779_i("MessageID");
            if (!this.handlers.containsKey(id)) {
                this.log.error("Cannot handle IMC message for invalid ID (%s)", id);
                continue;
            }
            this.handlers.get(id).accept(tag);
        }
    }
}

