/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.element.button;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.shadowfacts.shadowmc.ui.UIDimensions;
import net.shadowfacts.shadowmc.ui.UIMouseInteractable;
import net.shadowfacts.shadowmc.ui.element.UIElementBase;
import net.shadowfacts.shadowmc.ui.style.UIAttribute;
import net.shadowfacts.shadowmc.ui.util.UIHelper;
import net.shadowfacts.shadowmc.util.MouseButton;

public abstract class UIButtonBase
extends UIElementBase
implements UIMouseInteractable {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("shadowmc", "textures/gui/widgets.png");
    protected boolean enabled = true;
    protected Consumer<List<String>> tooltip;

    public UIButtonBase(String type, String id, String ... classes) {
        super(type, id, classes);
    }

    protected abstract boolean handlePress(int var1, int var2, MouseButton var3);

    protected abstract void drawButton(int var1, int var2);

    @Override
    public void mouseClickDown(int mouseX, int mouseY, MouseButton button) {
        boolean result;
        if (this.enabled && (result = this.handlePress(mouseX, mouseY, button))) {
            this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    @Override
    public abstract UIDimensions getMinDimensions();

    @Override
    public abstract UIDimensions getPreferredDimensions();

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.getStyle(UIAttribute.BACKGROUND_ENABLED).booleanValue()) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179112_b((int)770, (int)771);
            UIHelper.bindTexture(TEXTURE);
            int v = this.enabled ? (UIHelper.isWithinBounds(mouseX, mouseY, this) ? 236 : 216) : 196;
            UIHelper.drawTexturedRect(this.x, this.y, 0, v, this.dimensions.width / 2, this.dimensions.height / 2);
            UIHelper.drawTexturedRect(this.x, this.y + this.dimensions.height / 2, 0, v + 20 - this.dimensions.height / 2, this.dimensions.width / 2, this.dimensions.height / 2);
            UIHelper.drawTexturedRect(this.x + this.dimensions.width / 2, this.y, 256 - this.dimensions.width / 2, v, this.dimensions.width / 2, this.dimensions.height / 2);
            UIHelper.drawTexturedRect(this.x + this.dimensions.width / 2, this.y + this.dimensions.height / 2, 256 - this.dimensions.width / 2, v + 20 - this.dimensions.height / 2, this.dimensions.width / 2, this.dimensions.height / 2);
            GlStateManager.func_179084_k();
        }
        this.drawButton(mouseX, mouseY);
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        if (this.tooltip != null && UIHelper.isWithinBounds(mouseX, mouseY, this)) {
            ArrayList<String> tooltip2 = new ArrayList<String>();
            this.tooltip.accept(tooltip2);
            if (!tooltip2.isEmpty()) {
                UIHelper.drawHoveringText(tooltip2, mouseX, mouseY);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setTooltip(Consumer<List<String>> tooltip2) {
        this.tooltip = tooltip2;
    }
}

