/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.mospells.registry;

import com.windanesz.mospells.entity.EntityBarakoaSpiritMinion;
import com.windanesz.mospells.entity.EntityFrostmawMinion;
import com.windanesz.mospells.entity.EntityMagicIceBall;
import com.windanesz.mospells.entity.EntityMagicIceBreath;
import com.windanesz.mospells.entity.EntityMagicSuperNova;
import com.windanesz.mospells.entity.EntityNagaMinion;
import com.windanesz.mospells.entity.EntityRupture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class MSEntities {
    private static int id = 0;

    private MSEntities() {
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<EntityEntry> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)MSEntities.createEntry(EntityMagicIceBreath.class, "magic_ice_breath", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)MSEntities.createEntry(EntityMagicIceBall.class, "magic_ice_ball", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)MSEntities.createEntry(EntityNagaMinion.class, "naga_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)MSEntities.createEntry(EntityRupture.class, "rupture", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)MSEntities.createEntry(EntityFrostmawMinion.class, "frostmaw_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)MSEntities.createEntry(EntityBarakoaSpiritMinion.class, "barakoa_spirit_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)MSEntities.createEntry(EntityMagicSuperNova.class, "magic_supernova", TrackingType.LIVING).build());
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name, TrackingType tracking) {
        return MSEntities.createEntry(entityClass, name).tracker(tracking.range, tracking.interval, tracking.trackVelocity);
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name) {
        ResourceLocation registryName = new ResourceLocation("mospells", name);
        return EntityEntryBuilder.create().entity(entityClass).id(registryName, id++).name(registryName.toString());
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name, String modid, TrackingType tracking) {
        return MSEntities.createEntry(entityClass, name, modid).tracker(tracking.range, tracking.interval, tracking.trackVelocity);
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name, String modid) {
        ResourceLocation registryName = new ResourceLocation(modid, name);
        return EntityEntryBuilder.create().entity(entityClass).id(registryName, id++).name(registryName.toString());
    }

    static enum TrackingType {
        LIVING(80, 3, true),
        PROJECTILE(64, 1, true),
        CONSTRUCT(160, 10, false);

        int range;
        int interval;
        boolean trackVelocity;

        private TrackingType(int range, int interval, boolean trackVelocity) {
            this.range = range;
            this.interval = interval;
            this.trackVelocity = trackVelocity;
        }
    }
}

