/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.enchantingcommands.cmds;

import com.natamus.collective.functions.StringFunctions;
import com.natamus.enchantingcommands.config.ModConfig;
import com.natamus.enchantingcommands.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;

public class CommandEnchantingcommands
extends CommandBase {
    public String func_71517_b() {
        return "enchantingcommands";
    }

    public List<String> func_71514_a() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(ModConfig.enchantCommandString);
        return l;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/enchantingcommands, /" + ModConfig.enchantCommandString;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        if (!sender.func_70003_b(2, this.func_71517_b())) {
            StringFunctions.sendMessage((EntityPlayer)player, (String)"You do not have access to that command.", (TextFormatting)TextFormatting.RED);
            return;
        }
        ItemStack held = player.func_184614_ca();
        if (args.length == 0) {
            this.sendUsage(player);
            return;
        }
        List<String> enchantments = Util.enchantments();
        if (args[0].toLowerCase().equals("enchant") && args.length > 2) {
            if (held.func_82833_r().toLowerCase().equals("air")) {
                StringFunctions.sendMessage((EntityPlayer)player, (String)"You do not have an enchantable item in your main hand.", (TextFormatting)TextFormatting.RED);
                return;
            }
            if (!enchantments.contains(args[1].toLowerCase())) {
                StringFunctions.sendMessage((EntityPlayer)player, (String)("The enchantment '" + args[1] + "' does not exist. See '/" + ModConfig.enchantCommandString + " list' for the available enchantments."), (TextFormatting)TextFormatting.RED);
                return;
            }
            if (!args[2].matches("-?\\d+")) {
                StringFunctions.sendMessage((EntityPlayer)player, (String)("'" + args[2] + "' is not a valid enchantment level."), (TextFormatting)TextFormatting.RED);
                return;
            }
            Integer level = Integer.parseInt(args[2]);
            if (level < 0) {
                StringFunctions.sendMessage((EntityPlayer)player, (String)"The enchantment level cannot be less than zero.", (TextFormatting)TextFormatting.RED);
                return;
            }
            if (level > 127) {
                StringFunctions.sendMessage((EntityPlayer)player, (String)"The enchantment level cannot be higher than 127.", (TextFormatting)TextFormatting.RED);
                return;
            }
            Enchantment enchant = Enchantment.func_180305_b((String)args[1].toLowerCase());
            if (enchant == null) {
                this.sendUsage(player);
                return;
            }
            ItemStack temp = new ItemStack(Item.func_150899_d((int)1));
            temp.func_77966_a(enchant, level.intValue());
            String estringtemp = temp.func_77986_q().func_179238_g(0).toString().split("id:")[1];
            Boolean removed = false;
            Integer index = 0;
            for (NBTBase nbt : held.func_77986_q()) {
                if (estringtemp.equals(nbt.toString().split("id:")[1])) {
                    held.func_77986_q().func_74744_a(index.intValue());
                    removed = true;
                    break;
                }
                index = index + 1;
            }
            if (level != 0) {
                held.func_77966_a(enchant, level.intValue());
                StringFunctions.sendMessage((EntityPlayer)player, (String)("The enchantment '" + args[1].toLowerCase() + "' has been added to the item with a level of " + args[2] + "."), (TextFormatting)TextFormatting.DARK_GREEN);
            } else if (removed.booleanValue()) {
                StringFunctions.sendMessage((EntityPlayer)player, (String)("The enchantment '" + args[1].toLowerCase() + "' has been removed from the item."), (TextFormatting)TextFormatting.DARK_GREEN);
            } else {
                StringFunctions.sendMessage((EntityPlayer)player, (String)("The enchantment '" + args[1].toLowerCase() + "' does not exist on the item."), (TextFormatting)TextFormatting.RED);
            }
            return;
        }
        if (args[0].equalsIgnoreCase("list")) {
            String joined = String.join((CharSequence)", ", enchantments);
            StringFunctions.sendMessage((EntityPlayer)player, (String)"--- Enchanting Commands List ---", (TextFormatting)TextFormatting.DARK_GREEN, (boolean)true);
            StringFunctions.sendMessage((EntityPlayer)player, (String)(" " + joined), (TextFormatting)TextFormatting.DARK_GREEN);
            return;
        }
        this.sendUsage(player);
    }

    public void sendUsage(EntityPlayer player) {
        StringFunctions.sendMessage((EntityPlayer)player, (String)"--- Enchanting Commands Usage ---", (TextFormatting)TextFormatting.DARK_GREEN, (boolean)true);
        StringFunctions.sendMessage((EntityPlayer)player, (String)(" /" + ModConfig.enchantCommandString + " list"), (TextFormatting)TextFormatting.DARK_GREEN);
        StringFunctions.sendMessage((EntityPlayer)player, (String)(" /" + ModConfig.enchantCommandString + " enchant <enchant> <lvl>"), (TextFormatting)TextFormatting.DARK_GREEN);
    }
}

