/*
 * Decompiled with CFR 0.152.
 */
package ejektaflex.bountiful.block;

import ejektaflex.bountiful.Bountiful;
import ejektaflex.bountiful.api.block.ITileEntityBountyBoard;
import ejektaflex.bountiful.api.ext.ExtNBTKt;
import ejektaflex.bountiful.cap.CapManager;
import ejektaflex.bountiful.cap.IGlobalBoard;
import ejektaflex.bountiful.logic.BountyHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0003J-\u0010\u001a\u001a\u0004\u0018\u0001H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010 J\u001e\u0010!\u001a\u00020\u000e2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020#H\u0016J\b\u0010'\u001a\u00020#H\u0016J\b\u0010(\u001a\u00020#H\u0002J\u0010\u0010)\u001a\u00020%2\u0006\u0010$\u001a\u00020%H\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006+"}, d2={"Lejektaflex/bountiful/block/TileEntityBountyBoard;", "Lnet/minecraft/tileentity/TileEntity;", "Lejektaflex/bountiful/api/block/ITileEntityBountyBoard;", "()V", "cap", "Lejektaflex/bountiful/cap/IGlobalBoard;", "getCap", "()Lejektaflex/bountiful/cap/IGlobalBoard;", "internalInv", "Lejektaflex/bountiful/logic/BountyHolder;", "inventory", "getInventory", "()Lejektaflex/bountiful/logic/BountyHolder;", "isLocalBounties", "", "()Z", "newBoard", "getNewBoard", "setNewBoard", "(Z)V", "pulseLeft", "", "getPulseLeft", "()I", "setPulseLeft", "(I)V", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "hasCapability", "readFromNBT", "", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "sendRedstonePulse", "update", "updatePulse", "writeToNBT", "Companion", "Bountiful"})
public final class TileEntityBountyBoard
extends TileEntity
implements ITileEntityBountyBoard {
    private final BountyHolder internalInv = new BountyHolder(new ItemStackHandler(27));
    private boolean newBoard = true;
    private int pulseLeft;
    public static final int numSlots = 27;
    public static final Companion Companion = new Companion(null);

    private final boolean isLocalBounties() {
        return !Bountiful.INSTANCE.getConfig().getGlobalBounties();
    }

    private final IGlobalBoard getCap() {
        Capability<IGlobalBoard> capability = CapManager.INSTANCE.getCAP_BOARD();
        if (capability == null) {
            Intrinsics.throwNpe();
        }
        return (IGlobalBoard)this.field_145850_b.getCapability(capability, null);
    }

    @Override
    @NotNull
    public BountyHolder getInventory() {
        BountyHolder bountyHolder;
        if (!this.isLocalBounties()) {
            Capability<IGlobalBoard> capability = CapManager.INSTANCE.getCAP_BOARD();
            if (capability == null) {
                Intrinsics.throwNpe();
            }
            if (this.field_145850_b.hasCapability(capability, null)) {
                IGlobalBoard iGlobalBoard = this.getCap();
                if (iGlobalBoard == null) {
                    Intrinsics.throwNpe();
                }
                bountyHolder = iGlobalBoard.getHolder();
            } else {
                bountyHolder = this.internalInv;
            }
        } else {
            bountyHolder = this.internalInv;
        }
        return bountyHolder;
    }

    @Override
    public boolean getNewBoard() {
        return this.newBoard;
    }

    @Override
    public void setNewBoard(boolean bl) {
        this.newBoard = bl;
    }

    public final int getPulseLeft() {
        return this.pulseLeft;
    }

    public final void setPulseLeft(int n) {
        this.pulseLeft = n;
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (this.isLocalBounties()) {
            ExtNBTKt.clear(tag);
            tag.func_74782_a("inv", (NBTBase)this.getInventory().getHandler().serializeNBT());
            tag.func_74757_a("newBoard", this.getNewBoard());
            tag.func_74768_a("pulseLeft", this.pulseLeft);
        }
        NBTTagCompound nBTTagCompound = super.func_189515_b(tag);
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"super.writeToNBT(tag)");
        return nBTTagCompound;
    }

    public void func_145839_a(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (this.isLocalBounties()) {
            this.getInventory().getHandler().deserializeNBT(tag.func_74775_l("inv"));
            this.setNewBoard(tag.func_74767_n("newBoard"));
            this.pulseLeft = tag.func_74762_e("pulseLeft");
        }
        super.func_145839_a(tag);
    }

    private final void updatePulse() {
        int n;
        int oldPulse = this.pulseLeft;
        int n2 = this.pulseLeft - 1;
        int n3 = 0;
        TileEntityBountyBoard tileEntityBountyBoard = this;
        tileEntityBountyBoard.pulseLeft = n = Math.max(n2, n3);
        if (this.pulseLeft != oldPulse) {
            IBlockState blockstate;
            IBlockState iBlockState = blockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"blockstate");
            this.field_145850_b.func_175685_c(this.field_174879_c, iBlockState.func_177230_c(), true);
        }
    }

    @Override
    public void sendRedstonePulse() {
        this.pulseLeft += 2;
        this.updatePulse();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.isLocalBounties()) {
            if (this.getNewBoard()) {
                this.setNewBoard(false);
                return;
            }
            this.updatePulse();
            BountyHolder bountyHolder = this.getInventory();
            World world = this.field_145850_b;
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
            boolean dirty = bountyHolder.update(world, this);
            if (dirty) {
                this.func_70296_d();
            }
        }
    }

    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? (Object)this.getInventory().getHandler() : super.getCapability(capability, facing));
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lejektaflex/bountiful/block/TileEntityBountyBoard$Companion;", "", "()V", "numSlots", "", "Bountiful"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

