/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.modifiers.accessories;

import c4.conarm.client.models.accessories.ModelBelt;
import c4.conarm.lib.modifiers.AccessoryModifier;
import c4.conarm.lib.modifiers.IAccessoryRender;
import c4.conarm.lib.utils.ConstructUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.ModifierTagHolder;

public class ModTravelBelt
extends AccessoryModifier
implements IAccessoryRender {
    private static final String TAG_HOTBAR = "hotbar";
    @SideOnly(value=Side.CLIENT)
    private static ModelBelt model;
    private static ResourceLocation texture;

    public ModTravelBelt() {
        super("travel_belt");
    }

    @Override
    public void onKeybinding(ItemStack armor, EntityPlayer player) {
        this.swapHotbars(armor, player);
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        NBTTagCompound oldBelt = modifierTag.func_74775_l(TAG_HOTBAR);
        if (oldBelt.func_82582_d()) {
            modifierTag.func_74782_a(TAG_HOTBAR, (NBTBase)new ItemStackHandler(9).serializeNBT());
        } else {
            modifierTag.func_74782_a(TAG_HOTBAR, (NBTBase)oldBelt);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onAccessoryRender(EntityLivingBase entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (model == null) {
            model = new ModelBelt();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        model.func_78088_a((Entity)entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    private void swapHotbars(ItemStack stack, EntityPlayer player) {
        ModifierTagHolder modtag = ModifierTagHolder.getModifier((ItemStack)stack, (String)this.getModifierIdentifier());
        HotbarData data = (HotbarData)modtag.getTagData(HotbarData.class);
        ItemStackHandler belt = data.hotbar;
        for (int i = 0; i < belt.getSlots(); ++i) {
            ItemStack heldStack = player.field_71071_by.func_70301_a(i).func_77946_l();
            ItemStack beltStack = belt.getStackInSlot(i).func_77946_l();
            player.field_71071_by.func_70299_a(i, beltStack);
            belt.setStackInSlot(i, heldStack);
        }
        modtag.save();
    }

    @Override
    public boolean canApplyCustom(ItemStack stack) {
        return EntityLiving.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.LEGS && super.canApplyCustom(stack);
    }

    static {
        texture = ConstructUtils.getResource("textures/models/accessories/travel_belt.png");
    }

    public static class HotbarData
    extends ModifierNBT {
        ItemStackHandler hotbar = new ItemStackHandler(9);

        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.hotbar.deserializeNBT((NBTTagCompound)tag.func_74781_a(ModTravelBelt.TAG_HOTBAR));
        }

        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74782_a(ModTravelBelt.TAG_HOTBAR, (NBTBase)this.hotbar.serializeNBT());
        }
    }
}

