/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.integrations.crafttweaker.actions;

import c4.conarm.integrations.crafttweaker.materials.IConArmMaterial;
import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.materials.PlatesMaterialStats;
import c4.conarm.lib.materials.TrimMaterialStats;
import crafttweaker.IAction;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;

public class SetDurabilityAction
implements IAction {
    private final IConArmMaterial material;
    private final String stat;
    private final float newValue;

    public SetDurabilityAction(IConArmMaterial material, String stat, float newValue) {
        this.material = material;
        this.stat = stat;
        this.newValue = newValue;
    }

    private static void set(Material material, String stat, float durability) {
        IMaterialStats oldStats = material.getStats(stat);
        if (oldStats instanceof CoreMaterialStats) {
            CoreMaterialStats coreStats = (CoreMaterialStats)oldStats;
            CoreMaterialStats newCore = new CoreMaterialStats(durability, coreStats.defense);
            material.addStats((IMaterialStats)newCore);
        } else if (oldStats instanceof PlatesMaterialStats) {
            PlatesMaterialStats plateStats = (PlatesMaterialStats)oldStats;
            PlatesMaterialStats newPlates = new PlatesMaterialStats(plateStats.modifier, durability, plateStats.toughness);
            material.addStats((IMaterialStats)newPlates);
        } else if (oldStats instanceof TrimMaterialStats) {
            TrimMaterialStats newTrim = new TrimMaterialStats(durability);
            material.addStats((IMaterialStats)newTrim);
        }
    }

    public void apply() {
        SetDurabilityAction.set((Material)this.material.getInternal(), this.stat, this.newValue);
    }

    public String describe() {
        return "Setting durability of " + this.material.getName() + " to " + this.newValue + " for " + this.stat;
    }
}

