/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.integrations.tinkertoolleveling;

import c4.conarm.common.ConfigHandler;
import c4.conarm.lib.events.ArmoryEvent;
import c4.conarm.lib.modifiers.ArmorModifierTrait;
import c4.conarm.lib.tinkering.ArmorBuilder;
import c4.conarm.lib.tinkering.TinkersArmor;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.toolleveling.TinkerToolLeveling;
import slimeknights.toolleveling.ToolLevelNBT;

public class ModArmorLeveling
extends ArmorModifierTrait {
    public static ModArmorLeveling modArmorLeveling;
    public static int newArmorMinModifiers;
    public static int maximumLevels;
    public static int baseXP;
    public static float levelMultiplier;
    public static int xpGainCap;
    public static float damageToXP;

    public ModArmorLeveling() {
        super("leveling", 0xFFFFFF);
        this.aspects.clear();
        this.addAspects(new ModifierAspect[]{new ModifierAspect.DataAspect((IModifier)this)});
        MinecraftForge.EVENT_BUS.register((Object)this);
        newArmorMinModifiers = ConfigHandler.leveling.newArmorMinModifiers;
        maximumLevels = ConfigHandler.leveling.maximumLevels;
        baseXP = ConfigHandler.leveling.baseXP;
        levelMultiplier = ConfigHandler.leveling.levelMultiplier;
        xpGainCap = ConfigHandler.leveling.xpGainCap;
        damageToXP = ConfigHandler.leveling.damageToXP;
    }

    @SubscribeEvent
    public void onArmorBuild(ArmoryEvent.OnItemBuilding evt) {
        ArrayList materials = Lists.newArrayList();
        for (int i = 0; i < evt.armor.getRequiredComponents().size(); ++i) {
            materials.add(Material.UNKNOWN);
        }
        NBTTagCompound baseTag = evt.armor.buildTag(materials);
        int modifiers = baseTag.func_74762_e("FreeModifiers");
        int modifierDelta = ModArmorLeveling.getStartingModifiers() - modifiers;
        NBTTagCompound toolTag = TagUtil.getToolTag((NBTTagCompound)evt.tag);
        modifiers = toolTag.func_74762_e("FreeModifiers");
        modifiers += modifierDelta;
        modifiers = Math.max(0, modifiers);
        toolTag.func_74768_a("FreeModifiers", modifiers);
        TagUtil.setToolTag((NBTTagCompound)evt.tag, (NBTTagCompound)toolTag);
        if (TinkerUtil.getModifierTag((NBTTagCompound)evt.tag, (String)this.getModifierIdentifier()).func_82582_d()) {
            this.apply(evt.tag);
        }
        if (!TinkerUtil.hasModifier((NBTTagCompound)evt.tag, (String)this.getModifierIdentifier())) {
            this.apply(evt.tag);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent evt) {
        Tooltips.addTooltips(evt.getItemStack(), evt.getToolTip());
    }

    @Override
    public float onHurt(ItemStack armor, EntityPlayer player, DamageSource source, float damage, float newDamage, LivingHurtEvent evt) {
        if (damage > 0.0f && !source.func_76363_c()) {
            this.addXp(armor, MathHelper.func_76125_a((int)((int)(damage * damageToXP)), (int)1, (int)xpGainCap), player);
        }
        return newDamage;
    }

    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean canApplyCustom(ItemStack stack) {
        return true;
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        ToolLevelNBT data = this.getLevelData(modifierTag);
        NBTTagCompound toolTag = TagUtil.getToolTag((NBTTagCompound)rootCompound);
        int modifiers = toolTag.func_74762_e("FreeModifiers") + data.bonusModifiers;
        toolTag.func_74768_a("FreeModifiers", Math.max(0, modifiers));
        TagUtil.setToolTag((NBTTagCompound)rootCompound, (NBTTagCompound)toolTag);
    }

    public void addXp(ItemStack armor, int amount, EntityPlayer player) {
        NBTTagList tagList = TagUtil.getModifiersTagList((ItemStack)armor);
        int index = TinkerUtil.getIndexInCompoundList((NBTTagList)tagList, (String)this.identifier);
        NBTTagCompound modifierTag = tagList.func_150305_b(index);
        ToolLevelNBT data = this.getLevelData(modifierTag);
        data.xp += amount;
        if (!ModArmorLeveling.canLevelUp(data.level)) {
            return;
        }
        int xpForLevelup = this.getXpForLevelup(data.level);
        boolean leveledUp = false;
        if (data.xp >= xpForLevelup) {
            data.xp -= xpForLevelup;
            ++data.level;
            ++data.bonusModifiers;
            leveledUp = true;
        }
        data.write(modifierTag);
        TagUtil.setModifiersTagList((ItemStack)armor, (NBTTagList)tagList);
        if (leveledUp) {
            this.apply(armor);
            if (!player.field_70170_p.field_72995_K) {
                TinkerToolLeveling.proxy.playLevelupDing(player);
                TinkerToolLeveling.proxy.sendLevelUpMessage(data.level, armor, player);
            }
            try {
                NBTTagCompound rootTag = TagUtil.getTagSafe((ItemStack)armor);
                ArmorBuilder.rebuildArmor(rootTag, (TinkersArmor)armor.func_77973_b());
                armor.func_77982_d(rootTag);
            }
            catch (TinkerGuiException e) {
                e.printStackTrace();
            }
        }
    }

    public int getXpForLevelup(int level) {
        if (level <= 1) {
            return ModArmorLeveling.getBaseXp();
        }
        return (int)((float)this.getXpForLevelup(level - 1) * ModArmorLeveling.getLevelMultiplier());
    }

    private ToolLevelNBT getLevelData(ItemStack itemStack) {
        return this.getLevelData(TinkerUtil.getModifierTag((ItemStack)itemStack, (String)this.getModifierIdentifier()));
    }

    private ToolLevelNBT getLevelData(NBTTagCompound modifierNBT) {
        return new ToolLevelNBT(modifierNBT);
    }

    public static int getBaseXp() {
        return baseXP;
    }

    public static float getLevelMultiplier() {
        return levelMultiplier;
    }

    public static int getStartingModifiers() {
        return newArmorMinModifiers;
    }

    public static boolean canLevelUp(int currentLevel) {
        return maximumLevels < 0 || maximumLevels >= currentLevel;
    }

    private static class Tooltips {
        private Tooltips() {
        }

        public static void addTooltips(ItemStack itemStack, List<String> tooltips) {
            NBTTagCompound tag = TinkerUtil.getModifierTag((ItemStack)itemStack, (String)modArmorLeveling.getModifierIdentifier());
            if (!tag.func_82582_d()) {
                ToolLevelNBT data = new ToolLevelNBT(tag);
                if (ModArmorLeveling.canLevelUp(data.level)) {
                    tooltips.add(1, Tooltips.getXpToolTip(data.xp, modArmorLeveling.getXpForLevelup(data.level)));
                }
                tooltips.add(1, Tooltips.getLevelTooltip(data.level));
            }
        }

        private static String getXpToolTip(int xp, int xpNeeded) {
            return String.format("%s: %s", I18n.func_74838_a((String)"tooltip.xp"), Tooltips.getXpString(xp, xpNeeded));
        }

        private static String getXpString(int xp, int xpNeeded) {
            return TextFormatting.WHITE + String.format("%d / %d", xp, xpNeeded);
        }

        private static String getLevelTooltip(int level) {
            return String.format("%s: %s", I18n.func_74838_a((String)"tooltip.level"), Tooltips.getLevelString(level));
        }

        public static String getLevelString(int level) {
            return Tooltips.getLevelColor(level) + Tooltips.getRawLevelString(level) + TextFormatting.RESET;
        }

        private static String getRawLevelString(int level) {
            if (level <= 0) {
                return "";
            }
            if (I18n.func_94522_b((String)("tooltip.level." + level))) {
                return I18n.func_74838_a((String)("tooltip.level." + level));
            }
            int i = 1;
            while (I18n.func_94522_b((String)("tooltip.level." + i))) {
                ++i;
            }
            StringBuilder str = new StringBuilder(I18n.func_74838_a((String)("tooltip.level." + level % i)));
            for (int j = level / i; j > 0; --j) {
                str.append('+');
            }
            return str.toString();
        }

        private static String getLevelColor(int level) {
            float hue = 0.277777f * (float)level;
            hue -= (float)((int)hue);
            return CustomFontColor.encodeColor((int)Color.HSBtoRGB(hue, 0.75f, 0.8f));
        }
    }
}

