/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityPixieHouse;
import com.github.alexthe666.iceandfire.item.ICustomRendered;
import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPixieHouse
extends BlockContainer
implements ICustomRendered {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public Item itemBlock;

    public BlockPixieHouse() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(IceAndFire.TAB_BLOCKS);
        this.func_149663_c("iceandfire.pixie_house");
        this.setRegistryName("iceandfire", "pixie_house");
        GameRegistry.registerTileEntity(TileEntityPixieHouse.class, (String)"pixie_house");
    }

    public boolean func_149662_c(IBlockState blockstate) {
        return false;
    }

    public boolean func_149686_d(IBlockState blockstate) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
        return iblockstate.isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.dropPixie(worldIn, pos);
        int meta = 0;
        if (worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof TileEntityPixieHouse) {
            meta = ((TileEntityPixieHouse)worldIn.func_175625_s((BlockPos)pos)).houseType;
        }
        BlockPixieHouse.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(IafBlockRegistry.pixieHouse, 1, meta));
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkFall(worldIn, pos);
    }

    private boolean checkFall(World worldIn, BlockPos pos) {
        if (!this.func_176196_c(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
            this.dropPixie(worldIn, pos);
            return false;
        }
        return true;
    }

    public void dropPixie(World world, BlockPos pos) {
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityPixieHouse && ((TileEntityPixieHouse)world.func_175625_s((BlockPos)pos)).hasPixie) {
            ((TileEntityPixieHouse)world.func_175625_s(pos)).releasePixie();
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityPixieHouse) {
            ((TileEntityPixieHouse)world.func_175625_s((BlockPos)pos)).houseType = stack.func_77960_j();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int i = 0; i < 6; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPixieHouse();
    }

    public class ItemBlockPixieHouse
    extends ItemBlock {
        public ItemBlockPixieHouse(Block block) {
            super(block);
            this.field_77777_bU = 1;
            this.func_77627_a(true);
        }

        public String func_77667_c(ItemStack stack) {
            int i = stack.func_77960_j();
            return "tile.iceandfire.pixie_house_" + i;
        }
    }
}

