/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.particle;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.Entity;
import net.minecraft.util.ReportedException;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class IceAndFireParticleSpawner {
    private Minecraft mc;

    public void spawnParticle(Particle particleID, boolean ignoreRange, boolean ignoreLimit, boolean minParticles, final double xCoord, final double yCoord, final double zCoord) {
        try {
            this.spawnParticle0(particleID, ignoreRange, ignoreLimit, minParticles, xCoord, yCoord, zCoord);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception while adding particle");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being added");
            crashreportcategory.func_71507_a("ID", (Object)particleID);
            crashreportcategory.func_189529_a("Position", (ICrashReportDetail)new ICrashReportDetail<String>(){

                public String call() throws Exception {
                    return CrashReportCategory.func_85074_a((double)xCoord, (double)yCoord, (double)zCoord);
                }
            });
            throw new ReportedException(crashreport);
        }
    }

    private Particle spawnParticle0(Particle particleID, boolean ignoreRange, boolean ingoreLimit, boolean minParticles, double xCoord, double yCoord, double zCoord) {
        if (this.mc == null) {
            this.mc = Minecraft.func_71410_x();
        }
        Entity entity = this.mc.func_175606_aa();
        if (this.mc != null && entity != null && this.mc.field_71452_i != null) {
            int k1 = this.calculateParticleLevel(minParticles, ingoreLimit);
            double d3 = entity.field_70165_t - xCoord;
            double d4 = entity.field_70163_u - yCoord;
            double d5 = entity.field_70161_v - zCoord;
            if (ignoreRange) {
                return this.spawnEffectParticle(particleID);
            }
            if (d3 * d3 + d4 * d4 + d5 * d5 > 1024.0) {
                return null;
            }
            return k1 > 1 ? null : this.spawnEffectParticle(particleID);
        }
        return null;
    }

    @Nullable
    public Particle spawnEffectParticle(Particle particle) {
        if (particle != null) {
            this.mc.field_71452_i.func_78873_a(particle);
            return particle;
        }
        return null;
    }

    private int calculateParticleLevel(boolean minimiseLevel, boolean ingoreLimit) {
        if (this.mc == null || this.mc.field_71441_e == null) {
            return 2;
        }
        int k1 = this.mc.field_71474_y.field_74362_aa;
        if (minimiseLevel && k1 == 2 && this.mc.field_71441_e.field_73012_v.nextInt(10) == 0) {
            k1 = 1;
        }
        if (k1 == 1 && this.mc.field_71441_e.field_73012_v.nextInt(3) == 0) {
            k1 = 2;
        }
        return k1;
    }
}

