/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityPixie;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class PixieAIFlee<T extends Entity>
extends EntityAIBase {
    private final Predicate<Entity> canBeSeenSelector;
    private final float avoidDistance;
    private final Predicate<? super T> avoidTargetSelector;
    private final Class<T> classToAvoid;
    protected EntityPixie pixie;
    protected T closestLivingEntity;
    private Vec3d hidePlace;

    public PixieAIFlee(EntityPixie pixie, Class<T> classToAvoidIn, float avoidDistanceIn, Predicate<? super T> avoidTargetSelectorIn) {
        this.pixie = pixie;
        this.classToAvoid = classToAvoidIn;
        this.canBeSeenSelector = new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity.func_70089_S() && PixieAIFlee.this.pixie.func_70635_at().func_75522_a(entity) && !PixieAIFlee.this.pixie.func_184191_r(entity);
            }
        };
        this.avoidTargetSelector = avoidTargetSelectorIn;
        this.avoidDistance = avoidDistanceIn;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.pixie.func_184586_b(EnumHand.MAIN_HAND) == ItemStack.field_190927_a) {
            return false;
        }
        if (this.pixie.func_70909_n()) {
            return false;
        }
        List list = this.pixie.field_70170_p.func_175647_a(this.classToAvoid, this.pixie.func_174813_aQ().func_72314_b((double)this.avoidDistance, 3.0, (double)this.avoidDistance), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, this.canBeSeenSelector, this.avoidTargetSelector}));
        if (list.isEmpty()) {
            return false;
        }
        this.closestLivingEntity = (Entity)list.get(0);
        if (this.closestLivingEntity != null) {
            Vec3d vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this.pixie, (int)16, (int)7, (Vec3d)new Vec3d(((Entity)this.closestLivingEntity).field_70165_t, ((Entity)this.closestLivingEntity).field_70163_u, ((Entity)this.closestLivingEntity).field_70161_v));
            if (vec3d == null) {
                return false;
            }
            vec3d = vec3d.func_72441_c(0.0, 3.0, 0.0);
            this.pixie.func_70605_aq().func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
            this.pixie.func_70671_ap().func_75650_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 180.0f, 20.0f);
            this.hidePlace = vec3d;
            this.pixie.slowSpeed = true;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_75253_b() {
        if (this.hidePlace == null) return false;
        BlockPos blockPos = new BlockPos(this.hidePlace);
        if (!(this.pixie.func_174831_c(blockPos) < 2.0)) return false;
        return true;
    }

    public void func_75249_e() {
        this.pixie.func_70605_aq().func_75642_a(this.hidePlace.field_72450_a, this.hidePlace.field_72448_b, this.hidePlace.field_72449_c, 1.0);
        this.pixie.func_70671_ap().func_75650_a(this.hidePlace.field_72450_a, this.hidePlace.field_72448_b, this.hidePlace.field_72449_c, 180.0f, 20.0f);
    }

    public void func_75251_c() {
        this.pixie.func_70605_aq().field_188491_h = EntityMoveHelper.Action.WAIT;
        this.closestLivingEntity = null;
        this.pixie.slowSpeed = false;
    }
}

