/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.world.gen.processor.DreadRuinProcessor;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class WorldGenGorgonTemple
extends WorldGenerator {
    public EnumFacing facing;
    private static final ResourceLocation STRUCTURE = new ResourceLocation("iceandfire", "gorgon_temple");

    public WorldGenGorgonTemple(EnumFacing facing) {
        super(false);
        this.facing = facing;
    }

    public static boolean isPartOfRuin(IBlockState state) {
        return false;
    }

    public static Rotation getRotationFromFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static BlockPos getGround(BlockPos pos, World world) {
        return WorldGenGorgonTemple.getGround(pos.func_177958_n(), pos.func_177952_p(), world);
    }

    public static BlockPos getGround(int x, int z, World world) {
        BlockPos skyPos = new BlockPos(x, world.func_72800_K(), z);
        while ((!world.func_180495_p(skyPos).func_185914_p() || WorldGenGorgonTemple.canHeightSkipBlock(skyPos, world)) && skyPos.func_177956_o() > 1) {
            skyPos = skyPos.func_177977_b();
        }
        return skyPos;
    }

    private static boolean canHeightSkipBlock(BlockPos pos, World world) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof BlockLog || state.func_177230_c() instanceof BlockLeaves || state.func_177230_c() instanceof BlockLiquid;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        position = position.func_177982_a(rand.nextInt(8) - 4, 1, rand.nextInt(8) - 4);
        MinecraftServer server = worldIn.func_73046_m();
        BlockPos height = WorldGenGorgonTemple.getGround(position, worldIn);
        IBlockState dirt = worldIn.func_180495_p(height.func_177979_c(2));
        TemplateManager templateManager = worldIn.func_72860_G().func_186340_h();
        Template template = templateManager.func_186237_a(server, STRUCTURE);
        PlacementSettings settings = new PlacementSettings().func_186220_a(WorldGenGorgonTemple.getRotationFromFacing(this.facing));
        BlockPos pos = height.func_177967_a(this.facing, template.func_186259_a().func_177952_p() / 2).func_177967_a(this.facing.func_176735_f(), template.func_186259_a().func_177958_n() / 2);
        if (this.checkIfCanGenAt(worldIn, pos, template.func_186259_a().func_177958_n(), template.func_186259_a().func_177952_p(), this.facing)) {
            template.func_189960_a(worldIn, pos.func_177979_c(10), (ITemplateProcessor)new DreadRuinProcessor(position, settings, null), settings, 2);
        }
        return true;
    }

    public boolean checkIfCanGenAt(World world, BlockPos middle, int x, int z, EnumFacing facing) {
        return !WorldGenGorgonTemple.isPartOfRuin(world.func_180495_p(middle.func_177967_a(facing, z / 2))) && !WorldGenGorgonTemple.isPartOfRuin(world.func_180495_p(middle.func_177967_a(facing.func_176734_d(), z / 2))) && !WorldGenGorgonTemple.isPartOfRuin(world.func_180495_p(middle.func_177967_a(facing.func_176746_e(), x / 2))) && !WorldGenGorgonTemple.isPartOfRuin(world.func_180495_p(middle.func_177967_a(facing.func_176735_f(), x / 2)));
    }
}

