/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui.misc;

import com.feed_the_beast.ftblib.lib.client.CachedVertexData;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.gui.misc.ChunkSelectorMap;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.ChunkPos;

public class GuiChunkSelectorBase
extends GuiBase {
    public static final int TILE_SIZE = 12;
    private static final CachedVertexData GRID = new CachedVertexData(1, DefaultVertexFormats.field_181706_f);
    public int startX;
    public int startZ;
    private final MapButton[] mapButtons;
    private final Panel panelButtons;
    public int currentSelectionMode = -1;

    public GuiChunkSelectorBase() {
        this.startX = MathUtils.chunk(Minecraft.func_71410_x().field_71439_g.field_70165_t) - 7;
        this.startZ = MathUtils.chunk(Minecraft.func_71410_x().field_71439_g.field_70161_v) - 7;
        this.panelButtons = new Panel(this){

            @Override
            public void addWidgets() {
                GuiChunkSelectorBase.this.addCornerButtons(GuiChunkSelectorBase.this.panelButtons);
            }

            @Override
            public void alignWidgets() {
                int h = this.align(WidgetLayout.VERTICAL);
                int w = 0;
                for (Widget widget : this.widgets) {
                    w = Math.max(w, widget.width);
                }
                GuiChunkSelectorBase.this.panelButtons.setPosAndSize(this.getGui().width + 2, -2, w, h);
            }
        };
        this.mapButtons = new MapButton[225];
        for (int i = 0; i < this.mapButtons.length; ++i) {
            this.mapButtons[i] = new MapButton(this, i);
        }
    }

    @Override
    public boolean onInit() {
        ChunkSelectorMap.getMap().resetMap(this.startX, this.startZ);
        return true;
    }

    @Override
    public void addWidgets() {
        for (MapButton b : this.mapButtons) {
            this.add(b);
        }
        this.add(this.panelButtons);
    }

    @Override
    public void alignWidgets() {
        this.setSize(180, 180);
        this.panelButtons.alignWidgets();
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        int currentStartX = MathUtils.chunk(Minecraft.func_71410_x().field_71439_g.field_70165_t) - 7;
        int currentStartZ = MathUtils.chunk(Minecraft.func_71410_x().field_71439_g.field_70161_v) - 7;
        if (currentStartX != this.startX || currentStartZ != this.startZ) {
            this.startX = currentStartX;
            this.startZ = currentStartZ;
            for (int i = 0; i < this.mapButtons.length; ++i) {
                this.mapButtons[i] = new MapButton(this, i);
            }
            ChunkSelectorMap.getMap().resetMap(this.startX, this.startZ);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Color4I.BLACK.draw(x - 2, y - 2, w + 4, h + 4);
        ChunkSelectorMap.getMap().drawMap(this, x, y, this.startX, this.startZ);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (MapButton mapButton : this.mapButtons) {
            mapButton.draw(theme, mapButton.getX(), mapButton.getY(), mapButton.width, mapButton.height);
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_187441_d((float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_178969_c((double)this.mapButtons[0].getX(), (double)this.mapButtons[0].getY(), 0.0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!GuiChunkSelectorBase.isKeyDown(15)) {
            this.drawArea(tessellator, buffer);
        }
        GRID.draw(tessellator, buffer);
        buffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        if (this.currentSelectionMode != -1) {
            ArrayList<ChunkPos> c = new ArrayList<ChunkPos>();
            for (MapButton b : this.mapButtons) {
                if (!b.isSelected) continue;
                c.add(b.chunkPos);
                b.isSelected = false;
            }
            this.onChunksSelected(c);
            this.currentSelectionMode = -1;
        }
    }

    @Override
    public void drawForeground(Theme theme, int x, int y, int w, int h) {
        int i;
        int lineSpacing = theme.getFontHeight() + 1;
        ArrayList<String> tempTextList = new ArrayList<String>();
        this.addCornerText(tempTextList, Corner.BOTTOM_RIGHT);
        for (i = 0; i < tempTextList.size(); ++i) {
            String s = (String)tempTextList.get(i);
            theme.drawString(s, this.getScreen().func_78326_a() - theme.getStringWidth(s) - 2, this.getScreen().func_78328_b() - (tempTextList.size() - i) * lineSpacing, 2);
        }
        tempTextList.clear();
        this.addCornerText(tempTextList, Corner.BOTTOM_LEFT);
        for (i = 0; i < tempTextList.size(); ++i) {
            theme.drawString((String)tempTextList.get(i), 2, this.getScreen().func_78328_b() - (tempTextList.size() - i) * lineSpacing, 2);
        }
        tempTextList.clear();
        this.addCornerText(tempTextList, Corner.TOP_LEFT);
        for (i = 0; i < tempTextList.size(); ++i) {
            theme.drawString((String)tempTextList.get(i), 2, 2 + i * lineSpacing, 2);
        }
        super.drawForeground(theme, x, y, w, h);
    }

    public int getSelectionMode(MouseButton button) {
        return -1;
    }

    public void onChunksSelected(Collection<ChunkPos> chunks) {
    }

    public void drawArea(Tessellator tessellator, BufferBuilder buffer) {
    }

    public void addCornerButtons(Panel panel) {
    }

    public void addCornerText(List<String> list, Corner corner) {
    }

    public void addButtonText(MapButton button, List<String> list) {
    }

    static {
        GuiChunkSelectorBase.GRID.color.set(128, 128, 128, 50);
        for (int x = 0; x <= 15; ++x) {
            GRID.pos(x * 12, 0.0);
            GRID.pos(x * 12, 180.0, 0.0);
        }
        for (int y = 0; y <= 15; ++y) {
            GRID.pos(0.0, y * 12, 0.0);
            GRID.pos(180.0, y * 12, 0.0);
        }
    }

    public static class MapButton
    extends Button {
        public final GuiChunkSelectorBase gui;
        public final ChunkPos chunkPos;
        public final int index;
        private boolean isSelected = false;

        private MapButton(GuiChunkSelectorBase g, int i) {
            super(g);
            this.gui = g;
            this.index = i;
            this.setPosAndSize(this.index % 15 * 12, this.index / 15 * 12, 12, 12);
            this.chunkPos = new ChunkPos(this.gui.startX + i % 15, this.gui.startZ + i / 15);
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            this.gui.currentSelectionMode = this.gui.getSelectionMode(button);
            if (this.gui.currentSelectionMode == -1) {
                this.gui.onChunksSelected(Collections.singleton(this.chunkPos));
            }
        }

        @Override
        public void addMouseOverText(List<String> list) {
            this.gui.addButtonText(this, list);
        }

        @Override
        public void draw(Theme theme, int x, int y, int w, int h) {
            if (!this.isSelected && this.gui.currentSelectionMode != -1 && this.gui.isMouseOver(this)) {
                this.isSelected = true;
            }
            if (this.isSelected || this.gui.isMouseOver(this)) {
                Color4I.WHITE.withAlpha(33).draw(x, y, 12, 12);
            }
        }
    }

    protected static enum Corner {
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP_LEFT;

    }
}

