/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.OrbisLibCapabilities;
import com.gildedgames.orbis.lib.world.data.IWorldDataManagerContainer;
import com.gildedgames.orbis.lib.world.data.WorldDataManagerContainer;
import com.gildedgames.orbis.lib.world.data.WorldDataManagerContainerProvider;
import com.gildedgames.orbis.lib.world.instances.IPlayerInstances;
import com.gildedgames.orbis.lib.world.instances.PlayerInstances;
import com.gildedgames.orbis.lib.world.instances.PlayerInstancesProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class CapabilityManagerOrbisLib {
    public static void init() {
        CapabilityManager.INSTANCE.register(IPlayerInstances.class, (Capability.IStorage)new PlayerInstances.Storage(), PlayerInstances::new);
        CapabilityManager.INSTANCE.register(IWorldDataManagerContainer.class, (Capability.IStorage)new WorldDataManagerContainer.Storage(), WorldDataManagerContainer::new);
    }

    @SubscribeEvent
    public static void onWorldAttachCapability(AttachCapabilitiesEvent<World> event) {
        World world = (World)event.getObject();
        if (world.field_72995_K) {
            return;
        }
        event.addCapability(OrbisLib.getResource("WorldData"), (ICapabilityProvider)new WorldDataManagerContainerProvider((World)event.getObject()));
    }

    @SubscribeEvent
    public static void onEntityLoad(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() == null) {
            return;
        }
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(OrbisLib.getResource("PlayerInstances"), (ICapabilityProvider)new PlayerInstancesProvider((EntityPlayer)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        IPlayerInstances oldPlayer = OrbisLib.instances().getPlayer(event.getOriginal());
        if (oldPlayer != null) {
            IPlayerInstances newPlayer = OrbisLib.instances().getPlayer((EntityPlayer)event.getEntity());
            Capability.IStorage storage = OrbisLibCapabilities.PLAYER_INSTANCES.getStorage();
            NBTBase state = storage.writeNBT(OrbisLibCapabilities.PLAYER_INSTANCES, (Object)oldPlayer, null);
            storage.readNBT(OrbisLibCapabilities.PLAYER_INSTANCES, (Object)newPlayer, null, state);
        }
    }
}

