/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib;

import com.gildedgames.orbis.lib.util.io.IClassSerializer;
import com.gildedgames.orbis.lib.util.io.IClassSerializerRegistry;
import com.gildedgames.orbis.lib.util.io.Instantiator;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.gildedgames.orbis.lib.util.mc.NBTHelper;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class IOHelper
implements IClassSerializerRegistry {
    public BiMap<String, IClassSerializer> idToSerializer = HashBiMap.create();

    public static <T extends NBT> void register(IClassSerializer s, int id, Class<T> clazz) {
        s.register(id, clazz, new Instantiator<T>(clazz));
    }

    public NBTTagCompound write(NBT nbt) {
        return NBTHelper.write(nbt);
    }

    public <T extends NBT> T read(NBTTagCompound tag) {
        return NBTHelper.read(tag);
    }

    public <T extends NBT> T read(World world, NBTTagCompound tag) {
        return NBTHelper.read(world, tag);
    }

    @Override
    public void register(IClassSerializer serializer) {
        this.idToSerializer.put((Object)serializer.identifier(), (Object)serializer);
    }

    @Override
    public IClassSerializer findSerializer(String id) {
        return (IClassSerializer)this.idToSerializer.get((Object)id);
    }

    @Override
    public IClassSerializer findSerializer(NBT nbt) {
        return this.findSerializer(nbt.getClass());
    }

    @Override
    public IClassSerializer findSerializer(Class<? extends NBT> clazz) {
        for (IClassSerializer s : this.idToSerializer.values()) {
            if (!s.isRegistered(clazz)) continue;
            return s;
        }
        throw new RuntimeException("This object has not been registered to a serializer: " + clazz);
    }

    @Override
    public String findID(IClassSerializer serializer) {
        return (String)this.idToSerializer.inverse().get((Object)serializer);
    }
}

