/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib;

import com.gildedgames.orbis.lib.CapabilityManagerOrbisLib;
import com.gildedgames.orbis.lib.IOrbisServices;
import com.gildedgames.orbis.lib.OrbisServices;
import com.gildedgames.orbis.lib.client.PartialTicks;
import com.gildedgames.orbis.lib.network.INetworkMultipleParts;
import com.gildedgames.orbis.lib.world.WorldObjectManagerEvents;
import com.gildedgames.orbis.lib.world.data.WorldDataManagerContainerEvents;
import com.gildedgames.orbis.lib.world.instances.IInstanceRegistry;
import java.io.File;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(name="OrbisLib", modid="orbis-lib", version="0.2.0", certificateFingerprint="db341c083b1b8ce9160a769b569ef6737b3f4cdf", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class OrbisLib {
    public static final String MOD_NAME = "OrbisLib";
    public static final String MOD_ID = "orbis-lib";
    public static final String MOD_VERSION = "0.2.0";
    public static final String MOD_FINGERPRINT = "db341c083b1b8ce9160a769b569ef6737b3f4cdf";
    public static final Logger LOGGER = LogManager.getLogger((String)"OrbisLib");
    @Mod.Instance(value="orbis-lib")
    public static OrbisLib INSTANCE;
    private static IOrbisServices services;
    private static boolean loadedInstances;

    public static boolean isClient() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    public static boolean isServer() {
        return FMLCommonHandler.instance().getSide().isServer();
    }

    public static IOrbisServices services() {
        if (services == null) {
            services = new OrbisServices();
            MinecraftForge.EVENT_BUS.register((Object)OrbisLib.services().instances());
            MinecraftForge.EVENT_BUS.register(WorldObjectManagerEvents.class);
            MinecraftForge.EVENT_BUS.register(WorldDataManagerContainerEvents.class);
            MinecraftForge.EVENT_BUS.register(PartialTicks.class);
        }
        return services;
    }

    public static INetworkMultipleParts network() {
        return OrbisLib.services().network();
    }

    public static IInstanceRegistry instances() {
        return OrbisLib.services().instances();
    }

    public static File getWorldDirectory() {
        return DimensionManager.getCurrentSaveRootDirectory();
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static String getPath(String name) {
        return "orbis-lib:" + name;
    }

    @Mod.EventHandler
    public void onFMLInit(FMLInitializationEvent event) {
        CapabilityManagerOrbisLib.init();
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        OrbisLib.instances().saveAllInstancesToDisk();
        loadedInstances = false;
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent event) {
        OrbisLib.instances().cleanup();
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        if (!loadedInstances) {
            OrbisLib.instances().loadAllInstancesFromDisk();
            loadedInstances = true;
        }
    }
}

