/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib;

import com.gildedgames.orbis.lib.IOHelper;
import com.gildedgames.orbis.lib.IOrbisServices;
import com.gildedgames.orbis.lib.IOrbisServicesListener;
import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.OrbisLibCapabilities;
import com.gildedgames.orbis.lib.block.BlockDataContainer;
import com.gildedgames.orbis.lib.block.BlockDataContainerDefaultVoid;
import com.gildedgames.orbis.lib.block.BlockDataWithConditions;
import com.gildedgames.orbis.lib.block.BlockFilter;
import com.gildedgames.orbis.lib.block.BlockFilterLayer;
import com.gildedgames.orbis.lib.core.BlockDataChunk;
import com.gildedgames.orbis.lib.core.CreationData;
import com.gildedgames.orbis.lib.core.GameRegistrar;
import com.gildedgames.orbis.lib.core.PlacedBlueprint;
import com.gildedgames.orbis.lib.core.baking.BakedEntitySpawn;
import com.gildedgames.orbis.lib.core.registry.IOrbisDefinitionRegistry;
import com.gildedgames.orbis.lib.core.tree.ConditionLink;
import com.gildedgames.orbis.lib.core.tree.LayerLink;
import com.gildedgames.orbis.lib.core.tree.NodeMultiParented;
import com.gildedgames.orbis.lib.core.tree.NodeTree;
import com.gildedgames.orbis.lib.core.variables.GuiVarBlueprintVariable;
import com.gildedgames.orbis.lib.core.variables.GuiVarBoolean;
import com.gildedgames.orbis.lib.core.variables.GuiVarDouble;
import com.gildedgames.orbis.lib.core.variables.GuiVarDropdown;
import com.gildedgames.orbis.lib.core.variables.GuiVarFloat;
import com.gildedgames.orbis.lib.core.variables.GuiVarFloatRange;
import com.gildedgames.orbis.lib.core.variables.GuiVarInteger;
import com.gildedgames.orbis.lib.core.variables.GuiVarItemStack;
import com.gildedgames.orbis.lib.core.variables.GuiVarString;
import com.gildedgames.orbis.lib.core.variables.conditions.GuiConditionCheckBlueprintVariable;
import com.gildedgames.orbis.lib.core.variables.conditions.GuiConditionCheckEntranceTriggerId;
import com.gildedgames.orbis.lib.core.variables.conditions.GuiConditionPercentage;
import com.gildedgames.orbis.lib.core.variables.conditions.GuiConditionRatio;
import com.gildedgames.orbis.lib.core.variables.post_resolve_actions.PostResolveActionMutateBlueprintVariable;
import com.gildedgames.orbis.lib.core.variables.post_resolve_actions.PostResolveActionSpawnEntities;
import com.gildedgames.orbis.lib.core.variables.var_comparators.NumberDoesntEqual;
import com.gildedgames.orbis.lib.core.variables.var_comparators.NumberEquals;
import com.gildedgames.orbis.lib.core.variables.var_comparators.NumberGreaterThan;
import com.gildedgames.orbis.lib.core.variables.var_comparators.NumberGreaterThanOrEqual;
import com.gildedgames.orbis.lib.core.variables.var_comparators.NumberLessThan;
import com.gildedgames.orbis.lib.core.variables.var_comparators.NumberLessThanOrEqual;
import com.gildedgames.orbis.lib.core.variables.var_mutators.NumberDecrease;
import com.gildedgames.orbis.lib.core.variables.var_mutators.NumberDivide;
import com.gildedgames.orbis.lib.core.variables.var_mutators.NumberIncrease;
import com.gildedgames.orbis.lib.core.variables.var_mutators.NumberMultiply;
import com.gildedgames.orbis.lib.core.variables.var_mutators.NumberSet;
import com.gildedgames.orbis.lib.core.world_objects.BlueprintRegion;
import com.gildedgames.orbis.lib.data.DataCondition;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintData;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintDataHolder;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintMetadata;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintStackerData;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintVariable;
import com.gildedgames.orbis.lib.data.framework.FrameworkData;
import com.gildedgames.orbis.lib.data.framework.FrameworkNode;
import com.gildedgames.orbis.lib.data.json.JsonData;
import com.gildedgames.orbis.lib.data.management.IDataIdentifier;
import com.gildedgames.orbis.lib.data.management.IDataMetadata;
import com.gildedgames.orbis.lib.data.management.IProject;
import com.gildedgames.orbis.lib.data.management.IProjectIdentifier;
import com.gildedgames.orbis.lib.data.management.IProjectManager;
import com.gildedgames.orbis.lib.data.management.IProjectMetadata;
import com.gildedgames.orbis.lib.data.management.impl.DataCache;
import com.gildedgames.orbis.lib.data.management.impl.DataIdentifier;
import com.gildedgames.orbis.lib.data.management.impl.DataMetadata;
import com.gildedgames.orbis.lib.data.management.impl.GenericSerializer;
import com.gildedgames.orbis.lib.data.management.impl.OrbisLootTableCache;
import com.gildedgames.orbis.lib.data.management.impl.OrbisProject;
import com.gildedgames.orbis.lib.data.management.impl.OrbisProjectCache;
import com.gildedgames.orbis.lib.data.management.impl.OrbisProjectManager;
import com.gildedgames.orbis.lib.data.management.impl.ProjectIdentifier;
import com.gildedgames.orbis.lib.data.management.impl.ProjectInformation;
import com.gildedgames.orbis.lib.data.management.impl.ProjectMetadata;
import com.gildedgames.orbis.lib.data.pathway.Entrance;
import com.gildedgames.orbis.lib.data.pathway.PathwayData;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.data.schedules.BlockStateRecord;
import com.gildedgames.orbis.lib.data.schedules.FilterOptions;
import com.gildedgames.orbis.lib.data.schedules.FilterRecord;
import com.gildedgames.orbis.lib.data.schedules.PostGenReplaceLayer;
import com.gildedgames.orbis.lib.data.schedules.ScheduleBlueprint;
import com.gildedgames.orbis.lib.data.schedules.ScheduleEntranceHolder;
import com.gildedgames.orbis.lib.data.schedules.ScheduleLayer;
import com.gildedgames.orbis.lib.data.schedules.ScheduleLayerOptions;
import com.gildedgames.orbis.lib.data.schedules.ScheduleRecord;
import com.gildedgames.orbis.lib.data.schedules.ScheduleRegion;
import com.gildedgames.orbis.lib.data.shapes.ConeShape;
import com.gildedgames.orbis.lib.data.shapes.CuboidShape;
import com.gildedgames.orbis.lib.data.shapes.CylinderShape;
import com.gildedgames.orbis.lib.data.shapes.DomeShape;
import com.gildedgames.orbis.lib.data.shapes.LineShape;
import com.gildedgames.orbis.lib.data.shapes.PyramidShape;
import com.gildedgames.orbis.lib.data.shapes.SphereShape;
import com.gildedgames.orbis.lib.inventory.InventorySpawnEggs;
import com.gildedgames.orbis.lib.network.INetworkMultipleParts;
import com.gildedgames.orbis.lib.network.NetworkMultipleParts;
import com.gildedgames.orbis.lib.network.instances.PacketRegisterDimension;
import com.gildedgames.orbis.lib.network.instances.PacketRegisterInstance;
import com.gildedgames.orbis.lib.network.instances.PacketUnregisterDimension;
import com.gildedgames.orbis.lib.util.io.SimpleSerializer;
import com.gildedgames.orbis.lib.util.mc.BlockPosDimension;
import com.gildedgames.orbis.lib.world.data.IWorldDataManager;
import com.gildedgames.orbis.lib.world.data.IWorldDataManagerContainer;
import com.gildedgames.orbis.lib.world.instances.IInstanceRegistry;
import com.gildedgames.orbis.lib.world.instances.InstanceRegistryImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OrbisServices
implements IOrbisServices {
    public final Logger logger = LogManager.getLogger((String)"OrbisLib");
    private final Map<String, IOrbisDefinitionRegistry> idToRegistry = Maps.newHashMap();
    private final String baseFolder = "orbis";
    private final Map<String, IProject> loadedProjects = Maps.newHashMap();
    private final GameRegistrar gameRegistrar = new GameRegistrar();
    private List<IOrbisServicesListener> listeners = Lists.newArrayList();
    private IProjectManager projectManager;
    private IOHelper io;
    private INetworkMultipleParts network;
    private IInstanceRegistry instancesRegistry = new InstanceRegistryImpl();
    private Object mod;
    private String archiveBaseName;
    private OrbisLootTableCache lootTableCache = new OrbisLootTableCache();
    private boolean scanAndCacheProjectsOnStartup;
    private Gson gson;

    public OrbisServices() {
        this.network = new NetworkMultipleParts("orbis-lib");
        this.network.reg(PacketRegisterDimension.Handler.class, PacketRegisterDimension.class, Side.CLIENT);
        this.network.reg(PacketUnregisterDimension.Handler.class, PacketUnregisterDimension.class, Side.CLIENT);
        this.network.reg(PacketRegisterInstance.Handler.class, PacketRegisterInstance.class, Side.CLIENT);
        this.gson = new GsonBuilder().registerTypeAdapter(IProjectIdentifier.class, new GenericSerializer(ProjectIdentifier.class)).registerTypeAdapter(IDataIdentifier.class, new GenericSerializer(DataIdentifier.class)).registerTypeAdapter(IDataMetadata.class, new GenericSerializer(DataMetadata.class)).registerTypeAdapter(IProjectMetadata.class, new GenericSerializer(ProjectMetadata.class)).create();
    }

    @Override
    @Nullable
    public IOrbisDefinitionRegistry findDefinitionRegistry(String registryId) {
        IOrbisDefinitionRegistry registry = this.idToRegistry.get(registryId);
        return registry;
    }

    @Override
    public void register(IOrbisDefinitionRegistry registry) {
        if (registry == null) {
            throw new RuntimeException("Registry provided is null! Aborting.");
        }
        this.idToRegistry.put(registry.getRegistryId(), registry);
    }

    @Override
    @Nullable
    public IProject loadProject(MinecraftServer server, ResourceLocation location, Object mod, String archiveBaseName) {
        return this.get(server, location, mod, archiveBaseName);
    }

    @Override
    public IOHelper io() {
        if (this.io == null) {
            this.io = new IOHelper();
            SimpleSerializer s = new SimpleSerializer("orbis_api");
            IOHelper.register(s, 0, Region.class);
            IOHelper.register(s, 1, BlueprintData.class);
            IOHelper.register(s, 3, BlockDataContainer.class);
            IOHelper.register(s, 4, SphereShape.class);
            IOHelper.register(s, 5, LineShape.class);
            IOHelper.register(s, 6, BlockFilter.class);
            IOHelper.register(s, 7, BlockFilterLayer.class);
            IOHelper.register(s, 8, BlockDataWithConditions.class);
            IOHelper.register(s, 9, DataCondition.class);
            IOHelper.register(s, 10, DataMetadata.class);
            IOHelper.register(s, 11, ProjectIdentifier.class);
            IOHelper.register(s, 12, OrbisProject.class);
            IOHelper.register(s, 13, DataIdentifier.class);
            IOHelper.register(s, 14, OrbisProjectCache.class);
            IOHelper.register(s, 15, ProjectMetadata.class);
            IOHelper.register(s, 16, BlockDataContainerDefaultVoid.class);
            IOHelper.register(s, 17, CreationData.class);
            IOHelper.register(s, 18, PyramidShape.class);
            IOHelper.register(s, 19, ConeShape.class);
            IOHelper.register(s, 20, CylinderShape.class);
            IOHelper.register(s, 21, DomeShape.class);
            IOHelper.register(s, 22, CuboidShape.class);
            IOHelper.register(s, 23, DataCache.class);
            IOHelper.register(s, 24, ScheduleLayer.class);
            IOHelper.register(s, 25, FilterRecord.class);
            IOHelper.register(s, 26, Entrance.class);
            IOHelper.register(s, 27, BlueprintRegion.class);
            IOHelper.register(s, 28, FrameworkNode.class);
            IOHelper.register(s, 29, ScheduleRegion.class);
            IOHelper.register(s, 30, InventorySpawnEggs.class);
            IOHelper.register(s, 31, ScheduleRecord.class);
            IOHelper.register(s, 32, ScheduleBlueprint.class);
            IOHelper.register(s, 33, BlockPosDimension.class);
            IOHelper.register(s, 34, FilterOptions.class);
            IOHelper.register(s, 35, FrameworkData.class);
            IOHelper.register(s, 36, PlacedBlueprint.class);
            IOHelper.register(s, 37, PathwayData.class);
            IOHelper.register(s, 38, BlueprintDataHolder.class);
            IOHelper.register(s, 39, BlueprintStackerData.class);
            IOHelper.register(s, 40, PostGenReplaceLayer.class);
            IOHelper.register(s, 41, GuiVarBoolean.class);
            IOHelper.register(s, 42, GuiVarDouble.class);
            IOHelper.register(s, 43, GuiVarFloat.class);
            IOHelper.register(s, 44, GuiVarFloatRange.class);
            IOHelper.register(s, 45, GuiVarInteger.class);
            IOHelper.register(s, 46, GuiVarString.class);
            IOHelper.register(s, 47, GuiConditionRatio.class);
            IOHelper.register(s, 48, NodeMultiParented.class);
            IOHelper.register(s, 49, NodeTree.class);
            IOHelper.register(s, 50, ConditionLink.class);
            IOHelper.register(s, 51, LayerLink.class);
            IOHelper.register(s, 52, GuiConditionPercentage.class);
            IOHelper.register(s, 53, BlueprintVariable.class);
            IOHelper.register(s, 54, GuiConditionCheckBlueprintVariable.class);
            IOHelper.register(s, 55, GuiVarBlueprintVariable.class);
            IOHelper.register(s, 56, GuiVarDropdown.class);
            IOHelper.register(s, 57, NumberSet.class);
            IOHelper.register(s, 58, NumberMultiply.class);
            IOHelper.register(s, 59, NumberIncrease.class);
            IOHelper.register(s, 60, NumberDivide.class);
            IOHelper.register(s, 61, NumberDecrease.class);
            IOHelper.register(s, 62, NumberLessThanOrEqual.class);
            IOHelper.register(s, 63, NumberLessThan.class);
            IOHelper.register(s, 64, NumberGreaterThanOrEqual.class);
            IOHelper.register(s, 65, NumberGreaterThan.class);
            IOHelper.register(s, 66, NumberEquals.class);
            IOHelper.register(s, 67, NumberDoesntEqual.class);
            IOHelper.register(s, 68, GuiVarString.Equals.class);
            IOHelper.register(s, 69, GuiVarString.DoesntEqual.class);
            IOHelper.register(s, 70, GuiVarString.Contains.class);
            IOHelper.register(s, 71, GuiVarString.Clear.class);
            IOHelper.register(s, 72, GuiVarString.Replace.class);
            IOHelper.register(s, 73, GuiVarString.Concatenate.class);
            IOHelper.register(s, 74, GuiVarString.Set.class);
            IOHelper.register(s, 75, GuiVarBoolean.EqualsTrue.class);
            IOHelper.register(s, 76, GuiVarBoolean.EqualsFalse.class);
            IOHelper.register(s, 77, GuiVarBoolean.Set.class);
            IOHelper.register(s, 79, PostResolveActionMutateBlueprintVariable.class);
            IOHelper.register(s, 80, BlockDataChunk.class);
            IOHelper.register(s, 82, BakedEntitySpawn.class);
            IOHelper.register(s, 83, BlockStateRecord.class);
            IOHelper.register(s, 84, ScheduleLayerOptions.class);
            IOHelper.register(s, 85, BlueprintMetadata.class);
            IOHelper.register(s, 87, PostResolveActionSpawnEntities.class);
            IOHelper.register(s, 88, GuiVarItemStack.class);
            IOHelper.register(s, 89, JsonData.class);
            IOHelper.register(s, 90, GuiConditionCheckEntranceTriggerId.class);
            IOHelper.register(s, 91, ProjectInformation.class);
            IOHelper.register(s, 92, ScheduleEntranceHolder.class);
            this.io.register(s);
        }
        return this.io;
    }

    @Nullable
    private IProject get(@Nullable MinecraftServer server, ResourceLocation projectPath, Object mod, String archiveBaseName) {
        String s = projectPath.func_110623_a();
        if (this.loadedProjects.containsKey(s)) {
            return this.loadedProjects.get(s);
        }
        if (server == null) {
            this.readProjectFromJar(mod, archiveBaseName, projectPath);
        } else {
            this.readProject(mod, archiveBaseName, projectPath);
        }
        return this.loadedProjects.getOrDefault(s, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readProject(Object mod, String archiveBaseName, ResourceLocation server) {
        boolean bl;
        String s = server.func_110623_a();
        File file1 = new File(this.baseFolder, s + File.separator + "project_data.json");
        if (!file1.exists()) {
            return this.readProjectFromJar(mod, archiveBaseName, server);
        }
        FileInputStream inputstream = null;
        try {
            inputstream = new FileInputStream(file1);
            this.readProjectFromStream(mod, archiveBaseName, s, inputstream, new File(this.baseFolder, s + "/").toURI());
            bl = true;
        }
        catch (Throwable var10) {
            boolean flag;
            try {
                flag = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputstream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputstream);
            return flag;
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readProjectFromJar(Object mod, String archiveBaseName, ResourceLocation id) {
        String s = id.func_110624_b();
        String s1 = id.func_110623_a();
        InputStream inputstream = null;
        try {
            inputstream = MinecraftServer.class.getResourceAsStream("/assets/" + s + "/orbis/" + s1 + "/project_data.json");
            this.readProjectFromStream(mod, archiveBaseName, s1, inputstream, URI.create("/assets/" + s + "/orbis/" + s1 + "/"));
            boolean bl = true;
            IOUtils.closeQuietly((InputStream)inputstream);
            return bl;
        }
        catch (IOException var10) {
            OrbisLib.LOGGER.error((Object)var10);
        }
        finally {
            IOUtils.closeQuietly(inputstream);
        }
        return false;
    }

    private void readProjectFromStream(Object mod, String archiveBaseName, String id, InputStream stream, URI location) throws IOException {
        IProject project = this.getProjectManager().getProjectFactory().get();
        try (InputStreamReader reader = new InputStreamReader(stream);){
            ProjectInformation info = (ProjectInformation)this.gson.fromJson((Reader)reader, ProjectInformation.class);
            project.setInfo(info);
        }
        project.setJarLocation(location);
        project.setModAndArchiveLoadingFrom(mod, archiveBaseName);
        project.setIsModProject(true);
        project.loadAndCacheData();
        this.loadedProjects.put(id, project);
    }

    @Override
    public Gson getGson() {
        return this.gson;
    }

    @Override
    public OrbisLootTableCache lootTableCache() {
        return this.lootTableCache;
    }

    @Override
    public INetworkMultipleParts network() {
        return this.network;
    }

    @Override
    public void listen(IOrbisServicesListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public boolean unlisten(IOrbisServicesListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public GameRegistrar registrar() {
        return this.gameRegistrar;
    }

    @Override
    public synchronized void startProjectManager() {
        if (this.projectManager != null) {
            return;
        }
        if (OrbisLib.isClient()) {
            ServerData data = Minecraft.func_71410_x().func_147104_D();
            if (data != null) {
                this.projectManager = new OrbisProjectManager(new File(Minecraft.func_71410_x().field_71412_D, "orbis/servers/" + data.field_78845_b.replace(":", "_") + "/projects/"), Collections.emptyList(), this.mod, this.archiveBaseName, OrbisProject::new);
            } else {
                File extraProjectSourcesFile = new File(Minecraft.func_71410_x().field_71412_D, "orbis/extra_project_sources.json");
                List<Object> extraProjectSources = null;
                if (extraProjectSourcesFile.exists()) {
                    try (FileInputStream in = new FileInputStream(extraProjectSourcesFile);
                         InputStreamReader reader = new InputStreamReader(in);){
                        extraProjectSources = Lists.newArrayList();
                        try {
                            List sources = (List)this.gson.fromJson((Reader)reader, new TypeToken<List<String>>(){}.getType());
                            OrbisLib.LOGGER.info("Succesfully loaded extra_project_sources.json:");
                            for (String source : sources) {
                                File file = new File(source);
                                if (file.exists()) {
                                    extraProjectSources.add(file);
                                    OrbisLib.LOGGER.info("SUCCESS: " + source);
                                    continue;
                                }
                                OrbisLib.LOGGER.info("FAILED: " + source);
                            }
                        }
                        catch (JsonIOException | JsonSyntaxException e) {
                            OrbisLib.LOGGER.error("Could not load extra_project_sources.json, syntax error or IO exception.");
                            extraProjectSources = Collections.emptyList();
                        }
                    }
                    catch (IOException e) {
                        OrbisLib.LOGGER.error((Object)e);
                    }
                } else {
                    extraProjectSources = Collections.emptyList();
                }
                this.projectManager = new OrbisProjectManager(new File(Minecraft.func_71410_x().field_71412_D, "orbis/local/projects/"), extraProjectSources, this.mod, this.archiveBaseName, OrbisProject::new);
            }
        }
        if (this.projectManager == null) {
            this.projectManager = new OrbisProjectManager(new File(DimensionManager.getCurrentSaveRootDirectory(), "orbis/projects/"), Collections.emptyList(), this.mod, this.archiveBaseName, OrbisProject::new);
        }
        this.listeners.forEach(l -> l.onStartProjectManager(this.projectManager));
        if (this.scanAndCacheProjectsOnStartup) {
            this.projectManager.scanAndCacheProjects();
        }
    }

    @Override
    public synchronized void stopProjectManager() {
        if (this.projectManager != null) {
            this.projectManager.flushProjects();
            this.projectManager = null;
        }
    }

    @Override
    public IInstanceRegistry instances() {
        return this.instancesRegistry;
    }

    @Override
    public IWorldDataManager getWorldDataManager(World world) {
        return ((IWorldDataManagerContainer)world.getCapability(OrbisLibCapabilities.WORLD_DATA, null)).get();
    }

    @Override
    public synchronized IProjectManager getProjectManager() {
        this.verifyProjectManagerStarted();
        return this.projectManager;
    }

    @Override
    public void verifyProjectManagerStarted() {
        if (this.projectManager == null) {
            this.startProjectManager();
        }
    }

    @Override
    public void setProjectManagerInitSource(Object mod, String archiveBaseName) {
        this.mod = mod;
        this.archiveBaseName = archiveBaseName;
    }

    @Override
    public void enableScanAndCacheProjectsOnStartup(boolean flag) {
        this.scanAndCacheProjectsOnStartup = flag;
    }
}

