/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib;

import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.storage.loot.LootEntry;

public class ReflectionOrbis {
    public static final Method POPULATE;
    public static final Method GENERATE_HEIGHT_MAP;
    public static final ReflectionEntry LOOT_ENTRIES;
    public static final ReflectionEntry POOL_CONDITIONS;
    public static final ReflectionEntry ROLLS;
    public static final ReflectionEntry BONUS_ROLLS;
    public static final ReflectionEntry NAME;
    public static final Method SERIALIZE;
    public static final ReflectionEntry ENTRY_NAME;
    public static final ReflectionEntry WEIGHT;
    public static final ReflectionEntry QUALITY;
    public static final ReflectionEntry CONDITIONS;

    public static Field getField(Class clazz, String ... names) {
        for (Field field : clazz.getDeclaredFields()) {
            for (String name : names) {
                if (!field.getName().equals(name)) continue;
                field.setAccessible(true);
                return field;
            }
        }
        throw new RuntimeException("Couldn't find field");
    }

    public static Method getMethod(Class clazz, Class<?>[] args, String ... names) {
        for (Method method : clazz.getDeclaredMethods()) {
            for (String name : names) {
                if (!method.getName().equals(name)) continue;
                Class<?>[] matching = method.getParameterTypes();
                boolean matches = true;
                if (matching.length != args.length) {
                    matches = false;
                } else {
                    for (int i = 0; i < args.length; ++i) {
                        if (matching[i] == args[i]) continue;
                        matches = false;
                        break;
                    }
                }
                if (!matches) continue;
                method.setAccessible(true);
                return method;
            }
        }
        throw new RuntimeException("Couldn't find method");
    }

    public static void invokeMethod(Method method, Object obj, Object ... args) {
        try {
            method.invoke(obj, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to invoke method through reflection", e);
        }
    }

    public static Object getValue(Field field, Object obj) {
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to fetch field value", e);
        }
    }

    public static void setValue(Field field, Object instance, Object value) {
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to fetch field value", e);
        }
    }

    static {
        LOOT_ENTRIES = new ReflectionEntry(new String[]{"lootEntries", "field_186453_a"});
        POOL_CONDITIONS = new ReflectionEntry(new String[]{"poolConditions", "field_186454_b"});
        ROLLS = new ReflectionEntry(new String[]{"rolls", "field_186455_c"});
        BONUS_ROLLS = new ReflectionEntry(new String[]{"bonusRolls", "field_186456_d"});
        NAME = new ReflectionEntry(new String[]{"name"});
        ENTRY_NAME = new ReflectionEntry(new String[]{"entryName"});
        WEIGHT = new ReflectionEntry(new String[]{"weight", "field_186364_c"});
        QUALITY = new ReflectionEntry(new String[]{"quality", "field_186365_d"});
        CONDITIONS = new ReflectionEntry(new String[]{"conditions", "field_186366_e"});
        POPULATE = ReflectionOrbis.getMethod(Chunk.class, new Class[]{IChunkGenerator.class}, "populate", "func_185931_b");
        GENERATE_HEIGHT_MAP = ReflectionOrbis.getMethod(Chunk.class, new Class[0], "generateHeightMap", "func_185978_a");
        SERIALIZE = ReflectionOrbis.getMethod(LootEntry.class, new Class[]{JsonObject.class, JsonSerializationContext.class}, "serialize", "func_186362_a");
    }

    public static class ReflectionEntry {
        private final String[] mappings;

        private ReflectionEntry(String ... mappings) {
            this.mappings = mappings;
        }

        public String[] getMappings() {
            return this.mappings;
        }
    }
}

