/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.block;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.core.exceptions.OrbisMissingModsException;
import com.gildedgames.orbis.lib.data.management.IData;
import com.gildedgames.orbis.lib.data.management.IDataMetadata;
import com.gildedgames.orbis.lib.data.management.impl.DataMetadata;
import com.gildedgames.orbis.lib.data.region.IDimensions;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.IShape;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.gildedgames.orbis.lib.world.IWorldObject;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockDataContainer
implements NBT,
IDimensions,
IData {
    private int[] blocks;
    private Int2ObjectOpenHashMap<TileEntityEntry> entities = new Int2ObjectOpenHashMap();
    private Int2ObjectOpenHashMap<IBlockState> idToState = new Int2ObjectOpenHashMap();
    private Object2IntOpenCustomHashMap<IBlockState> stateToId = new Object2IntOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<IBlockState>(){

        public int hashCode(IBlockState o) {
            return System.identityHashCode(o);
        }

        public boolean equals(IBlockState a, IBlockState b) {
            return a == b;
        }
    });
    private int width;
    private int height;
    private int length;
    private IDataMetadata metadata;
    private IBlockState defaultBlock;
    private int nextID;

    public BlockDataContainer(BlockDataContainer other, int width, int height, int length) {
        this.entities = new Int2ObjectOpenHashMap(this.entities);
        this.defaultBlock = other.defaultBlock;
        this.idToState = new Int2ObjectOpenHashMap(other.idToState);
        this.stateToId = new Object2IntOpenCustomHashMap(other.stateToId, other.stateToId.strategy());
        this.width = width;
        this.height = height;
        this.length = length;
        this.blocks = new int[this.getVolume()];
        this.nextID = other.nextID;
        this.metadata = other.metadata;
        Arrays.fill(this.blocks, -1);
    }

    public BlockDataContainer() {
        this(Blocks.field_150350_a.func_176223_P());
    }

    public BlockDataContainer(IBlockState defaultBlock) {
        if (defaultBlock == null) {
            throw new IllegalArgumentException("Default block cannot be null");
        }
        this.metadata = new DataMetadata();
        this.defaultBlock = defaultBlock;
        this.idToState.put(-1, (Object)this.defaultBlock);
        this.stateToId.put((Object)this.defaultBlock, -1);
        this.stateToId.defaultReturnValue(Integer.MIN_VALUE);
        this.idToState.defaultReturnValue(null);
    }

    public BlockDataContainer(IBlockState defaultBlock, int width, int height, int length) {
        this(defaultBlock);
        this.width = width;
        this.height = Math.min(256, height);
        this.length = length;
        this.blocks = new int[this.getVolume()];
        Arrays.fill(this.blocks, -1);
    }

    public BlockDataContainer(IBlockState defaultBlock, IRegion region) {
        this(defaultBlock, region.getWidth(), region.getHeight(), region.getLength());
    }

    public BlockDataContainer(int width, int height, int length) {
        this(Blocks.field_150350_a.func_176223_P(), width, height, length);
    }

    public BlockDataContainer(IRegion region) {
        this(Blocks.field_150350_a.func_176223_P(), region);
    }

    public static BlockDataContainer fromShape(World world, IShape shape) {
        IRegion bounding = shape.getBoundingBox();
        int minx = bounding.getMin().func_177958_n();
        int miny = bounding.getMin().func_177956_o();
        int minz = bounding.getMin().func_177952_p();
        BlockDataContainer container = new BlockDataContainer(bounding.getWidth(), bounding.getHeight(), bounding.getLength());
        for (BlockPos blockPos : shape.getShapeData()) {
            IBlockState state = world.func_180495_p(blockPos);
            BlockPos tr = blockPos.func_177982_a(-minx, -miny, -minz);
            container.setBlockState(state, tr);
            container.setTileEntity(world.func_175625_s(blockPos), tr);
        }
        return container;
    }

    public int getVolume() {
        return this.width * this.height * this.length;
    }

    private int getIndex(BlockPos pos) {
        return this.getIndex(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private int getIndex(int x, int y, int z) {
        return z + y * this.length + x * this.height * this.length;
    }

    private BlockPos fromIndex(int idx) {
        int x = idx / (this.height * this.length);
        int y = (idx -= x * this.height * this.length) / this.length;
        int z = idx % this.length;
        return new BlockPos(x, y, z);
    }

    public boolean isOutsideOfContainer(BlockPos pos) {
        int index = this.getIndex(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return index >= this.blocks.length || index < 0;
    }

    public IBlockState getBlockState(BlockPos pos) {
        return this.getBlockState(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public IBlockState getBlockState(int x, int y, int z) {
        return this.getBlockState(this.getIndex(x, y, z));
    }

    private IBlockState getBlockState(int index) {
        return (IBlockState)this.idToState.get(this.blocks[index]);
    }

    public void setBlockState(IBlockState state, int x, int y, int z) throws ArrayIndexOutOfBoundsException {
        this.setBlockState(state, this.getIndex(x, y, z));
    }

    private void setBlockState(IBlockState state, int index) {
        int value = this.stateToId.getInt((Object)state);
        if (value == this.stateToId.defaultReturnValue()) {
            value = this.nextID++;
            this.stateToId.put((Object)state, value);
            this.idToState.put(value, (Object)state);
        }
        this.blocks[index] = value;
    }

    public void setBlockState(IBlockState state, BlockPos pos) throws ArrayIndexOutOfBoundsException {
        this.setBlockState(state, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public void copyBlockStateWithRotation(BlockDataContainer data, int otherX, int otherY, int otherZ, int thisX, int thisY, int thisZ, Rotation rotation) {
        int block = data.blocks[data.getIndex(otherX, otherY, otherZ)];
        if (block == 0) {
            this.blocks[this.getIndex((int)thisX, (int)thisY, (int)thisZ)] = block;
        } else {
            IBlockState stateRotated;
            IBlockState state = (IBlockState)data.idToState.get(block);
            if (state == (stateRotated = state.func_185907_a(rotation))) {
                this.blocks[this.getIndex((int)thisX, (int)thisY, (int)thisZ)] = data.blocks[data.getIndex(otherX, otherY, otherZ)];
            } else {
                this.setBlockState(stateRotated, thisX, thisY, thisZ);
            }
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public IBlockState getDefaultBlock() {
        return this.defaultBlock;
    }

    @Override
    public void write(NBTTagCompound tag) {
        int nextLocalId = 0;
        Int2IntOpenHashMap blockToLocalId = new Int2IntOpenHashMap();
        tag.func_74768_a("width", this.getWidth());
        tag.func_74768_a("height", this.getHeight());
        tag.func_74768_a("length", this.getLength());
        byte[] blocks = new byte[this.getVolume()];
        byte[] addBlocks = null;
        byte[] metadata = new byte[this.getVolume()];
        Int2ObjectOpenHashMap identifiers = new Int2ObjectOpenHashMap();
        Int2ObjectOpenHashMap tileEntities = new Int2ObjectOpenHashMap();
        for (int i = 0; i < this.blocks.length; ++i) {
            TileEntityEntry tileEntity;
            int meta;
            int blockId;
            IBlockState state;
            if (this.blocks[i] >= 0) {
                int blockRaw = this.blocks[i];
                if (!blockToLocalId.containsKey(blockRaw)) {
                    int id = nextLocalId++;
                    blockToLocalId.put(blockRaw, id);
                }
                state = this.getBlockState(i);
                blockId = blockToLocalId.get(blockRaw);
                meta = state.func_177230_c().func_176201_c(state);
                if (!identifiers.containsKey(blockId)) {
                    ResourceLocation identifier = OrbisLib.services().registrar().getIdentifierFor(state.func_177230_c());
                    identifiers.put(blockId, (Object)identifier);
                }
            } else {
                state = this.defaultBlock;
                blockId = -1;
                meta = this.getDefaultBlock().func_177230_c().func_176201_c(this.getDefaultBlock());
            }
            if (blockId > 255) {
                byte result;
                if (addBlocks == null) {
                    addBlocks = new byte[(blocks.length >> 1) + 1];
                }
                int addBlocksIndex = i >> 1;
                addBlocks[addBlocksIndex] = (i & 1) == 0 ? (result = (byte)(addBlocks[addBlocksIndex] & 0xF0 | blockId >> 8 & 0xF)) : (result = (byte)(addBlocks[addBlocksIndex] & 0xF | (blockId >> 8 & 0xF) << 4));
            }
            blocks[i] = (byte)blockId;
            metadata[i] = (byte)meta;
            if (!state.func_177230_c().hasTileEntity(state) || (tileEntity = (TileEntityEntry)this.entities.get(i)) == null) continue;
            tileEntities.put(i, (Object)tileEntity.data);
        }
        NBTTagList identifierList = new NBTTagList();
        for (Map.Entry entry : identifiers.entrySet()) {
            NBTTagCompound data = new NBTTagCompound();
            ResourceLocation identifier = (ResourceLocation)entry.getValue();
            data.func_74778_a("mod", identifier.func_110624_b());
            data.func_74778_a("name", identifier.func_110623_a());
            data.func_74768_a("id", ((Integer)entry.getKey()).intValue());
            identifierList.func_74742_a((NBTBase)data);
        }
        tag.func_74782_a("identifiers", (NBTBase)identifierList);
        NBTTagList tileEntityList = new NBTTagList();
        for (Map.Entry entry : tileEntities.entrySet()) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74782_a("tileEnt", (NBTBase)entry.getValue());
            data.func_74768_a("orbisTEIndex", ((Integer)entry.getKey()).intValue());
            tileEntityList.func_74742_a((NBTBase)data);
        }
        tag.func_74782_a("tileEntities", (NBTBase)tileEntityList);
        tag.func_74773_a("blocks", blocks);
        tag.func_74773_a("metadata", metadata);
        tag.func_74757_a("addBlocks_null", addBlocks == null);
        if (addBlocks != null) {
            tag.func_74773_a("addBlocks", addBlocks);
        }
    }

    @Override
    public void read(NBTTagCompound tag) {
        byte[] addBlocks;
        Int2ObjectOpenHashMap localIdToBlock = new Int2ObjectOpenHashMap();
        localIdToBlock.put(-1, (Object)this.defaultBlock.func_177230_c());
        this.width = tag.func_74762_e("width");
        this.height = tag.func_74762_e("height");
        this.length = tag.func_74762_e("length");
        NBTTagList identifierList = tag.func_150295_c("identifiers", 10);
        HashSet<String> missingMods = new HashSet<String>();
        for (int i = 0; i < identifierList.func_74745_c(); ++i) {
            NBTTagCompound data = identifierList.func_150305_b(i);
            String modname = data.func_74779_i("mod");
            String blockname = data.func_74779_i("name");
            Block block = OrbisLib.services().registrar().findBlock(new ResourceLocation(modname, blockname));
            if (block == null) {
                data.func_74762_e("id");
                missingMods.add(modname);
                continue;
            }
            int id = data.func_74762_e("id");
            localIdToBlock.put(id, (Object)block);
        }
        if (!missingMods.isEmpty()) {
            throw new OrbisMissingModsException("Failed loading BlockDataContainer", missingMods, "");
        }
        Int2ObjectOpenHashMap tileEntities = new Int2ObjectOpenHashMap();
        NBTTagList tileEntityList = tag.func_150295_c("tileEntities", 10);
        for (int i = 0; i < tileEntityList.func_74745_c(); ++i) {
            NBTTagCompound data = tileEntityList.func_150305_b(i);
            NBTTagCompound tileEntData = data.func_74775_l("tileEnt");
            tileEntities.put(data.func_74762_e("orbisTEIndex"), (Object)tileEntData);
        }
        byte[] blockComp = tag.func_74770_j("blocks");
        byte[] metadata = tag.func_74770_j("metadata");
        byte[] byArray = addBlocks = tag.func_74767_n("addBlocks_null") ? null : tag.func_74770_j("addBlocks");
        if (blockComp.length != this.getVolume()) {
            throw new IllegalStateException("Size of data mismatched dimensions given");
        }
        this.blocks = new int[blockComp.length];
        this.entities = new Int2ObjectOpenHashMap();
        for (int i = 0; i < blockComp.length; ++i) {
            NBTTagCompound entity;
            byte blockCompValue = blockComp[i];
            int finalId = blockCompValue == -1 ? -1 : (addBlocks == null || i >> 1 >= addBlocks.length ? blockComp[i] & 0xFF : ((i & 1) == 0 ? ((addBlocks[i >> 1] & 0xF) << 8) + (blockComp[i] & 0xFF) : ((addBlocks[i >> 1] & 0xF0) << 4) + (blockComp[i] & 0xFF)));
            Block block = (Block)localIdToBlock.get(finalId);
            IBlockState state = block.func_176203_a((int)metadata[i]);
            this.setBlockState(state, i);
            if (!block.hasTileEntity(state) || (entity = (NBTTagCompound)tileEntities.get(i)) == null) continue;
            BlockPos pos = this.fromIndex(i);
            this.entities.put(i, (Object)new TileEntityEntry(entity, pos));
        }
    }

    @Override
    public void preSaveToDisk(IWorldObject object) {
    }

    @Override
    public BlockDataContainer clone() {
        BlockDataContainer data = new BlockDataContainer();
        data.blocks = new int[this.blocks.length];
        System.arraycopy(this.blocks, 0, data.blocks, 0, this.blocks.length);
        data.idToState = new Int2ObjectOpenHashMap(this.idToState);
        data.stateToId = new Object2IntOpenCustomHashMap(this.stateToId, this.stateToId.strategy());
        data.nextID = this.nextID;
        data.metadata = this.metadata;
        data.entities.clear();
        IntIterator intIterator = this.entities.keySet().iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            TileEntityEntry e = (TileEntityEntry)this.entities.get(i);
            data.entities.put(i, (Object)new TileEntityEntry(e.data.func_74737_b(), e.pos));
        }
        data.width = this.width;
        data.height = this.height;
        data.length = this.length;
        return data;
    }

    @Override
    public String getFileExtension() {
        return "nbt";
    }

    @Override
    public IDataMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(IDataMetadata metadata) {
        this.metadata = metadata;
    }

    public TileEntityEntry getTileEntity(int x, int y, int z) {
        return (TileEntityEntry)this.entities.get(this.getIndex(x, y, z));
    }

    public void setTileEntity(TileEntity tileEntity, BlockPos pos) {
        this.setTileEntity(tileEntity.func_189515_b(new NBTTagCompound()), pos);
    }

    public void setTileEntity(NBTTagCompound tileEntity, BlockPos pos) {
        if (tileEntity == null) {
            this.entities.remove(this.getIndex(pos));
        } else {
            this.entities.put(this.getIndex(pos), (Object)new TileEntityEntry(tileEntity, pos));
        }
    }

    public Iterable<TileEntityEntry> getTileEntityEntries() {
        return this.entities.values();
    }

    public class TileEntityEntry {
        public final NBTTagCompound data;
        public final BlockPos pos;

        public TileEntityEntry(NBTTagCompound data, BlockPos pos) {
            this.data = data;
            this.pos = pos;
        }
    }
}

