/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.block;

import com.gildedgames.orbis.lib.block.BlockData;
import com.gildedgames.orbis.lib.data.DataCondition;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BlockDataWithConditions
extends BlockData {
    private DataCondition replaceCondition = new DataCondition();
    private DataCondition requiredCondition = new DataCondition();

    protected BlockDataWithConditions() {
    }

    public BlockDataWithConditions(Block block, float weight) {
        super(block);
        this.replaceCondition.setWeight(weight);
    }

    public BlockDataWithConditions(IBlockState state, float weight) {
        super(state);
        this.replaceCondition.setWeight(weight);
    }

    public DataCondition getReplaceCondition() {
        return this.replaceCondition;
    }

    public void setReplaceCondition(DataCondition replaceCondition) {
        this.replaceCondition = replaceCondition;
    }

    public DataCondition getRequiredCondition() {
        return this.requiredCondition;
    }

    public void setRequiredCondition(DataCondition requiredCondition) {
        this.requiredCondition = requiredCondition;
    }

    public void setReplacementChance(float chance) {
        this.replaceCondition.setWeight(chance);
    }

    @Override
    public void write(NBTTagCompound tag) {
        super.write(tag);
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.set("replaceCondition", this.replaceCondition);
        funnel.set("requiredCondition", this.requiredCondition);
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        NBTFunnel funnel = new NBTFunnel(tag);
        this.replaceCondition = (DataCondition)funnel.get("replaceCondition");
        this.requiredCondition = (DataCondition)funnel.get("requiredCondition");
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(super.hashCode());
        builder.append((Object)this.replaceCondition);
        builder.append((Object)this.requiredCondition);
        return builder.toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BlockDataWithConditions)) {
            return false;
        }
        return super.equals(obj);
    }
}

