/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.block;

import com.gildedgames.orbis.lib.block.BlockDataContainer;
import com.gildedgames.orbis.lib.block.BlockFilterLayer;
import com.gildedgames.orbis.lib.core.ICreationData;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.IShape;
import com.gildedgames.orbis.lib.data.schedules.IFilterOptions;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BlockFilter
implements NBT {
    private final List<BlockFilterLayer> filters = Lists.newArrayList();

    public BlockFilter() {
    }

    public BlockFilter(BlockFilterLayer layer) {
        this.add(layer);
    }

    public BlockFilter(BlockFilter blockLayerContainer) {
        this.addAll(blockLayerContainer.getFilters());
    }

    public BlockFilter(List<BlockFilterLayer> layers) {
        this.addAll(layers);
    }

    public IBlockState getSample(World world, Random rand, IBlockState state) {
        IBlockState sample = Blocks.field_150350_a.func_176223_P();
        for (BlockFilterLayer layer : this.filters) {
            if (layer == null) continue;
            sample = layer.getSample(world, rand, state);
        }
        return sample;
    }

    public void apply(Iterable<BlockPos.MutableBlockPos> positions, BlockDataContainer container, ICreationData creationData, IFilterOptions options) {
        for (BlockFilterLayer layer : this.filters) {
            if (layer == null) continue;
            layer.apply(positions, container, creationData, options);
        }
    }

    public void apply(IRegion relocateTo, IShape boundingBox, ICreationData<?> creationData, IFilterOptions options) {
        for (BlockFilterLayer layer : this.filters) {
            if (layer == null) continue;
            layer.apply(relocateTo, this, boundingBox, creationData, options);
        }
    }

    public void add(BlockFilterLayer layer) {
        this.filters.add(layer);
    }

    public void addAll(Collection<BlockFilterLayer> layers) {
        this.filters.addAll(layers);
    }

    public void clear() {
        this.filters.clear();
    }

    public List<BlockFilterLayer> getFilters() {
        return this.filters;
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setList("filterList", this.filters);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.clear();
        List<BlockFilterLayer> filters = funnel.getList("filterList");
        this.addAll(filters);
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 31);
        builder.append(this.filters);
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlockFilter) {
            BlockFilter f = (BlockFilter)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append(f.filters, this.filters);
            return builder.isEquals();
        }
        return false;
    }

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    public BlockFilterLayer getByIndex(int i) {
        return this.filters.get(i);
    }
}

