/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.block;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.block.BlockDataWithConditions;
import com.gildedgames.orbis.lib.block.BlockFilter;
import com.gildedgames.orbis.lib.block.BlockFilterLayer;
import com.gildedgames.orbis.lib.block.BlockFilterType;
import com.gildedgames.orbis.lib.util.mc.BlockUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemStack;

public class BlockFilterHelper {
    private static List<IBlockRecognition> blockRecognitions = Lists.newArrayList();

    public static void registerBlockRecognition(IBlockRecognition blockRecognition) {
        if (!blockRecognitions.contains(blockRecognition)) {
            blockRecognitions.add(blockRecognition);
        } else {
            OrbisLib.LOGGER.info("WARNING: A mod is trying to register a particular block recognition implementation more than once. Something is wrong. Please notify the mod author.");
        }
    }

    public static List<BlockDataWithConditions> getBlocksFromStack(ItemStack stack) {
        for (IBlockRecognition recognition : blockRecognitions) {
            List<BlockDataWithConditions> found = recognition.recognize(stack);
            if (found == null || found.isEmpty()) continue;
            return found;
        }
        return Collections.emptyList();
    }

    public static BlockFilterLayer getNewDeleteLayer(ItemStack stack) {
        List<BlockDataWithConditions> blocks = BlockFilterHelper.getBlocksFromStack(stack);
        if (blocks.isEmpty()) {
            BlockFilterLayer layer = new BlockFilterLayer();
            layer.setFilterType(BlockFilterType.ALL);
            layer.getReplacementBlocks().add(new BlockDataWithConditions(Blocks.field_150350_a.func_176223_P(), 1.0f));
            return layer;
        }
        BlockFilterLayer layer = new BlockFilterLayer();
        layer.setFilterType(BlockFilterType.ONLY);
        layer.getRequiredBlocks().addAll(blocks);
        layer.getReplacementBlocks().add(new BlockDataWithConditions(Blocks.field_150350_a.func_176223_P(), 1.0f));
        return layer;
    }

    public static BlockFilterLayer getNewFillLayer() {
        BlockFilterLayer layer = new BlockFilterLayer();
        layer.setFilterType(BlockFilterType.ALL);
        layer.getReplacementBlocks().add(new BlockDataWithConditions(Blocks.field_150348_b.func_176223_P(), 1.0f));
        return layer;
    }

    public static BlockFilterLayer createFillLayer(List<ItemStack> stacks) {
        BlockFilterLayer filterLayer = BlockFilterHelper.getNewFillLayer();
        ArrayList blocks = Lists.newArrayList();
        block0: for (ItemStack stack : stacks) {
            IBlockState state = BlockUtil.getBlockState(stack);
            BlockDataWithConditions block = new BlockDataWithConditions(state, (float)stack.func_190916_E());
            if (blocks.contains(block)) {
                for (BlockDataWithConditions b : blocks) {
                    if (!block.equals(b)) continue;
                    b.getReplaceCondition().setWeight(b.getReplaceCondition().getWeight() + (float)stack.func_190916_E());
                    continue block0;
                }
                continue;
            }
            block.getReplaceCondition().setWeight(stack.func_190916_E());
            blocks.add(block);
        }
        filterLayer.setReplacementBlocks(blocks);
        return filterLayer;
    }

    public static BlockFilterLayer createFill(List<BlockDataWithConditions> blocks) {
        BlockFilterLayer filterLayer = BlockFilterHelper.getNewFillLayer();
        filterLayer.setReplacementBlocks(blocks);
        return filterLayer;
    }

    public static BlockFilterLayer getNewFillLayer(ItemStack stack) {
        BlockFilterLayer layer = new BlockFilterLayer();
        layer.setFilterType(BlockFilterType.ALL);
        List<BlockDataWithConditions> blocks = BlockFilterHelper.getBlocksFromStack(stack);
        if (blocks != null) {
            layer.getReplacementBlocks().addAll(blocks);
        }
        return layer;
    }

    public static BlockFilterLayer getNewReplaceLayer(ItemStack mainHand, ItemStack offHand) {
        BlockFilterLayer layer = new BlockFilterLayer();
        List<BlockDataWithConditions> mainStates = BlockFilterHelper.getBlocksFromStack(mainHand);
        List<BlockDataWithConditions> offStates = BlockFilterHelper.getBlocksFromStack(offHand);
        layer.setFilterType(BlockFilterType.ALL_EXCEPT);
        if (offStates.isEmpty()) {
            layer.getReplacementBlocks().addAll(mainStates);
            layer.getRequiredBlocks().add(new BlockDataWithConditions(Blocks.field_150350_a.func_176223_P(), 1.0f));
        } else {
            layer.setFilterType(BlockFilterType.ONLY);
            layer.getReplacementBlocks().addAll(mainStates);
            layer.getRequiredBlocks().addAll(offStates);
        }
        return layer;
    }

    public static BlockFilterLayer getNewVoidLayer() {
        IBlockState state = Blocks.field_189881_dj.func_176223_P();
        BlockFilterLayer layer = new BlockFilterLayer();
        layer.setFilterType(BlockFilterType.ONLY);
        layer.getRequiredBlocks().add(new BlockDataWithConditions(Blocks.field_150350_a.func_176223_P(), 1.0f));
        layer.getReplacementBlocks().add(new BlockDataWithConditions(state, 1.0f));
        return layer;
    }

    static {
        blockRecognitions.add(new IBlockRecognition(){

            @Override
            public List<BlockDataWithConditions> recognize(ItemStack stack) {
                ArrayList blocks = Lists.newArrayList();
                if (stack.func_77973_b() == Items.field_151007_F) {
                    blocks.add(new BlockDataWithConditions(Blocks.field_150350_a.func_176223_P(), (float)stack.func_190916_E()));
                } else if (stack.func_77973_b() instanceof ItemBlock || stack.func_77973_b() instanceof ItemMultiTexture) {
                    IBlockState state = BlockUtil.getBlockState(stack);
                    if (state != null) {
                        blocks.add(new BlockDataWithConditions(state, (float)stack.func_190916_E()));
                    }
                } else if (stack.func_77973_b() == Items.field_151129_at) {
                    blocks.add(new BlockDataWithConditions(Blocks.field_150353_l.func_176223_P(), (float)stack.func_190916_E()));
                    blocks.add(new BlockDataWithConditions(Blocks.field_150356_k.func_176223_P(), (float)stack.func_190916_E()));
                } else if (stack.func_77973_b() == Items.field_151131_as) {
                    blocks.add(new BlockDataWithConditions(Blocks.field_150355_j.func_176223_P(), (float)stack.func_190916_E()));
                    blocks.add(new BlockDataWithConditions(Blocks.field_150358_i.func_176223_P(), (float)stack.func_190916_E()));
                }
                return blocks;
            }

            @Override
            public boolean isCompatible(Class<? extends Item> clazz) {
                return !ItemBlock.class.isAssignableFrom(clazz) && !ItemBucket.class.isAssignableFrom(clazz) && !ItemMultiTexture.class.isAssignableFrom(clazz);
            }
        });
    }

    public static class BlockDeleteFilter
    extends BlockFilter {
        public BlockDeleteFilter() {
            BlockFilterLayer layer = new BlockFilterLayer();
            layer.setFilterType(BlockFilterType.ALL);
            layer.getReplacementBlocks().add(new BlockDataWithConditions(Blocks.field_150350_a.func_176223_P(), 1.0f));
            this.add(layer);
        }
    }

    public static interface IBlockRecognition {
        public List<BlockDataWithConditions> recognize(ItemStack var1);

        public boolean isCompatible(Class<? extends Item> var1);
    }
}

