/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.block;

import com.gildedgames.orbis.lib.block.BlockDataContainer;
import com.gildedgames.orbis.lib.block.BlockDataWithConditions;
import com.gildedgames.orbis.lib.block.BlockFilter;
import com.gildedgames.orbis.lib.block.BlockFilterType;
import com.gildedgames.orbis.lib.core.ICreationData;
import com.gildedgames.orbis.lib.data.DataCondition;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.IShape;
import com.gildedgames.orbis.lib.data.schedules.IBlueprint;
import com.gildedgames.orbis.lib.data.schedules.IFilterOptions;
import com.gildedgames.orbis.lib.data.schedules.IPositionRecord;
import com.gildedgames.orbis.lib.util.OrbisTuple;
import com.gildedgames.orbis.lib.util.RotationHelp;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.gildedgames.orbis.lib.world.WorldObjectUtils;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BlockFilterLayer
implements NBT {
    protected List<BlockDataWithConditions> requiredBlocks = Lists.newArrayList();
    protected List<BlockDataWithConditions> replacementBlocks = Lists.newArrayList();
    protected String name = "";
    protected DataCondition condition;
    private BlockFilterType blockFilterType = BlockFilterType.ALL;

    public BlockFilterLayer() {
        this.condition = new DataCondition();
    }

    public BlockFilterLayer(List<BlockDataWithConditions> requiredBlocks, List<BlockDataWithConditions> newBlocks) {
        this();
        this.requiredBlocks = Lists.newArrayList(requiredBlocks);
        this.replacementBlocks = Lists.newArrayList(newBlocks);
    }

    public List<BlockDataWithConditions> getRequiredBlocks() {
        return this.requiredBlocks;
    }

    public void setRequiredBlocks(List<BlockDataWithConditions> requiredBlocks) {
        this.requiredBlocks = Lists.newArrayList(requiredBlocks);
    }

    public void setRequiredBlocks(BlockDataWithConditions ... requiredBlocks) {
        this.requiredBlocks = Lists.newArrayList(Arrays.asList(requiredBlocks));
    }

    public List<BlockDataWithConditions> getReplacementBlocks() {
        return this.replacementBlocks;
    }

    public void setReplacementBlocks(List<BlockDataWithConditions> newBlocks) {
        this.replacementBlocks = newBlocks;
    }

    public void setReplacementBlocks(BlockDataWithConditions ... newBlocks) {
        this.replacementBlocks = Lists.newArrayList(Arrays.asList(newBlocks));
    }

    public BlockFilterType getFilterType() {
        return this.blockFilterType;
    }

    public void setFilterType(BlockFilterType blockFilterType) {
        this.blockFilterType = blockFilterType;
    }

    private BlockDataWithConditions getRandom(Random random, World world) {
        float randomValue = random.nextFloat() * this.totalBlockChance();
        float chanceSum = 0.0f;
        for (BlockDataWithConditions block : this.replacementBlocks) {
            if (block.getReplaceCondition().isMet(randomValue, chanceSum, random, world)) {
                return block;
            }
            chanceSum += block.getReplaceCondition().getWeight();
        }
        return null;
    }

    public IBlockState getSample(World world, Random rand, IBlockState state) {
        BlockDataWithConditions replacementBlock = this.getRandom(rand, world);
        return replacementBlock.getBlockState();
    }

    public void apply(Iterable<BlockPos.MutableBlockPos> positions, BlockDataContainer container, ICreationData<?> creationData, IFilterOptions options) {
        World world = creationData.getWorld();
        if (this.condition == null) {
            this.condition = new DataCondition();
        }
        if (!this.condition.isMet(creationData.getRandom(), world) || this.replacementBlocks.isEmpty()) {
            return;
        }
        BlockDataWithConditions replacementBlock = null;
        if (!options.getChoosesPerBlockVar().getData().booleanValue()) {
            replacementBlock = this.getRandom(creationData.getRandom(), world);
        }
        for (BlockPos.MutableBlockPos pos : positions) {
            IBlockState state = container.getBlockState((BlockPos)pos);
            if (!this.getFilterType().filter(creationData.getCreator(), (BlockPos)pos, state, this.requiredBlocks, world, creationData.getRandom())) continue;
            if (options.getChoosesPerBlockVar().getData().booleanValue()) {
                replacementBlock = this.getRandom(creationData.getRandom(), world);
            }
            if (replacementBlock == null || !replacementBlock.getReplaceCondition().isMet(creationData.getRandom(), world) || !creationData.shouldCreate((BlockPos)pos)) continue;
            if (state.func_185904_a() == Material.field_151579_a && !creationData.placeAir()) {
                return;
            }
            if (state.func_177230_c() == Blocks.field_189881_dj && !creationData.placesVoid()) continue;
            container.setBlockState(replacementBlock.getBlockState(), (BlockPos)pos);
            NBTTagCompound entity = replacementBlock.getTileEntity();
            if (entity == null) continue;
            container.setTileEntity(entity, (BlockPos)pos);
        }
    }

    public void apply(IRegion relocateTo, BlockFilter parentFilter, IShape shape, ICreationData<?> creationData, IFilterOptions options) {
        World world = creationData.getWorld();
        if (this.condition == null) {
            this.condition = new DataCondition();
        }
        if (!this.condition.isMet(creationData.getRandom(), world) || this.replacementBlocks.isEmpty()) {
            return;
        }
        IShape intersect = null;
        IBlueprint holder = null;
        if (creationData.schedules() && (intersect = WorldObjectUtils.getIntersectingShape(world, shape)) instanceof IBlueprint) {
            holder = (IBlueprint)((Object)intersect);
        }
        BlockDataWithConditions replacementBlock = null;
        if (!options.getChoosesPerBlockVar().getData().booleanValue()) {
            replacementBlock = this.getRandom(creationData.getRandom(), world);
        }
        BlockPos min = creationData.getPos();
        BlockPos max = new BlockPos(min.func_177958_n() + shape.getBoundingBox().getWidth() - 1, min.func_177956_o() + shape.getBoundingBox().getHeight() - 1, min.func_177952_p() + shape.getBoundingBox().getLength() - 1);
        int rotAmount = Math.abs(RotationHelp.getRotationAmount(creationData.getRotation(), Rotation.NONE));
        if (rotAmount != 0) {
            for (OrbisTuple<BlockPos.MutableBlockPos, BlockPos.MutableBlockPos> tuple : RotationHelp.getAllInBoxRotated(min, max, creationData.getRotation(), relocateTo)) {
                BlockPos.MutableBlockPos beforeRot = tuple.getFirst();
                BlockPos.MutableBlockPos rotated = tuple.getSecond();
                if (!shape.contains((BlockPos)beforeRot)) continue;
                this.applyInner(world, (BlockPos)rotated, replacementBlock, intersect, holder, parentFilter, shape, creationData, options);
            }
        } else {
            for (BlockPos.MutableBlockPos iterPos : shape.getShapeData()) {
                this.applyInner(world, (BlockPos)iterPos, replacementBlock, intersect, holder, parentFilter, shape, creationData, options);
            }
        }
    }

    private void applyInner(World world, BlockPos p, BlockDataWithConditions replacementBlock, IShape intersect, IBlueprint holder, BlockFilter parentFilter, IShape shape, ICreationData<?> creationData, IFilterOptions options) {
        BlockPos without = p;
        int schedX = 0;
        int schedY = 0;
        int schedZ = 0;
        if (holder != null) {
            schedX = without.func_177958_n() - intersect.getBoundingBox().getMin().func_177958_n() + creationData.getPos().func_177958_n() - shape.getBoundingBox().getMin().func_177958_n();
            schedY = without.func_177956_o() - intersect.getBoundingBox().getMin().func_177956_o() + creationData.getPos().func_177956_o() - shape.getBoundingBox().getMin().func_177956_o();
            schedZ = without.func_177952_p() - intersect.getBoundingBox().getMin().func_177952_p() + creationData.getPos().func_177952_p() - shape.getBoundingBox().getMin().func_177952_p();
        }
        if (!creationData.schedules()) {
            IBlockState state = world.func_180495_p(without);
            if (!this.getFilterType().filter(creationData.getCreator(), p, state, this.requiredBlocks, world, creationData.getRandom())) {
                return;
            }
        }
        if (options.getChoosesPerBlockVar().getData().booleanValue()) {
            replacementBlock = this.getRandom(creationData.getRandom(), world);
        }
        if (replacementBlock == null || !replacementBlock.getReplaceCondition().isMet(creationData.getRandom(), world)) {
            return;
        }
        if (!creationData.shouldCreate(p)) {
            return;
        }
        if (creationData.schedules() && holder != null) {
            IPositionRecord<IBlockState> record = holder.getCurrentScheduleLayerNode().getData().getStateRecord();
            if (schedX >= 0 && schedY >= 0 && schedZ >= 0 && schedX < record.getWidth() && schedY < record.getHeight() && schedZ < record.getLength()) {
                IBlockState posState = holder.getCurrentScheduleLayerNode().getData().getStateRecord().get(schedX, schedY, schedZ);
                if (!this.getFilterType().filter(creationData.getCreator(), BlockPos.field_177992_a, posState == null ? Blocks.field_150350_a.func_176223_P() : posState, this.requiredBlocks, world, creationData.getRandom())) {
                    return;
                }
                if (replacementBlock.isAir()) {
                    holder.getCurrentScheduleLayerNode().getData().getStateRecord().unmarkPos(schedX, schedY, schedZ);
                } else {
                    holder.getCurrentScheduleLayerNode().getData().getStateRecord().markPos(replacementBlock.getBlockState(), schedX, schedY, schedZ);
                }
            }
        } else {
            BlockPos c = new BlockPos(p.func_177958_n() - shape.getBoundingBox().getMin().func_177958_n() + creationData.getPos().func_177958_n(), p.func_177956_o() - shape.getBoundingBox().getMin().func_177956_o() + creationData.getPos().func_177956_o(), p.func_177952_p() - shape.getBoundingBox().getMin().func_177952_p() + creationData.getPos().func_177952_p());
            world.func_175656_a(c, replacementBlock.getBlockState());
            if (replacementBlock.getTileEntity() != null) {
                world.func_175690_a(c, TileEntity.func_190200_a((World)world, (NBTTagCompound)replacementBlock.getTileEntity()));
            }
        }
    }

    public float totalBlockChance() {
        float total = 0.0f;
        for (BlockDataWithConditions BlockDataFilter : this.replacementBlocks) {
            total += BlockDataFilter.getReplaceCondition().getWeight();
        }
        return total;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void write(NBTTagCompound tag) {
        tag.func_74778_a("name", this.name);
        tag.func_74778_a("filterName", this.getFilterType().name());
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.set("condition", this.condition);
        funnel.setList("requiredBlocks", this.requiredBlocks);
        funnel.setList("replacementBlocks", this.replacementBlocks);
    }

    @Override
    public void read(NBTTagCompound tag) {
        this.name = tag.func_74779_i("name");
        this.blockFilterType = BlockFilterType.valueOf(tag.func_74779_i("filterName"));
        NBTFunnel funnel = new NBTFunnel(tag);
        this.condition = (DataCondition)funnel.get("condition");
        this.requiredBlocks = funnel.getList("requiredBlocks");
        this.replacementBlocks = funnel.getList("replacementBlocks");
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.getReplacementBlocks());
        builder.append(this.getRequiredBlocks());
        builder.append((Object)this.getFilterType());
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockFilterLayer)) {
            return false;
        }
        BlockFilterLayer layer = (BlockFilterLayer)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.getReplacementBlocks(), layer.getReplacementBlocks());
        builder.append(this.getRequiredBlocks(), layer.getRequiredBlocks());
        builder.append((Object)this.getFilterType(), (Object)layer.getFilterType());
        return builder.isEquals();
    }
}

