/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.block;

import com.gildedgames.orbis.lib.block.BlockDataWithConditions;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum BlockFilterType {
    ALL{

        @Override
        public boolean filter(EntityPlayer player, BlockPos pos, IBlockState blockToFilter, List<BlockDataWithConditions> requiredBlocks, World world, Random random) {
            return true;
        }
    }
    ,
    ALL_EXCEPT{

        @Override
        public boolean filter(EntityPlayer player, BlockPos pos, IBlockState blockToFilter, List<BlockDataWithConditions> blackListedBlocks, World world, Random random) {
            for (BlockDataWithConditions block : blackListedBlocks) {
                if (block.getBlock() != blockToFilter.func_177230_c()) continue;
                return false;
            }
            return true;
        }
    }
    ,
    ONLY{

        @Override
        public boolean filter(EntityPlayer player, BlockPos pos, IBlockState blockToFilter, List<BlockDataWithConditions> requiredBlocks, World world, Random random) {
            for (BlockDataWithConditions block : requiredBlocks) {
                if (block.getBlock() != blockToFilter.func_177230_c() || !block.getRequiredCondition().isMet(random, world)) continue;
                return true;
            }
            return false;
        }
    };


    public abstract boolean filter(EntityPlayer var1, BlockPos var2, IBlockState var3, List<BlockDataWithConditions> var4, World var5, Random var6);
}

