/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.gui.data.directory;

import com.gildedgames.orbis.lib.client.gui.data.directory.IDirectoryNavigator;
import com.gildedgames.orbis.lib.client.gui.data.directory.IDirectoryNavigatorListener;
import com.gildedgames.orbis.lib.client.gui.data.directory.IDirectoryNodeFactory;
import com.gildedgames.orbis.lib.client.gui.data.directory.INavigatorNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;

public class DirectoryNavigator
implements IDirectoryNavigator {
    private final Stack<File> pastHistory = new Stack();
    private final Stack<File> futureHistory = new Stack();
    private final List<INavigatorNode> nodesInCurrentDirectory = Lists.newArrayList();
    private final List<IDirectoryNavigatorListener> listeners = Lists.newArrayList();
    private final Map<File, List<File>> injectedDirectories = Maps.newHashMap();
    private final IDirectoryNodeFactory nodeFactory;
    private File currentDirectory;

    public DirectoryNavigator(IDirectoryNodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    @Override
    public void addListener(IDirectoryNavigatorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(IDirectoryNavigatorListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void onClickNode(INavigatorNode node) {
        this.listeners.forEach(l -> l.onNodeClick(this, node));
    }

    @Override
    public void onOpenNode(INavigatorNode node) {
        this.listeners.forEach(l -> l.onNodeOpen(this, node));
    }

    @Override
    public void openDirectory(File file) {
        if (!file.isDirectory()) {
            throw new RuntimeException("File provided to DirectoryNavigator.viewDirectories() was not a directory.");
        }
        if (this.currentDirectory != null) {
            this.pastHistory.push(this.currentDirectory);
        }
        this.currentDirectory = file;
        this.futureHistory.clear();
        this.listeners.forEach(l -> l.onDirectoryOpen(this, file));
        this.refresh();
    }

    @Override
    public void injectDirectories(File forDirectory, List<File> injectedDirectories) {
        if (!forDirectory.isDirectory()) {
            throw new RuntimeException("File provided to DirectoryNavigator.injectDirectories() 'forDirectory' was not a directory.");
        }
        for (File file : injectedDirectories) {
            if (file.isDirectory()) continue;
            throw new RuntimeException("File provided to DirectoryNavigator.injectDirectories() 'injectedDirectories' was not a directory.");
        }
        this.injectedDirectories.put(forDirectory, injectedDirectories);
        this.refresh();
    }

    @Override
    public boolean canGoBack() {
        return !this.pastHistory.isEmpty();
    }

    @Override
    public boolean canGoForward() {
        return !this.futureHistory.isEmpty();
    }

    @Override
    public void back() {
        File prev = this.pastHistory.pop();
        this.futureHistory.push(this.currentDirectory);
        this.currentDirectory = prev;
        this.listeners.forEach(l -> l.onBack(this));
        this.refresh();
    }

    @Override
    public void forward() {
        File next = this.futureHistory.pop();
        this.pastHistory.push(this.currentDirectory);
        this.currentDirectory = next;
        this.listeners.forEach(l -> l.onForward(this));
        this.refresh();
    }

    @Override
    public void refresh() {
        this.nodesInCurrentDirectory.clear();
        ArrayList directories = Lists.newArrayList((Object[])new File[]{this.currentDirectory});
        if (this.injectedDirectories.containsKey(this.currentDirectory)) {
            directories.addAll((Collection)this.injectedDirectories.get(this.currentDirectory));
        }
        for (File directory : directories) {
            try {
                Stream<Path> paths = Files.walk(Paths.get(directory.getPath(), new String[0]), new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    paths.forEach(p -> {
                        File file = p.toFile();
                        try {
                            String parent = file.getCanonicalPath().replace(file.getName(), "");
                            String currentDirParent = directory.getCanonicalPath().replace(file.getName(), "") + File.separator;
                            if (file.getPath().equals(directory.getPath()) || !parent.equals(currentDirParent)) {
                                return;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        String extension = file.isDirectory() ? "" : FilenameUtils.getExtension((String)file.getName());
                        INavigatorNode node = this.nodeFactory.createFrom(file, extension);
                        if (node != null) {
                            this.nodesInCurrentDirectory.add(node);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (paths == null) continue;
                    if (throwable != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    paths.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.nodesInCurrentDirectory.sort((p1, p2) -> {
            File f1 = p1.getFile();
            File f2 = p2.getFile();
            int flag = 0;
            if (f1.isDirectory() && !f2.isDirectory()) {
                flag = -1;
            }
            if (!f1.isDirectory() && f2.isDirectory()) {
                flag = 1;
            }
            return flag;
        });
        this.listeners.forEach(l -> l.onRefresh(this));
    }

    @Override
    public File currentDirectory() {
        return this.currentDirectory;
    }

    @Override
    public List<INavigatorNode> getNodes() {
        return this.nodesInCurrentDirectory;
    }
}

