/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.gui.data.list;

import com.gildedgames.orbis.lib.client.gui.data.list.IListNavigator;
import com.gildedgames.orbis.lib.client.gui.data.list.IListNavigatorListener;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.util.List;

public class ListNavigator<T>
implements IListNavigator<T> {
    private final List<IListNavigatorListener<T>> listeners = Lists.newArrayList();
    private final BiMap<Integer, T> nodes = HashBiMap.create();

    @Override
    public void addListener(IListNavigatorListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(IListNavigatorListener<T> listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void put(T node, int index, boolean newNode) {
        if (!this.nodes.containsKey((Object)index) || this.nodes.get((Object)index) != node) {
            this.nodes.put((Object)index, node);
            this.listeners.forEach(l -> l.onAddNode(node, index, newNode));
        }
    }

    @Override
    public boolean remove(T node, int index) {
        boolean flag = this.nodes.remove((Object)index, node);
        this.listeners.forEach(l -> l.onRemoveNode(node, index));
        return flag;
    }

    @Override
    public T remove(int index) {
        Object node = this.nodes.remove((Object)index);
        this.listeners.forEach(l -> l.onRemoveNode(node, index));
        return (T)node;
    }

    @Override
    public void click(T node, int index) {
        this.listeners.forEach(l -> l.onNodeClicked(node, index));
    }

    @Override
    public BiMap<Integer, T> getNodes() {
        return this.nodes;
    }
}

