/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.gui.util;

import com.gildedgames.orbis.lib.client.gui.util.GuiTexture;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.rect.Rect;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;

public class GuiAbstractButton
extends GuiElement {
    protected final GuiTexture defaultState;
    protected final GuiTexture hoveredState;
    protected final GuiTexture clickedState;
    protected final GuiTexture disabledState;
    private final List<Runnable> onClickEvents = Lists.newArrayList();
    private final List<Consumer> onClickAdvancedEvents = Lists.newArrayList();
    private boolean selected;

    public GuiAbstractButton(Rect dim, GuiTexture texture) {
        this(dim, texture, texture.clone(), texture.clone());
    }

    public GuiAbstractButton(Rect dim, GuiTexture defaultState, GuiTexture hoveredState, GuiTexture clickedState) {
        this(dim, defaultState, hoveredState, clickedState, null);
    }

    public GuiAbstractButton(Rect dim, GuiTexture defaultState, GuiTexture hoveredState, GuiTexture clickedState, GuiTexture disabledState) {
        super(dim, true);
        this.defaultState = defaultState;
        this.hoveredState = hoveredState;
        this.clickedState = clickedState;
        this.disabledState = disabledState;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            this.defaultState.state().setVisible(false);
            this.hoveredState.state().setVisible(true);
        }
    }

    public void addClickEvent(Runnable event) {
        this.onClickEvents.add(event);
    }

    public <T> void addAdvancedClickEvent(Consumer<T> event) {
        this.onClickAdvancedEvents.add(event);
    }

    @Override
    public void onMouseClicked(GuiElement element, int mouseX, int mouseY, int mouseButton) {
        if (this.state().isEnabled() && this.clickedState.state().isHoveredAndTopElement() && mouseButton == 0) {
            this.clickedState.state().setVisible(true);
            this.onClickEvents.forEach(Runnable::run);
            this.onClickAdvancedEvents.forEach(c -> c.accept(this));
        }
    }

    @Override
    public void onMouseReleased(GuiElement element, int mouseX, int mouseY, int state) {
        this.clickedState.state().setVisible(false);
    }

    @Override
    public void build() {
        this.defaultState.state().setVisible(false);
        this.hoveredState.state().setVisible(false);
        this.clickedState.state().setVisible(false);
        this.defaultState.dim().mod().center(false).resetPos().flush();
        this.hoveredState.dim().mod().center(false).resetPos().flush();
        this.clickedState.dim().mod().center(false).resetPos().flush();
        this.context().addChildren(this.clickedState, this.defaultState, this.hoveredState);
        this.clickedState.state().setCanBeTopHoverElement(true);
        if (this.disabledState != null) {
            this.disabledState.dim().mod().center(false).resetPos().flush();
            if (!this.state().isEnabled()) {
                this.disabledState.state().setVisible(true);
            } else {
                this.disabledState.state().setVisible(false);
            }
            this.context().addChildren((IGuiElement)this.disabledState);
        }
        this.defaultState.state().setVisible(true);
        this.state().setCanBeTopHoverElement(true);
    }

    @Override
    public void onHoverEnter(GuiElement element) {
        this.defaultState.state().setVisible(false);
        this.hoveredState.state().setVisible(true);
    }

    @Override
    public void onHoverExit(GuiElement element) {
        if (!this.selected) {
            this.defaultState.state().setVisible(true);
            this.hoveredState.state().setVisible(false);
        }
    }

    @Override
    public void onDraw(GuiElement element) {
        if (this.selected) {
            this.hoveredState.state().setVisible(true);
        }
        if (this.disabledState != null) {
            if (!this.state().isEnabled()) {
                this.disabledState.state().setVisible(true);
            } else {
                this.disabledState.state().setVisible(false);
            }
        }
    }
}

