/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.gui.util;

import com.gildedgames.orbis.lib.client.gui.data.IDropdownElement;
import com.gildedgames.orbis.lib.client.gui.util.GuiTextLabel;
import com.gildedgames.orbis.lib.client.gui.util.IDropdownListListener;
import com.gildedgames.orbis.lib.client.gui.util.decorators.GuiScrollable;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.client.rect.Rect;
import com.gildedgames.orbis.lib.client.rect.RectHolder;
import com.gildedgames.orbis.lib.client.rect.RectModifier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

public class GuiDropdownList<ELEMENT extends IDropdownElement>
extends GuiElement {
    private final List<ELEMENT> elements = Lists.newArrayList();
    private List<IDropdownListListener<ELEMENT>> listeners = Lists.newArrayList();
    private Map<ELEMENT, GuiDropdownList> subLists = Maps.newHashMap();

    public GuiDropdownList(Rect rect, ELEMENT ... elements) {
        super(rect, true);
        this.elements.addAll(Arrays.asList(elements));
    }

    public void listen(IDropdownListListener<ELEMENT> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean unlisten(IDropdownListListener<ELEMENT> listener) {
        return this.listeners.remove(listener);
    }

    public List<ELEMENT> getElements() {
        return this.elements;
    }

    public void display(Collection<ELEMENT> elements, Pos2D pos) {
        this.setDropdownElements(elements);
        int largestWidth = 0;
        for (IDropdownElement element : elements) {
            int width = this.viewer().fontRenderer().func_78256_a(element.text().func_150254_d());
            if (width <= largestWidth) continue;
            largestWidth = width;
        }
        this.dim().mod().width(largestWidth + 10).pos(pos).flush();
        this.state().setVisible(true);
        this.state().setEnabled(true);
    }

    public void setDropdownElements(Collection<ELEMENT> elements) {
        this.elements.clear();
        this.elements.addAll(elements);
        this.tryRebuild();
        for (IDropdownElement element : elements) {
            if (element.getSubElements() == null) continue;
            GuiDropdownList list = element.getSubElements().get();
            int largestWidth = 0;
            for (IDropdownElement e : list.getElements()) {
                int width = this.viewer().fontRenderer().func_78256_a(e.text().func_150254_d());
                if (width <= largestWidth) continue;
                largestWidth = width;
            }
            list.dim().mod().width(largestWidth + 10).flush();
            list.state().setVisible(false);
            list.state().setEnabled(false);
            list.state().setCanBeTopHoverElement(true);
            this.context().addChildren((IGuiElement)list);
            this.subLists.put(element, list);
        }
    }

    public void addDropdownElements(Collection<ELEMENT> elements) {
        this.elements.addAll(elements);
        this.tryRebuild();
    }

    public void addDropdownElements(ELEMENT ... elements) {
        this.elements.addAll(Arrays.asList(elements));
        this.tryRebuild();
    }

    @Override
    public void build() {
        for (int i = 0; i < this.elements.size(); ++i) {
            final IDropdownElement element = (IDropdownElement)this.elements.get(i);
            final int y = 18 * i;
            final int id = i;
            GuiTextLabel label = new GuiTextLabel(Dim2D.build().y(y).height(18.0f).flush(), element.text());
            if (element.getSubElements() != null) {
                GuiDropdownList list = element.getSubElements().get();
                int largestWidth = 0;
                for (IDropdownElement e : list.getElements()) {
                    int width = this.viewer().fontRenderer().func_78256_a(e.text().func_150254_d());
                    if (width <= largestWidth) continue;
                    largestWidth = width;
                }
                list.dim().mod().width(largestWidth + 10).flush();
                list.state().setVisible(false);
                list.state().setEnabled(false);
                list.state().setCanBeTopHoverElement(true);
                this.context().addChildren((IGuiElement)list);
                this.subLists.put(element, list);
            }
            label.state().addEvent(new GuiScrollable.InputEnabledOutsideBounds<GuiTextLabel>(){

                @Override
                public boolean shouldHoverOutsideBounds(GuiTextLabel gui) {
                    return true;
                }

                @Override
                public void onHoverEnter(GuiTextLabel gui) {
                    if (GuiDropdownList.this.subLists.containsKey(element)) {
                        GuiDropdownList list = (GuiDropdownList)GuiDropdownList.this.subLists.get(element);
                        list.dim().mod().x(GuiDropdownList.this.dim().width()).y(y).flush();
                        if (list.dim().maxX() >= (float)GuiDropdownList.this.viewer().getScreenWidth()) {
                            list.dim().mod().x(-list.dim().width()).y(y).flush();
                        }
                        list.state().setVisible(true);
                        list.state().setEnabled(true);
                    }
                }

                @Override
                public void onHoverExit(GuiTextLabel gui) {
                    GuiDropdownList list;
                    if (GuiDropdownList.this.subLists.containsKey(element) && !(list = (GuiDropdownList)GuiDropdownList.this.subLists.get(element)).state().isHoveredAndTopElement()) {
                        list.state().setVisible(false);
                        list.state().setEnabled(false);
                    }
                }

                @Override
                public void onMouseClickedOutsideBounds(GuiTextLabel gui, int mouseX, int mouseY, int mouseButton) {
                    this.onMouseClicked(gui, mouseX, mouseY, mouseButton);
                }

                @Override
                public void onMouseClicked(GuiTextLabel gui, int mouseX, int mouseY, int mouseButton) {
                    if (mouseButton == 0) {
                        if (gui.state().isHoveredAndTopElement() && GuiDropdownList.this.state().isEnabled()) {
                            element.onClick(GuiDropdownList.this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                            GuiDropdownList.this.listeners.forEach(l -> l.onClick(element));
                        }
                        if (id >= GuiDropdownList.this.elements.size() - 1) {
                            GuiDropdownList.this.state().setVisible(false);
                            GuiDropdownList.this.state().setEnabled(false);
                        }
                    }
                }
            });
            label.dim().add("dropdownListWidth", (RectHolder)this, RectModifier.ModifierType.WIDTH, new RectModifier.ModifierType[0]);
            this.context().addChildren((IGuiElement)label);
            label.state().setCanBeTopHoverElement(true);
        }
        this.dim().mod().height(18 * this.elements.size()).flush();
    }
}

