/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.gui.util;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.client.gui.data.DropdownElement;
import com.gildedgames.orbis.lib.client.gui.data.IDropdownElement;
import com.gildedgames.orbis.lib.client.gui.data.directory.IDirectoryNavigator;
import com.gildedgames.orbis.lib.client.gui.util.GuiAbstractButton;
import com.gildedgames.orbis.lib.client.gui.util.GuiDropdownList;
import com.gildedgames.orbis.lib.client.gui.util.GuiTexture;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.client.rect.Rect;
import java.io.File;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class GuiFactoryGeneric {
    public static final ResourceLocation DELETE = OrbisLib.getResource("list/delete.png");
    public static final ResourceLocation DELETE_CLICKED = OrbisLib.getResource("list/delete_clicked.png");
    public static final ResourceLocation DELETE_DISABLED = OrbisLib.getResource("list/delete_disabled.png");
    public static final ResourceLocation DELETE_HOVERED = OrbisLib.getResource("list/delete_hovered.png");
    public static final ResourceLocation ADD = OrbisLib.getResource("list/add.png");
    public static final ResourceLocation ADD_CLICKED = OrbisLib.getResource("list/add_clicked.png");
    public static final ResourceLocation ADD_DISABLED = OrbisLib.getResource("list/add_disabled.png");
    public static final ResourceLocation ADD_HOVERED = OrbisLib.getResource("list/add_hovered.png");

    private GuiFactoryGeneric() {
    }

    public static IDropdownElement createCloseDropdownElement(File file, IDirectoryNavigator navigator) {
        return new DropdownElement((ITextComponent)new TextComponentString("Close")){

            @Override
            public void onClick(GuiDropdownList list, EntityPlayer player) {
                list.setDropdownElements(Collections.emptyList());
            }
        };
    }

    public static IDropdownElement createDeleteFileDropdownElement(final File file, final IDirectoryNavigator navigator) {
        return new DropdownElement((ITextComponent)new TextComponentString("Delete")){

            @Override
            public void onClick(GuiDropdownList list, EntityPlayer player) {
                if (file.isDirectory()) {
                    // empty if block
                }
                list.setDropdownElements(Collections.emptyList());
                list.state().setVisible(false);
                navigator.refresh();
            }
        };
    }

    public static GuiAbstractButton createDeleteButton() {
        Rect rect = Dim2D.build().width(20.0f).height(20.0f).flush();
        GuiTexture defaultState = new GuiTexture(rect, DELETE);
        GuiTexture hoveredState = new GuiTexture(rect, DELETE_HOVERED);
        GuiTexture clickedState = new GuiTexture(rect, DELETE_CLICKED);
        GuiTexture disabledState = new GuiTexture(rect, DELETE_DISABLED);
        GuiAbstractButton button = new GuiAbstractButton(rect, defaultState, hoveredState, clickedState, disabledState);
        return button;
    }

    public static GuiAbstractButton createAddButton() {
        Rect rect = Dim2D.build().width(20.0f).height(20.0f).flush();
        GuiTexture defaultState = new GuiTexture(rect, ADD);
        GuiTexture hoveredState = new GuiTexture(rect, ADD_HOVERED);
        GuiTexture clickedState = new GuiTexture(rect, ADD_CLICKED);
        GuiTexture disabledState = new GuiTexture(rect, ADD_DISABLED);
        GuiAbstractButton button = new GuiAbstractButton(rect, defaultState, hoveredState, clickedState, disabledState);
        return button;
    }
}

