/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.gui.util;

import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.rect.Rect;
import com.gildedgames.orbis.lib.util.InputHelper;
import java.text.DecimalFormat;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class GuiInputSlider
extends GuiElement {
    protected static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("textures/gui/widgets.png");
    private final float minValue;
    private final float maxValue;
    public boolean dragging;
    public boolean hovered;
    private String displayString;
    private float sliderValue;
    private DecimalFormat df;

    public GuiInputSlider(Rect rect, float minValue, float maxValue, float sliderValue) {
        super(rect, true);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.sliderValue = sliderValue;
        this.df = new DecimalFormat();
        this.df.setMaximumFractionDigits(1);
        this.displayString = String.valueOf(this.df.format(this.sliderValue * this.maxValue));
    }

    public float getSliderValue() {
        return this.sliderValue;
    }

    public void setSliderValue(float sliderValue) {
        this.sliderValue = sliderValue;
        this.displayString = String.valueOf(this.df.format(this.sliderValue * this.maxValue));
    }

    @Override
    public void build() {
        this.state().setCanBeTopHoverElement(true);
    }

    @Override
    public void onMouseClicked(GuiElement element, int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && this.state().isHoveredAndTopElement()) {
            this.sliderValue = ((float)InputHelper.getMouseX() - (this.dim().x() + 4.0f)) / (this.dim().width() - 8.0f);
            this.sliderValue = MathHelper.func_76131_a((float)this.sliderValue, (float)0.0f, (float)1.0f);
            this.dragging = true;
        }
    }

    protected int getHoverState(boolean mouseOver) {
        int i = 1;
        if (this.state().isEnabled()) {
            i = 0;
        } else if (mouseOver) {
            i = 2;
        }
        return i;
    }

    @Override
    public void onDraw(GuiElement element) {
        FontRenderer fontrenderer = this.viewer().mc().field_71466_p;
        this.viewer().mc().func_110434_K().func_110577_a(BUTTON_TEXTURES);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.hovered = (float)InputHelper.getMouseX() >= this.dim().x() && (float)InputHelper.getMouseY() >= this.dim().y() && (float)InputHelper.getMouseX() < this.dim().x() + this.dim().width() && (float)InputHelper.getMouseY() < this.dim().y() + this.dim().height();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.viewer().getActualScreen().func_175174_a(this.dim().x(), this.dim().y(), 0, 46, (int)(this.dim().width() / 2.0f), (int)this.dim().height());
        this.viewer().getActualScreen().func_175174_a(this.dim().x() + this.dim().width() / 2.0f, this.dim().y(), (int)(200.0f - this.dim().width() / 2.0f), 46, (int)(this.dim().width() / 2.0f), (int)this.dim().height());
        int j = 0xE0E0E0;
        if (!this.state().isEnabled()) {
            j = 0xA0A0A0;
        } else if (this.hovered) {
            j = 0xFFFFA0;
        }
        this.viewer().getActualScreen().func_73732_a(fontrenderer, this.displayString, (int)(this.dim().x() + this.dim().width() / 2.0f), (int)(this.dim().y() + (this.dim().height() - 8.0f) / 2.0f), j);
        if (this.dragging) {
            this.sliderValue = ((float)InputHelper.getMouseX() - (this.dim().x() + 4.0f)) / (this.dim().width() - 8.0f);
            this.sliderValue = MathHelper.func_76131_a((float)this.sliderValue, (float)0.0f, (float)1.0f);
            this.displayString = String.valueOf(this.df.format(this.sliderValue * this.maxValue));
        }
        this.viewer().mc().func_110434_K().func_110577_a(BUTTON_TEXTURES);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.viewer().getActualScreen().func_175174_a(this.dim().x() + (float)((int)(this.sliderValue * (this.dim().width() - 8.0f))), this.dim().y(), 0, 66, 4, 20);
        this.viewer().getActualScreen().func_175174_a(this.dim().x() + (float)((int)(this.sliderValue * (this.dim().width() - 8.0f))) + 4.0f, this.dim().y(), 196, 66, 4, 20);
    }

    @Override
    public void onMouseReleased(GuiElement element, int mouseX, int mouseY, int state) {
        this.dragging = false;
    }
}

