/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.gui.util;

import com.gildedgames.orbis.lib.client.gui.data.Text;
import com.gildedgames.orbis.lib.client.gui.util.GuiText;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.client.rect.Rect;
import com.gildedgames.orbis.lib.util.mc.IText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class GuiTextBox
extends GuiElement {
    private final boolean centerFormat;
    private IText[] text;
    private Function<String, String> textMutator;

    public GuiTextBox(Rect dim, boolean centerFormat, IText ... text) {
        super(dim, true);
        this.text = text;
        this.centerFormat = centerFormat;
    }

    public void setTextMutator(Function<String, String> textMutator) {
        this.textMutator = textMutator;
    }

    public void setText(IText ... text) {
        this.text = text;
    }

    @Override
    public void build() {
        int textHeight = 0;
        if (this.dim().width() == 0.0f) {
            throw new IllegalArgumentException("A GuiTextBox is attempting to build with 0 width. This cannot work. Please fix: " + this);
        }
        float halfWidth = this.dim().width() / 2.0f;
        for (IText t : this.text) {
            if (t.component().func_150254_d().isEmpty()) continue;
            String formatted = t.component().func_150254_d();
            if (this.textMutator != null) {
                formatted = this.textMutator.apply(formatted);
            }
            String[] strings = formatted.split(System.lineSeparator() + "|\\\\n");
            ArrayList stringList = new ArrayList(strings.length);
            Collections.addAll(stringList, strings);
            for (String string : stringList) {
                List newStrings = this.viewer().fontRenderer().func_78271_c(string, (int)(this.dim().width() / t.scale()));
                for (String s : newStrings) {
                    GuiText textElement = this.centerFormat ? new GuiText(Dim2D.build().pos(halfWidth, textHeight).centerX(true).flush(), new Text((ITextComponent)new TextComponentString(s), t.scale())) : new GuiText(Dim2D.build().pos(0.0f, textHeight).flush(), new Text((ITextComponent)new TextComponentString(s), t.scale()));
                    textElement.state().setAlpha(this.state().getAlpha());
                    this.context().addChildren((IGuiElement)textElement);
                    textHeight = (int)((float)textHeight + 1.2f * t.scaledHeight());
                }
            }
        }
        this.dim().mod().height(textHeight).flush();
    }

    @Override
    public void onDraw(GuiElement element) {
        for (IGuiElement c : this.context().getChildren()) {
            if (!(c instanceof GuiText)) continue;
            GuiText text = (GuiText)c;
            text.state().setAlpha(this.state().getAlpha());
        }
    }
}

