/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.gui.util;

import com.gildedgames.orbis.lib.client.gui.data.Text;
import com.gildedgames.orbis.lib.client.gui.util.GuiFrameUtils;
import com.gildedgames.orbis.lib.client.gui.util.GuiText;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.client.rect.Rect;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.ITextComponent;

public class GuiTextLabel
extends GuiElement {
    private GuiText text;

    public GuiTextLabel(Rect rect) {
        this(rect, null);
    }

    public GuiTextLabel(Rect rect, ITextComponent component) {
        super(rect, true);
        if (component != null) {
            this.text = new GuiText(Dim2D.build().centerY(true).x(3.0f).y(this.dim().height() / 2.0f).addY(1.0f).flush(), new Text(component, 1.0f));
        }
    }

    public void setText(ITextComponent component) {
        this.text = new GuiText(Dim2D.build().centerY(true).x(3.0f).y(this.dim().height() / 2.0f).addY(1.0f).flush(), new Text(component, 1.0f));
        this.tryRebuild();
    }

    @Override
    public void build() {
        if (this.text != null) {
            this.context().addChildren((IGuiElement)this.text);
        }
        this.state().setCanBeTopHoverElement(true);
    }

    @Override
    public void onDraw(GuiElement element) {
        GlStateManager.func_179094_E();
        GuiFrameUtils.applyAlpha(this.state());
        this.drawTextBackground(this.dim().x() + 4.0f, this.dim().y() + 4.0f, this.dim().width() - 8.0f, this.dim().height() - 8.0f, this.state().isHoveredAndTopElement() ? -267486864 : -267386864, this.state().isHoveredAndTopElement() ? 1547420415 : 0x505000FF);
        GlStateManager.func_179121_F();
    }

    private void drawTextBackground(float cornerX, float cornerY, float width, float height, int innerColor, int outerColor) {
        int l1 = innerColor;
        this.drawGradientRect(cornerX - 3.0f, cornerY - 4.0f, cornerX + width + 3.0f, cornerY - 3.0f, l1, l1);
        this.drawGradientRect(cornerX - 3.0f, cornerY + height + 3.0f, cornerX + width + 3.0f, cornerY + height + 4.0f, l1, l1);
        this.drawGradientRect(cornerX - 3.0f, cornerY - 3.0f, cornerX + width + 3.0f, cornerY + height + 3.0f, l1, l1);
        this.drawGradientRect(cornerX - 4.0f, cornerY - 3.0f, cornerX - 3.0f, cornerY + height + 3.0f, l1, l1);
        this.drawGradientRect(cornerX + width + 3.0f, cornerY - 3.0f, cornerX + width + 4.0f, cornerY + height + 3.0f, l1, l1);
        int i2 = outerColor;
        int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
        this.drawGradientRect(cornerX - 3.0f, cornerY - 3.0f + 1.0f, cornerX - 3.0f + 1.0f, cornerY + height + 3.0f - 1.0f, i2, j2);
        this.drawGradientRect(cornerX + width + 2.0f, cornerY - 3.0f + 1.0f, cornerX + width + 3.0f, cornerY + height + 3.0f - 1.0f, i2, j2);
        this.drawGradientRect(cornerX - 3.0f, cornerY - 3.0f, cornerX + width + 3.0f, cornerY - 3.0f + 1.0f, i2, i2);
        this.drawGradientRect(cornerX - 3.0f, cornerY + height + 2.0f, cornerX + width + 3.0f, cornerY + height + 3.0f, j2, j2);
    }

    protected void drawGradientRect(float left, float top, float right, float bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)right, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        buffer.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        buffer.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }
}

