/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.gui.util;

import com.gildedgames.orbis.lib.client.gui.util.GuiFrameUtils;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.repeat_methods.ITextureRepeatMethod;
import com.gildedgames.orbis.lib.client.gui.util.repeat_methods.TextureUV;
import com.gildedgames.orbis.lib.client.rect.Rect;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class GuiTextureRepeatable
extends GuiElement {
    private ResourceLocation texture;
    private int textureWidth;
    private int textureHeight;
    private TextureUV centerSpace;
    private TextureUV topLeftCorner;
    private TextureUV topRightCorner;
    private TextureUV bottomLeftCorner;
    private TextureUV bottomRightCorner;
    private TextureUV topCenter;
    private TextureUV bottomCenter;
    private TextureUV leftCenter;
    private TextureUV rightCenter;
    private ITextureRepeatMethod method;

    public GuiTextureRepeatable(Rect rect, ResourceLocation texture, TextureUV centerSpace, int textureWidth, int textureHeight, ITextureRepeatMethod method) {
        super(rect, true);
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.method = method;
        this.createUVMaps(centerSpace, textureWidth, textureHeight);
        this.texture = texture;
        this.state().setShouldScaleRender(false);
    }

    public static void drawModalRectWithCustomSizedTexture(float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        x = Math.max(0.0f, x);
        y = Math.max(0.0f, y);
        u = Math.max(0.0f, u);
        v = Math.max(0.0f, v);
        width = Math.max(0.0f, width);
        height = Math.max(0.0f, height);
        if (width == 0.0f || height == 0.0f) {
            return;
        }
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)(u * f), (double)((v + height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((u + width) * f), (double)((v + height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((u + width) * f), (double)(v * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public TextureUV getCenterSpace() {
        return this.centerSpace;
    }

    public TextureUV getBottomRightCorner() {
        return this.bottomRightCorner;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    private void createUVMaps(TextureUV centerSpace, int textureWidth, int textureHeight) {
        this.centerSpace = centerSpace;
        this.topLeftCorner = new TextureUV(0, 0, centerSpace.getU(), centerSpace.getV());
        this.leftCenter = new TextureUV(0, centerSpace.getV(), centerSpace.getU(), centerSpace.getHeight());
        this.bottomLeftCorner = new TextureUV(0, centerSpace.getMaxV(), centerSpace.getU(), textureHeight - centerSpace.getMaxV());
        this.topRightCorner = new TextureUV(centerSpace.getMaxU(), 0, textureWidth - centerSpace.getMaxU(), centerSpace.getV());
        this.rightCenter = new TextureUV(centerSpace.getMaxU(), centerSpace.getV(), textureWidth - centerSpace.getMaxU(), centerSpace.getHeight());
        this.bottomRightCorner = new TextureUV(centerSpace.getMaxU(), centerSpace.getMaxV(), textureWidth - centerSpace.getMaxU(), textureHeight - centerSpace.getMaxV());
        this.topCenter = new TextureUV(centerSpace.getU(), 0, centerSpace.getWidth(), centerSpace.getV());
        this.bottomCenter = new TextureUV(centerSpace.getU(), centerSpace.getMaxV(), centerSpace.getWidth(), textureHeight - centerSpace.getMaxV());
    }

    public ResourceLocation getResourceLocation() {
        return this.texture;
    }

    public void setResourceLocation(ResourceLocation texture) {
        this.texture = texture;
    }

    public void setResourceLocation(ResourceLocation texture, TextureUV centerSpace, int textureWidth, int textureHeight) {
        this.texture = texture;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.createUVMaps(centerSpace, textureWidth, textureHeight);
    }

    @Override
    public void onDraw(GuiElement element) {
        GlStateManager.func_179094_E();
        GuiFrameUtils.applyAlpha(this.state());
        this.viewer().mc().func_110434_K().func_110577_a(this.texture);
        this.method.draw(this, this.centerSpace, this.topLeftCorner, this.topRightCorner, this.bottomLeftCorner, this.bottomRightCorner, this.topCenter, this.bottomCenter, this.leftCenter, this.rightCenter);
        GlStateManager.func_179121_F();
    }

    public GuiTextureRepeatable clone() {
        return new GuiTextureRepeatable(this.dim(), this.texture, this.centerSpace, this.textureWidth, this.textureHeight, this.method);
    }
}

