/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.gui.util.decorators;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.client.gui.util.GuiTexture;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiLibHelper;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiEvent;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiViewer;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.client.rect.Rect;
import com.gildedgames.orbis.lib.client.rect.RectHolder;
import com.gildedgames.orbis.lib.client.rect.RectModifier;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiScrollable
extends GuiElement {
    private static final ResourceLocation SCROLL_KNOB = OrbisLib.getResource("list/scroll_knob.png");
    private static final ResourceLocation SCROLL_KNOB_DISABLED = OrbisLib.getResource("list/scroll_knob_disabled.png");
    private static final ResourceLocation SCROLL_BAR = OrbisLib.getResource("list/scroll_bar.png");
    private final boolean scrollBarOnRightSide;
    private IGuiElement window;
    private final IGuiEvent<IGuiElement> scissorEvent = new IGuiEvent<IGuiElement>(){

        @Override
        public void onPreDraw(IGuiElement element) {
            ScaledResolution res = new ScaledResolution(GuiScrollable.this.viewer().mc());
            IGuiViewer viewer = GuiScrollable.this.viewer();
            double scaleW = (double)viewer.mc().field_71443_c / res.func_78327_c();
            double scaleH = (double)viewer.mc().field_71440_d / res.func_78324_d();
            IGuiElement window = GuiScrollable.this.window;
            boolean rightBar = GuiScrollable.this.scrollBarOnRightSide;
            double scrollBarWidth = GuiScrollable.this.scrollBar.dim().width();
            double windowWidth = window.dim().width();
            double windowHeight = window.dim().height();
            int scissorX = (int)((double)window.dim().x() * scaleW);
            int scissorY = (int)((double)viewer.mc().field_71440_d - (double)(window.dim().y() + window.dim().height()) * scaleH);
            int scissorWidth = (int)(((double)window.dim().width() - (rightBar ? scrollBarWidth : 0.0)) * scaleW);
            int scissorHeight = (int)((double)window.dim().height() * scaleH);
            GL11.glEnable((int)3089);
            if (!(windowWidth < 0.0) && !(windowHeight < 0.0)) {
                GL11.glScissor((int)scissorX, (int)scissorY, (int)scissorWidth, (int)scissorHeight);
            }
        }

        @Override
        public void onPostDraw(IGuiElement element) {
            GL11.glDisable((int)3089);
        }

        @Override
        public void onMouseClicked(IGuiElement element, int mouseX, int mouseY, int mouseButton) {
        }

        @Override
        public boolean isMouseClickedEnabled(IGuiElement element, int mouseX, int mouseY, int mouseButton) {
            boolean enabled;
            boolean bl = enabled = element == GuiScrollable.this.window || GuiScrollable.this.window.state().isHovered();
            if (!enabled) {
                for (IGuiEvent event : element.state().getEvents()) {
                    if (!(event instanceof IInputEnabledOutsideBounds)) continue;
                    IInputEnabledOutsideBounds input = (IInputEnabledOutsideBounds)((Object)event);
                    input.onMouseClickedOutsideBounds(element, mouseX, mouseY, mouseButton);
                    return false;
                }
            }
            return enabled;
        }

        @Override
        public boolean isMouseClickMoveEnabled(IGuiElement element, int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
            boolean enabled;
            boolean bl = enabled = element == GuiScrollable.this.window || GuiScrollable.this.window.state().isHovered();
            if (!enabled) {
                for (IGuiEvent event : element.state().getEvents()) {
                    if (!(event instanceof IInputEnabledOutsideBounds)) continue;
                    IInputEnabledOutsideBounds input = (IInputEnabledOutsideBounds)((Object)event);
                    input.onMouseClickMoveOutsideBounds(element, mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
                    return false;
                }
            }
            return enabled;
        }

        @Override
        public boolean isMouseReleasedEnabled(IGuiElement element, int mouseX, int mouseY, int state) {
            boolean enabled;
            boolean bl = enabled = element == GuiScrollable.this.window || GuiScrollable.this.window.state().isHovered();
            if (!enabled) {
                for (IGuiEvent event : element.state().getEvents()) {
                    if (!(event instanceof IInputEnabledOutsideBounds)) continue;
                    IInputEnabledOutsideBounds input = (IInputEnabledOutsideBounds)((Object)event);
                    input.onMouseReleasedOutsideBounds(element, mouseX, mouseY, state);
                    return false;
                }
            }
            return enabled;
        }

        @Override
        public boolean isMouseWheelEnabled(IGuiElement element, int state) {
            boolean enabled;
            boolean bl = enabled = element == GuiScrollable.this.window || GuiScrollable.this.window.state().isHovered();
            if (!enabled) {
                for (IGuiEvent event : element.state().getEvents()) {
                    if (!(event instanceof IInputEnabledOutsideBounds)) continue;
                    IInputEnabledOutsideBounds input = (IInputEnabledOutsideBounds)((Object)event);
                    input.onMouseWheelOutsideBounds(element, state);
                }
            }
            return enabled;
        }

        @Override
        public boolean isHandleMouseClickEnabled(IGuiElement element, Slot slotIn, int slotId, int mouseButton, ClickType type) {
            boolean enabled;
            boolean bl = enabled = element == GuiScrollable.this.window || GuiScrollable.this.window.state().isHovered();
            if (!enabled) {
                for (IGuiEvent event : element.state().getEvents()) {
                    if (!(event instanceof IInputEnabledOutsideBounds)) continue;
                    IInputEnabledOutsideBounds input = (IInputEnabledOutsideBounds)((Object)event);
                    input.onHandleMouseClickOutsideBounds(element, slotIn, slotId, mouseButton, type);
                    return false;
                }
            }
            return enabled;
        }

        @Override
        public boolean canBeHovered(IGuiElement element) {
            for (IGuiEvent event : element.state().getEvents()) {
                if (!(event instanceof IInputEnabledOutsideBounds) || !((IInputEnabledOutsideBounds)((Object)event)).shouldHoverOutsideBounds(element)) continue;
                return true;
            }
            return element == GuiScrollable.this.window || GuiScrollable.this.window.state().isHovered();
        }
    };
    private IGuiElement pane;
    private IGuiElement decorated;
    private float scroll;
    private GuiTexture scrollKnob;
    private GuiTexture scrollBar;

    public GuiScrollable(IGuiElement decorated, Rect pane) {
        this(decorated, pane, false);
    }

    public GuiScrollable(IGuiElement decorated, Rect pane, boolean scrollBarOnRightSide) {
        super(pane, true);
        this.scrollBarOnRightSide = scrollBarOnRightSide;
        this.setDecorated(decorated);
    }

    public void setDecorated(IGuiElement decorated) {
        this.dim().mod().x(decorated.dim().x()).y(decorated.dim().y()).flush();
        this.decorated = decorated;
        this.window = new GuiElement(Dim2D.build().width(0.0f).x(0.0f).y(0.0f).flush(), false);
        this.pane = new GuiElement(Dim2D.build().x(this.scrollBarOnRightSide ? 0.0f : 16.0f).y(0.0f).flush(), false);
        this.window.dim().add("scrollableArea", (RectHolder)this, RectModifier.ModifierType.AREA, new RectModifier.ModifierType[0]);
        this.pane.dim().add("scrollableArea", (RectHolder)this, RectModifier.ModifierType.AREA, new RectModifier.ModifierType[0]);
        this.tryRebuild();
    }

    public float getScrollBarWidth() {
        return this.scrollBar.dim().width();
    }

    @Override
    public void build() {
        this.decorated.dim().mod().x(0.0f).y(0.0f).flush();
        this.pane.build(this.viewer());
        this.pane.context().addChildren(this.decorated);
        this.scrollKnob = new GuiTexture(Dim2D.build().width(12.0f).height(15.0f).x(1.0f).y(1.0f).flush(), SCROLL_KNOB);
        this.scrollBar = new GuiTexture(Dim2D.build().width(14.0f).flush(), SCROLL_BAR);
        if (this.scrollBarOnRightSide) {
            this.scrollBar.dim().mod().x(this.dim().width() - this.scrollBar.dim().width()).flush();
            this.scrollKnob.dim().mod().x(this.scrollBar.dim().x() + 1.0f).flush();
        }
        this.scrollBar.dim().add("scrollableHeight", (RectHolder)this, RectModifier.ModifierType.HEIGHT, new RectModifier.ModifierType[0]);
        this.context().addChildren(this.window, this.pane, this.scrollBar, this.scrollKnob);
        this.window.state().setCanBeTopHoverElement(true);
    }

    @Override
    public void onGlobalContextChanged(GuiElement element) {
        for (IGuiElement child : GuiLibHelper.getAllChildrenRecursivelyFor(this.decorated)) {
            child.state().addEvent(this.scissorEvent);
        }
    }

    @Override
    public void onDraw(GuiElement element) {
        if (this.dim().height() >= this.decorated.dim().height()) {
            this.scrollKnob.setResourceLocation(SCROLL_KNOB_DISABLED);
        } else {
            this.scrollKnob.setResourceLocation(SCROLL_KNOB);
        }
    }

    @Override
    public void onMouseWheel(GuiElement element, int state) {
        if (this.window.state().isHoveredAndTopElement()) {
            float height = this.decorated.dim().height() - this.dim().height();
            this.scroll -= (float)(state / 120) * 10.0f;
            this.scroll = Math.max(0.0f, Math.min(height, this.scroll));
            this.pane.dim().mod().y(-this.scroll).flush();
            float percent = this.scroll / height;
            float yScrollBarPadding = 1.0f;
            float y = percent * (this.dim().height() - this.scrollKnob.dim().height() - 2.0f);
            this.scrollKnob.dim().mod().y(y + 1.0f).flush();
        }
    }

    public void resetScroll() {
        this.pane.dim().mod().y(0.0f).flush();
        this.scrollKnob.dim().mod().y(1.0f).flush();
        this.scroll = 0.0f;
    }

    public static class InputEnabledOutsideBounds<T extends IGuiElement>
    implements IGuiEvent<T>,
    IInputEnabledOutsideBounds<T> {
    }

    public static interface IInputEnabledOutsideBounds<T extends IGuiElement> {
        default public void onMouseClickedOutsideBounds(T element, int mouseX, int mouseY, int mouseButton) {
        }

        default public void onMouseClickMoveOutsideBounds(T element, int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        }

        default public void onMouseReleasedOutsideBounds(T element, int mouseX, int mouseY, int state) {
        }

        default public void onMouseWheelOutsideBounds(T element, int state) {
        }

        default public void onHandleMouseClickOutsideBounds(T element, Slot slotIn, int slotId, int mouseButton, ClickType type) {
        }

        default public boolean shouldHoverOutsideBounds(T element) {
            return false;
        }
    }
}

