/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.gui.util.gui_library;

import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiViewer;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class GuiLibHelper {
    public static void alignVertically(IGuiViewer viewer, Pos2D origin, float yPadding, GuiElement ... elements) {
        GuiElement lastElement = null;
        for (GuiElement e : elements) {
            float yOffset;
            float f = yOffset = lastElement != null ? lastElement.dim().maxY() + yPadding : origin.y();
            if (!e.state().hasBuilt()) {
                e.build(viewer);
            }
            e.dim().mod().x(origin.x()).y(yOffset).flush();
            lastElement = e;
        }
    }

    public static void assembleMinMaxArea(IGuiElement topLevel) {
        float maxX = Float.MIN_VALUE;
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        ArrayList elements = Lists.newArrayList(topLevel.context().getChildren());
        elements.add(topLevel);
        for (IGuiElement child : elements) {
            if (child.dim().maxX() > maxX) {
                maxX = child.dim().maxX();
            }
            if (child.dim().min().x() < minX) {
                minX = child.dim().min().x();
            }
            if (child.dim().maxY() > maxY) {
                maxY = child.dim().maxY();
            }
            if (!(child.dim().min().y() < minY)) continue;
            minY = child.dim().min().y();
        }
        topLevel.dim().mod().x(minX).y(minY).width(maxX - minX).height(maxY - minY).flush();
    }

    public static List<IGuiElement> getAllChildrenRecursivelyFor(IGuiElement element) {
        ArrayList children = Lists.newArrayList();
        for (IGuiElement child : element.context().getChildren()) {
            GuiLibHelper.fetchAllChildrenRecursivelyFor(children, child);
        }
        return children;
    }

    private static void fetchAllChildrenRecursivelyFor(List<IGuiElement> addTo, IGuiElement top) {
        addTo.add(top);
        for (IGuiElement child : top.context().getChildren()) {
            GuiLibHelper.fetchAllChildrenRecursivelyFor(addTo, child);
        }
    }
}

