/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.gui.util.list;

import com.gildedgames.orbis.lib.client.gui.data.list.IListNavigator;
import com.gildedgames.orbis.lib.client.gui.data.list.IListNavigatorListener;
import com.gildedgames.orbis.lib.client.gui.util.GuiAbstractButton;
import com.gildedgames.orbis.lib.client.gui.util.GuiFactoryGeneric;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.gui.util.list.IListViewerListener;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.client.rect.Rect;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class GuiListViewer<NODE, NODE_GUI extends GuiElement>
extends GuiElement
implements IListNavigatorListener<NODE> {
    private final IListNavigator<NODE> navigator;
    private final List<NODE_GUI> visibleGuiNodes = Lists.newArrayList();
    private final List<NODE> visibleNodes = Lists.newArrayList();
    private final List<GuiAbstractButton> visibleDeletes = Lists.newArrayList();
    private final NodeFactory<NODE, NODE_GUI> guiFactory;
    private final Function<Integer, NODE> nodeFactory;
    private GuiAbstractButton addButton;
    private int currentScroll;
    private int maxScroll;
    private int nodeHeight;
    private List<IListViewerListener> listeners = Lists.newArrayList();
    private Function<IListNavigator<NODE>, Integer> newNodeIndex;
    private boolean allowModifications = true;

    public GuiListViewer(Rect dim, Function<IListNavigator<NODE>, Integer> newNodeIndex, IListNavigator<NODE> navigator, NodeFactory<NODE, NODE_GUI> guiFactory, Function<Integer, NODE> nodeFactory, int nodeHeight) {
        super(dim, true);
        this.navigator = navigator;
        this.navigator.addListener(this);
        this.newNodeIndex = newNodeIndex;
        this.guiFactory = guiFactory;
        this.nodeFactory = nodeFactory;
        this.nodeHeight = nodeHeight;
    }

    public GuiListViewer<NODE, NODE_GUI> allowModifications(boolean flag) {
        this.allowModifications = flag;
        return this;
    }

    public void listen(IListViewerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean unlisten(IListViewerListener listener) {
        return this.listeners.remove(listener);
    }

    public NODE_GUI getNodeGui(int index) {
        return (NODE_GUI)((GuiElement)this.visibleGuiNodes.get(index - this.currentScroll));
    }

    public IListNavigator<NODE> getNavigator() {
        return this.navigator;
    }

    public int findPosition(NODE node) {
        return (Integer)this.navigator.getNodes().inverse().get(node);
    }

    public List<NODE> getVisibleNodes() {
        return this.visibleNodes;
    }

    private List<NODE_GUI> listVisibleNodes(List<NODE> nodes, int scrollCount, int height, int width) {
        ArrayList guis = Lists.newArrayList();
        int nodeWidth = width - (this.allowModifications ? 20 : 0);
        int nodeHeight = this.nodeHeight;
        int possibleNumberOfRows = height / nodeHeight;
        if (nodes.size() < possibleNumberOfRows) {
            this.currentScroll = 0;
            this.maxScroll = 0;
        } else {
            this.maxScroll = nodes.size() - possibleNumberOfRows + 1;
        }
        int frontNodeIndex = Math.max(0, Math.min(scrollCount, this.maxScroll));
        int backNodeIndex = Math.min(nodes.size(), frontNodeIndex + possibleNumberOfRows);
        for (int i = frontNodeIndex; i < backNodeIndex; ++i) {
            NODE node = nodes.get(i);
            if (node == null) continue;
            int row = i - frontNodeIndex;
            Pos2D pos = Pos2D.flush(0.0f, row * nodeHeight);
            GuiElement guiNode = (GuiElement)this.guiFactory.create(pos, node, i);
            guiNode.dim().mod().width(nodeWidth).height(nodeHeight).scale(1.0f).flush();
            guis.add(guiNode);
            this.visibleNodes.add(node);
        }
        if (this.allowModifications) {
            if (this.currentScroll == this.maxScroll) {
                this.addButton = GuiFactoryGeneric.createAddButton();
                Pos2D pos = Pos2D.flush(nodeWidth, (backNodeIndex - frontNodeIndex) * nodeHeight);
                this.addButton.dim().mod().x(nodeWidth).pos(pos).scale(1.0f).flush();
            } else {
                this.addButton = null;
            }
        }
        return guis;
    }

    @Override
    public void onMouseClicked(GuiElement element, int mouseX, int mouseY, int mouseButton) {
        if (this.state().isEnabled() && mouseButton == 0) {
            if (this.addButton.state().isHoveredAndTopElement() && this.addButton.state().isEnabled()) {
                int index = this.newNodeIndex.apply(this.getNavigator());
                this.getNavigator().put(this.nodeFactory.apply(index), index, true);
                return;
            }
            for (int i = 0; i < this.visibleGuiNodes.size(); ++i) {
                GuiAbstractButton button = this.allowModifications ? this.visibleDeletes.get(i) : null;
                GuiElement nodeGui = (GuiElement)this.visibleGuiNodes.get(i);
                NODE node = this.visibleNodes.get(i);
                if (button.state().isHoveredAndTopElement() && button.state().isEnabled()) {
                    this.getNavigator().remove(node, (Integer)this.navigator.getNodes().inverse().get(node));
                    return;
                }
                if (!nodeGui.state().isHoveredAndTopElement() || !nodeGui.state().isEnabled()) continue;
                this.getNavigator().click(node, (Integer)this.navigator.getNodes().inverse().get(node));
            }
        }
    }

    private void refreshNodes() {
        if (this.addButton != null) {
            this.context().removeChild(this.addButton);
        }
        this.visibleNodes.clear();
        List<NODE_GUI> guiNodes = this.listVisibleNodes(Lists.newArrayList((Iterable)this.navigator.getNodes().values()), this.currentScroll, (int)this.dim().height(), (int)this.dim().width());
        this.visibleDeletes.forEach(this.context()::removeChild);
        this.visibleGuiNodes.forEach(this.context()::removeChild);
        this.visibleGuiNodes.clear();
        this.visibleDeletes.clear();
        this.visibleGuiNodes.addAll(guiNodes);
        this.visibleGuiNodes.forEach(this.context()::addChildren);
        if (this.allowModifications) {
            this.visibleGuiNodes.forEach(g -> {
                GuiAbstractButton deleteButton = GuiFactoryGeneric.createDeleteButton();
                deleteButton.dim().mod().pos(Pos2D.flush(g.dim().originalState().x(), g.dim().originalState().y())).addX(g.dim().width()).flush();
                this.visibleDeletes.add(deleteButton);
                this.context().addChildren((IGuiElement)deleteButton);
            });
        }
        if (this.addButton != null) {
            this.context().addChildren((IGuiElement)this.addButton);
        }
        this.addButton.state().setCanBeTopHoverElement(true);
    }

    @Override
    public void onMouseWheel(GuiElement element, int state) {
        int oldScroll = this.currentScroll;
        this.currentScroll = Math.max(0, Math.min(this.maxScroll, this.currentScroll - state / 120));
        this.refreshNodes();
        this.listeners.forEach(l -> l.onScroll(oldScroll, this.currentScroll));
    }

    @Override
    public void build() {
        this.refreshNodes();
    }

    @Override
    public void onRemoveNode(NODE node, int index) {
        this.refreshNodes();
    }

    @Override
    public void onAddNode(NODE node, int index, boolean newNode) {
        this.refreshNodes();
    }

    @Override
    public void onNodeClicked(NODE node, int index) {
    }

    public static interface NodeFactory<N, G> {
        public G create(Pos2D var1, N var2, int var3);
    }
}

