/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.gui.util.vanilla;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.client.gui.util.GuiFrameUtils;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiContext;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiEvent;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiState;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiViewer;
import com.gildedgames.orbis.lib.client.gui.util.vanilla.GuiContainerCreativePublic;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.util.InputHelper;
import com.gildedgames.orbis.lib.util.mc.GuiUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiFrameCreative
extends GuiContainerCreativePublic
implements IGuiViewer {
    private static boolean preventInnerTyping = false;
    private final List<IGuiElement> allParentsRecursive = Lists.newArrayList();
    private final IGuiViewer previousViewer;
    private List<IGuiElement> allVisibleElements = Lists.newArrayList();
    private boolean drawDefaultBackground;
    private IGuiElement viewing;
    private List<IGuiElement> drawn = Lists.newArrayList();
    private List<IGuiElement> hasBeenPostDrawn = Lists.newArrayList();
    private List<IGuiElement> childrenCache = Lists.newArrayList();
    private List<IGuiElement> elementsCurrentlyBuilding = Lists.newArrayList();
    private boolean recacheRequested;
    private boolean contextChanged;
    private Map<IGuiElement, List<IGuiElement>> subListCache = Maps.newHashMap();
    private List<String> hoverDescription;

    public GuiFrameCreative(EntityPlayer player) {
        super(player);
        this.viewing = new GuiElement(Dim2D.flush(), false);
        this.previousViewer = null;
    }

    public GuiFrameCreative(IGuiElement viewing, EntityPlayer player) {
        this(viewing, null, player);
    }

    public GuiFrameCreative(IGuiElement viewing, IGuiViewer previousViewer, EntityPlayer player) {
        super(player);
        this.previousViewer = previousViewer;
        this.viewing = viewing;
    }

    public static void preventInnerTyping() {
        preventInnerTyping = true;
    }

    public static void fetchAllVisibleChildren(List<IGuiElement> allChildren, IGuiContext top) {
        if (top.getOwner().state().isVisible()) {
            allChildren.addAll(top.getChildren());
            top.getChildren().forEach(element -> GuiFrameCreative.fetchAllVisibleChildren(allChildren, element.context()));
        }
    }

    @Override
    public void setHoveredDescription(List<String> desc) {
        this.hoverDescription = desc;
    }

    @Override
    public void notifyGlobalContextChange() {
        this.contextChanged = true;
    }

    @Override
    public void notifyBuildingStarted(IGuiElement element) {
        if (!this.elementsCurrentlyBuilding.contains(element)) {
            this.elementsCurrentlyBuilding.add(element);
        }
    }

    @Override
    public void notifyBuildingFinished(IGuiElement element) {
        this.elementsCurrentlyBuilding.remove(element);
    }

    @Override
    public IGuiViewer getPreviousViewer() {
        return this.previousViewer;
    }

    @Override
    public IGuiElement getViewing() {
        return this.viewing;
    }

    @Override
    public int getScreenWidth() {
        return this.field_146294_l;
    }

    @Override
    public int getScreenHeight() {
        return this.field_146295_m;
    }

    @Override
    public Minecraft mc() {
        return this.field_146297_k;
    }

    @Override
    public FontRenderer fontRenderer() {
        return this.field_146289_q;
    }

    @Override
    public void requestRecacheAndReorderAllVisibleElements() {
        this.recacheRequested = true;
    }

    @Override
    public List<IGuiElement> getAllVisibleElements() {
        return this.allVisibleElements;
    }

    @Override
    public Collection<IGuiElement> getAllVisibleElementsBelow(IGuiElement child) {
        if (!this.allVisibleElements.contains(child)) {
            return Collections.emptyList();
        }
        if (!this.subListCache.containsKey(child)) {
            int startIndex = this.allVisibleElements.indexOf(child);
            this.subListCache.put(child, this.allVisibleElements.subList(startIndex, this.allVisibleElements.size() - 1));
        }
        return this.subListCache.get(child);
    }

    @Override
    public Collection<IGuiElement> getAllVisibleElementsAbove(IGuiElement child) {
        if (!this.allParentsRecursive.contains(child)) {
            return Collections.emptyList();
        }
        int startIndex = this.allParentsRecursive.indexOf(child);
        return this.allParentsRecursive.subList(startIndex, this.allParentsRecursive.size() - 1);
    }

    @Override
    public void pushActionPerformed(GuiButton button) {
        try {
            this.func_146284_a(button);
        }
        catch (IOException e) {
            OrbisLib.LOGGER.info((Object)e);
        }
    }

    @Override
    public GuiScreen getActualScreen() {
        return this;
    }

    public void setDrawDefaultBackground(boolean flag) {
        this.drawDefaultBackground = flag;
    }

    public void func_146276_q_() {
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
    }

    @Override
    public void func_73866_w_() {
        if (Minecraft.func_71410_x().field_71462_r == this) {
            super.func_73866_w_();
        }
        if (!this.viewing.state().hasBuilt()) {
            this.viewing.build(this);
            this.build(this.viewing.context());
            this.initContainerSize();
            this.requestRecacheAndReorderAllVisibleElements();
        }
    }

    public abstract void build(IGuiContext var1);

    public void initContainerSize() {
    }

    private void drawElement(IGuiElement element, boolean debugDimRendering) {
        IGuiState state = element.state();
        if (!state.isVisible()) {
            return;
        }
        if (debugDimRendering) {
            GuiFrameCreative.func_73734_a((int)((int)state.dim().x()), (int)((int)state.dim().y()), (int)((int)state.dim().maxX()), (int)((int)state.dim().maxY()), (int)Integer.MAX_VALUE);
        }
        float x = state.dim().x();
        float y = state.dim().y();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179109_b((float)(x + state.dim().originX()), (float)(y + state.dim().originY()), (float)0.0f);
        GlStateManager.func_179109_b((float)(state.dim().isCenteredX() ? state.dim().width() / 2.0f : 0.0f), (float)(state.dim().isCenteredY() ? state.dim().height() / 2.0f : 0.0f), (float)0.0f);
        if (state.getShouldScaleRender()) {
            GlStateManager.func_179152_a((float)state.dim().scale(), (float)state.dim().scale(), (float)0.0f);
        }
        GlStateManager.func_179114_b((float)state.dim().degrees(), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(state.dim().isCenteredX() ? -(state.dim().width() / 2.0f) : 0.0f), (float)(state.dim().isCenteredY() ? -(state.dim().height() / 2.0f) : 0.0f), (float)0.0f);
        GlStateManager.func_179109_b((float)(-x - state.dim().originX()), (float)(-y - state.dim().originY()), (float)0.0f);
        GuiFrameUtils.applyAlpha(state);
        for (IGuiEvent event : state.getEvents()) {
            event.onPreDraw(element);
        }
        for (IGuiEvent event : state.getEvents()) {
            event.onDraw(element);
        }
        for (IGuiEvent event : state.getEvents()) {
            event.onPostDraw(element);
        }
        GlStateManager.func_179121_F();
    }

    protected void drawElements() {
        for (IGuiElement element : this.allVisibleElements) {
            element.state().updateState();
            this.drawElement(element, false);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.elementsCurrentlyBuilding.isEmpty() && this.recacheRequested) {
            this.subListCache.clear();
            this.allVisibleElements.clear();
            GuiFrameCreative.fetchAllVisibleChildren(this.allVisibleElements, this.viewing.context());
            this.allVisibleElements.sort(Comparator.comparingInt(element -> element.state().getZOrder()));
            this.recacheRequested = false;
        }
        if (this.contextChanged) {
            this.allVisibleElements.forEach(element -> element.state().getEvents().forEach(event -> event.onGlobalContextChanged(element)));
            this.contextChanged = false;
        }
        preventInnerTyping = false;
        super.func_146276_q_();
        GlStateManager.func_179094_E();
        InputHelper.markHoveredAndTopElements(this, false);
        this.drawElements();
        GL11.glDisable((int)3008);
        GlStateManager.func_179118_c();
        GlStateManager.func_179121_F();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.hoverDescription != null && this.hoverDescription.size() > 0) {
            GuiUtils.drawHoveringText(this.hoverDescription, mouseX, mouseY, Minecraft.func_71410_x().field_71466_p);
        }
        this.hoverDescription = null;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.allVisibleElements.forEach(element -> {
            for (IGuiEvent event2 : element.state().getEvents()) {
                if (event2.isMouseClickedEnabled(element, mouseX, mouseY, mouseButton)) continue;
                return;
            }
            element.state().getEvents().forEach(event -> event.onMouseClicked(element, mouseX, mouseY, mouseButton));
        });
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.allVisibleElements.forEach(element -> {
            for (IGuiEvent event2 : element.state().getEvents()) {
                if (event2.isMouseClickMoveEnabled(element, mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) continue;
                return;
            }
            element.state().getEvents().forEach(event -> event.onMouseClickMove(element, mouseX, mouseY, clickedMouseButton, timeSinceLastClick));
        });
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.allVisibleElements.forEach(element -> {
            for (IGuiEvent event2 : element.state().getEvents()) {
                if (event2.isMouseReleasedEnabled(element, mouseX, mouseY, state)) continue;
                return;
            }
            element.state().getEvents().forEach(event -> event.onMouseReleased(element, mouseX, mouseY, state));
        });
    }

    @Override
    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        super.func_184098_a(slotIn, slotId, mouseButton, type);
        this.allVisibleElements.forEach(element -> {
            for (IGuiEvent event2 : element.state().getEvents()) {
                if (event2.isHandleMouseClickEnabled(element, slotIn, slotId, mouseButton, type)) continue;
                return;
            }
            element.state().getEvents().forEach(event -> event.onHandleMouseClick(element, slotIn, slotId, mouseButton, type));
        });
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int state = Mouse.getEventDWheel();
        if (state != 0) {
            this.onMouseWheel(state);
        }
    }

    protected void onMouseWheel(int state) {
        this.allVisibleElements.forEach(element -> {
            for (IGuiEvent event2 : element.state().getEvents()) {
                if (event2.isMouseWheelEnabled(element, state)) continue;
                return;
            }
            element.state().getEvents().forEach(event -> event.onMouseWheel(element, state));
        });
    }

    protected void keyTypedInner(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!preventInnerTyping) {
            this.keyTypedInner(typedChar, keyCode);
        }
        this.allVisibleElements.forEach(element -> {
            for (IGuiEvent event2 : element.state().getEvents()) {
                if (event2.isKeyboardEnabled(element)) continue;
                return;
            }
            element.state().getEvents().forEach(event -> event.onKeyTyped(element, typedChar, keyCode));
        });
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        this.allVisibleElements.forEach(element -> element.state().getEvents().forEach(event -> event.onGuiClosed(element)));
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.allVisibleElements.forEach(element -> element.state().getEvents().forEach(event -> event.onUpdateScreen(element)));
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        this.allVisibleElements.forEach(element -> element.state().getEvents().forEach(event -> event.onActionPerformed(element, button)));
    }

    public void func_175273_b(Minecraft mcIn, int w, int h) {
        super.func_175273_b(mcIn, w, h);
        this.allVisibleElements.forEach(element -> element.state().dim().refreshModifiedState());
    }
}

