/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.rect;

import com.gildedgames.orbis.lib.client.rect.BuildWithRectHolder;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.client.rect.Rect;
import com.gildedgames.orbis.lib.client.rect.RectBuilder;
import com.gildedgames.orbis.lib.client.rect.RectHolder;
import com.gildedgames.orbis.lib.client.rect.helpers.RectCollection;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.math.MathHelper;

public class Dim2D
implements Rect {
    private final Pos2D min;
    private final Pos2D max;
    private final float degrees;
    private final float originX;
    private final float originY;
    private final float width;
    private final float height;
    private final boolean centeredX;
    private final boolean centeredY;
    private final Pos2D center;
    private final float scale;
    private final boolean snapToIntegers;

    private Dim2D() {
        this(new RectBuilder());
    }

    Dim2D(RectBuilder builder) {
        this.snapToIntegers = builder.snapToIntegers;
        this.width = this.snapToIntegers ? (float)MathHelper.func_76141_d((float)builder.width) : builder.width;
        this.height = this.snapToIntegers ? (float)MathHelper.func_76141_d((float)builder.height) : builder.height;
        this.scale = builder.scale;
        this.centeredX = builder.centeredX;
        this.centeredY = builder.centeredY;
        this.degrees = builder.degrees;
        this.originX = this.snapToIntegers ? (float)MathHelper.func_76141_d((float)builder.originX) : builder.originX;
        this.originY = this.snapToIntegers ? (float)MathHelper.func_76141_d((float)builder.originY) : builder.originY;
        this.min = Pos2D.flush(this.snapToIntegers ? (float)MathHelper.func_76141_d((float)builder.posX) : builder.posX, this.snapToIntegers ? (float)MathHelper.func_76141_d((float)builder.posY) : builder.posY);
        this.max = Pos2D.flush(this.snapToIntegers ? (float)MathHelper.func_76141_d((float)(this.min.x() + this.width)) : this.min.x() + this.width, this.snapToIntegers ? (float)MathHelper.func_76141_d((float)(this.min.y() + this.height)) : this.min.y() + this.height);
        this.center = Pos2D.flush(this.snapToIntegers ? (float)MathHelper.func_76141_d((float)(this.min.x() + this.width / 2.0f)) : this.min.x() + this.width / 2.0f, this.snapToIntegers ? (float)MathHelper.func_76141_d((float)(this.min.y() + this.height / 2.0f)) : this.min.y() + this.height / 2.0f);
    }

    public static Rect flush() {
        return new Dim2D();
    }

    public static RectBuilder build() {
        return new RectBuilder();
    }

    public static RectBuilder build(RectHolder holder) {
        return new RectBuilder(holder);
    }

    public static RectBuilder build(Rect dim) {
        return new RectBuilder(dim);
    }

    public static Rect combine(Rect ... dimensions) {
        return Dim2D.combine(Arrays.asList(dimensions));
    }

    public static Rect combine(List<Rect> dimensions) {
        RectBuilder result = new RectBuilder();
        if (dimensions.isEmpty()) {
            throw new IllegalArgumentException();
        }
        float overallScale = 0.0f;
        int validDimensions = 0;
        Rect rect1 = dimensions.get(0);
        result.pos(rect1.x(), rect1.y()).area(rect1.maxX() - rect1.x(), rect1.maxY() - rect1.y());
        for (Rect dim : dimensions) {
            if (dim == null) continue;
            Rect preview = result.flush();
            float minX = Math.min(preview.x(), dim.x());
            float minY = Math.min(preview.y(), dim.y());
            float maxX = Math.max(preview.x() + preview.width(), dim.x() + dim.width());
            float maxY = Math.max(preview.y() + preview.height(), dim.y() + dim.height());
            result.pos(minX, minY).area(maxX - minX, maxY - minY);
            overallScale += dim.scale();
            ++validDimensions;
        }
        result.scale(overallScale / (float)validDimensions);
        return result.flush();
    }

    public static BuildWithRectHolder buildWith(RectHolder holder) {
        return new BuildWithRectHolder(Dim2D.build(), holder);
    }

    @Override
    public RectBuilder rebuild() {
        return Dim2D.build(this);
    }

    @Override
    public float degrees() {
        return this.degrees;
    }

    @Override
    public float originX() {
        return this.originX;
    }

    @Override
    public float originY() {
        return this.originY;
    }

    @Override
    public float scale() {
        return this.scale;
    }

    @Override
    public float maxX() {
        return this.max.x();
    }

    @Override
    public float maxY() {
        return this.max.y();
    }

    @Override
    public float x() {
        return this.min.x();
    }

    @Override
    public float y() {
        return this.min.y();
    }

    @Override
    public float width() {
        return this.width;
    }

    @Override
    public float height() {
        return this.height;
    }

    @Override
    public boolean isCenteredX() {
        return this.centeredX;
    }

    @Override
    public boolean isCenteredY() {
        return this.centeredY;
    }

    @Override
    public boolean intersects(float x, float y) {
        return x >= this.x() && y >= this.y() && x < this.maxX() && y < this.maxY();
    }

    @Override
    public boolean intersects(Rect dim) {
        return dim.maxX() >= this.x() && dim.maxY() >= this.y() && dim.x() < this.maxX() && dim.y() < this.maxY();
    }

    @Override
    public boolean snapToIntegers() {
        return this.snapToIntegers;
    }

    public RectBuilder clone() {
        return new RectBuilder(this);
    }

    public RectHolder toHolder() {
        return RectCollection.flush(this);
    }

    public String toString() {
        String link = ", ";
        return "X " + this.min.x() + " Y " + this.min.y() + ", " + "Area() Width: '" + this.width() + "', Height: '" + this.height() + "'" + ", " + "Centered() X: '" + this.centeredX + "', Y: '" + this.centeredY + "'" + ", " + "Scale() Value: '" + this.scale() + "'";
    }

    public boolean equals(Object obj) {
        Rect dim;
        if (obj instanceof Rect) {
            dim = (Rect)obj;
        } else if (obj instanceof RectHolder) {
            RectHolder holder = (RectHolder)obj;
            dim = holder.dim();
        } else {
            return false;
        }
        return dim.x() == this.x() && dim.y() == this.y() && dim.scale() == this.scale() && dim.isCenteredX() == this.centeredX && dim.isCenteredY() == this.centeredY && dim.width() == this.width() && dim.height() == this.height() && dim.degrees() == this.degrees() && dim.originX() == this.originX() && dim.originY() == this.originY();
    }

    @Override
    public float centerX() {
        return this.center.x();
    }

    @Override
    public float centerY() {
        return this.center.y();
    }

    @Override
    public Pos2D center() {
        return this.center;
    }

    @Override
    public Pos2D min() {
        return this.min;
    }
}

