/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.rect;

import com.gildedgames.orbis.lib.client.rect.BuildIntoRectHolder;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.client.rect.Rect;
import com.gildedgames.orbis.lib.client.rect.RectBuilder;
import com.gildedgames.orbis.lib.client.rect.RectHolder;
import com.gildedgames.orbis.lib.client.rect.RectListener;
import com.gildedgames.orbis.lib.client.rect.RectModifier;
import com.gildedgames.orbis.lib.util.ObjectFilter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ModDim2D
implements Rect {
    private final BuildIntoRectHolder buildInto;
    private final RectListener ourListener;
    private List<RectModifier> modifiers = Lists.newArrayList();
    private List<RectListener> listeners = Lists.newArrayList();
    private Rect originalState = Dim2D.flush();
    private Rect modifiedState = Dim2D.flush();
    private boolean preventRecursion = false;

    public ModDim2D() {
        this.buildInto = new BuildIntoRectHolder(this);
        this.ourListener = this.createListener();
    }

    public static ModDim2D build() {
        return new ModDim2D();
    }

    public static ModDim2D build(Rect rect) {
        ModDim2D dim = new ModDim2D();
        dim.set(rect);
        return dim;
    }

    public static ModDim2D clone(RectHolder owner) {
        return owner.dim().clone();
    }

    public static List<RectModifier.ModifierType> getChangedTypes(Rect r1, Rect r2) {
        ArrayList types = Lists.newArrayList();
        if (r1.x() != r2.x()) {
            types.add(RectModifier.ModifierType.X);
        }
        if (r1.y() != r2.y()) {
            types.add(RectModifier.ModifierType.Y);
        }
        if (r1.width() != r2.width()) {
            types.add(RectModifier.ModifierType.WIDTH);
        }
        if (r1.height() != r2.height()) {
            types.add(RectModifier.ModifierType.HEIGHT);
        }
        if (r1.degrees() != r2.degrees()) {
            types.add(RectModifier.ModifierType.ROTATION);
        }
        return types;
    }

    private RectListener createListener() {
        return types -> this.refreshModifiedState();
    }

    public Rect originalState() {
        return this.originalState;
    }

    private Rect modifiedState() {
        return this.modifiedState;
    }

    public BuildIntoRectHolder mod() {
        return this.buildInto;
    }

    public RectBuilder copyRect() {
        return new RectBuilder(this);
    }

    public ModDim2D clone() {
        ModDim2D clone = new ModDim2D();
        clone.set(this);
        return clone;
    }

    public ModDim2D set(RectHolder holder) {
        this.set(holder.dim());
        return this;
    }

    public ModDim2D set(Rect dim) {
        this.originalState = dim;
        this.buildInto.set(this.originalState);
        this.refreshModifiedState();
        return this;
    }

    public ModDim2D set(ModDim2D modDim) {
        this.modifiers = new ArrayList<RectModifier>(modDim.modifiers);
        this.listeners = new ArrayList<RectListener>(modDim.listeners);
        this.originalState = modDim.originalState;
        this.modifiedState = modDim.modifiedState;
        this.buildInto.set(this.originalState);
        return this;
    }

    public void refreshModifiedState() {
        Rect oldModifiedState = this.modifiedState;
        float degrees = this.originalState.degrees();
        float scale = this.originalState.scale();
        float posX = this.originalState.x();
        float posY = this.originalState.y();
        float width = this.originalState.width();
        float height = this.originalState.height();
        for (RectModifier modifier : this.mods()) {
            Object modifyingWithValue;
            RectHolder source;
            if (modifier == null || (source = modifier.getSource()) != null && (source.dim() == null || source.dim() == this)) continue;
            if (modifier.getModifying().equals((Object)RectModifier.ModifierType.ROTATION) && (modifyingWithValue = modifier.getModification().getValue(source, RectModifier.ModifierType.ROTATION)) instanceof Number) {
                degrees += ((Number)modifyingWithValue).floatValue();
            }
            if (modifier.getModifying().equals((Object)RectModifier.ModifierType.SCALE) && (modifyingWithValue = modifier.getModification().getValue(source, RectModifier.ModifierType.SCALE)) instanceof Number) {
                scale *= ((Number)modifyingWithValue).floatValue();
            }
            if ((modifier.getModifying().equals((Object)RectModifier.ModifierType.X) || modifier.getModifying().equals((Object)RectModifier.ModifierType.POS)) && (modifyingWithValue = modifier.getModification().getValue(source, RectModifier.ModifierType.X)) instanceof Number) {
                posX += ((Number)modifyingWithValue).floatValue();
            }
            if ((modifier.getModifying().equals((Object)RectModifier.ModifierType.Y) || modifier.getModifying().equals((Object)RectModifier.ModifierType.POS)) && (modifyingWithValue = modifier.getModification().getValue(source, RectModifier.ModifierType.Y)) instanceof Number) {
                posY += ((Number)modifyingWithValue).floatValue();
            }
            if ((modifier.getModifying().equals((Object)RectModifier.ModifierType.WIDTH) || modifier.getModifying().equals((Object)RectModifier.ModifierType.AREA)) && (modifyingWithValue = modifier.getModification().getValue(source, RectModifier.ModifierType.WIDTH)) instanceof Number) {
                width += ((Number)modifyingWithValue).floatValue();
            }
            if (!modifier.getModifying().equals((Object)RectModifier.ModifierType.HEIGHT) && !modifier.getModifying().equals((Object)RectModifier.ModifierType.AREA) || !((modifyingWithValue = modifier.getModification().getValue(source, RectModifier.ModifierType.HEIGHT)) instanceof Number)) continue;
            height += ((Number)modifyingWithValue).floatValue();
        }
        float offsetX = this.originalState.isCenteredX() ? width * this.originalState.scale() / 2.0f : 0.0f;
        float offsetY = this.originalState.isCenteredY() ? height * this.originalState.scale() / 2.0f : 0.0f;
        this.modifiedState = Dim2D.build(this.originalState).pos(posX -= offsetX, posY -= offsetY).area(width *= this.originalState.scale(), height *= this.originalState.scale()).degrees(degrees).scale(scale).flush();
        if (this.preventRecursion) {
            return;
        }
        this.preventRecursion = true;
        List<RectModifier.ModifierType> changedTypes = ModDim2D.getChangedTypes(oldModifiedState, this.modifiedState);
        for (RectListener listener : this.listeners) {
            listener.notifyDimChange(changedTypes);
        }
        this.preventRecursion = false;
    }

    public Collection<RectModifier> mods() {
        return this.modifiers;
    }

    public boolean containsModifier(String identifier) {
        for (RectModifier modifier : this.modifiers) {
            if (!modifier.getIdentifier().equals(identifier)) continue;
            return true;
        }
        return false;
    }

    public boolean containsModifier(String identifier, RectHolder source) {
        for (RectModifier modifier : this.modifiers) {
            if (!modifier.getIdentifier().equals(identifier) || modifier.getSource() != source) continue;
            return true;
        }
        return false;
    }

    public ModDim2D clearRectModifiers() {
        this.clear(new RectModifier.ModifierType[0]);
        return this;
    }

    public ModDim2D clear(RectModifier.ModifierType ... types) {
        if (types.length == 0) {
            for (RectModifier modifier : this.modifiers) {
                if (modifier.getSource() == null) continue;
                modifier.getSource().dim().removeListener(this.ourListener);
            }
            this.modifiers.clear();
            this.refreshModifiedState();
            return this;
        }
        final ArrayList list = Lists.newArrayList();
        Collections.addAll(list, types);
        this.modifiers = ObjectFilter.getTypesFrom(this.modifiers, new ObjectFilter.FilterCondition<RectModifier>(this.modifiers){

            @Override
            public boolean isType(RectModifier modifier) {
                for (RectModifier.ModifierType type : ObjectFilter.getTypesFrom(list, RectModifier.ModifierType.class)) {
                    if (!modifier.getModifying().equals((Object)type)) continue;
                    return false;
                }
                return true;
            }
        });
        this.refreshModifiedState();
        return this;
    }

    public ModDim2D add(RectModifier rectModifier) {
        if (!this.modifiers.contains(rectModifier)) {
            this.modifiers.add(rectModifier);
            if (rectModifier.getSource() != null) {
                rectModifier.getSource().dim().addListener(this.ourListener);
            }
            this.refreshModifiedState();
        }
        return this;
    }

    public ModDim2D add(String identifier, RectHolder source, RectModifier.ModifierType mandatory, RectModifier.ModifierType ... modifying) {
        ArrayList modifiers = Lists.newArrayList();
        modifiers.add(mandatory);
        modifiers.addAll(Lists.newArrayList((Object[])modifying));
        for (RectModifier.ModifierType type : modifiers) {
            this.add(identifier, source, new RectModifier.RectModification[]{type.getModification()}, new RectModifier.ModifierType[]{type});
        }
        return this;
    }

    public ModDim2D add(String identifier, RectHolder source, RectModifier.RectModification[] modifications, RectModifier.ModifierType[] modifying) {
        if (source.dim().equals(this)) {
            throw new IllegalArgumentException();
        }
        for (RectModifier.RectModification modificationEntry : modifications) {
            for (RectModifier.ModifierType modifyingEntry : Lists.newArrayList((Object[])modifying)) {
                RectModifier modifier = new RectModifier(identifier, source, modificationEntry, modifyingEntry);
                if (this.modifiers.contains(modifier)) continue;
                this.modifiers.add(modifier);
                source.dim().addListener(this.ourListener);
                this.refreshModifiedState();
            }
        }
        return this;
    }

    public boolean removeModifiers(String identifier, RectHolder source) {
        boolean success = false;
        Iterator<RectModifier> iter = this.modifiers.iterator();
        while (iter.hasNext()) {
            RectModifier modifier = iter.next();
            if (!modifier.getIdentifier().equals(identifier) || modifier.getSource() != source) continue;
            iter.remove();
            success = true;
        }
        if (!this.hasModifiersFor(source)) {
            source.dim().removeListener(this.ourListener);
        }
        this.refreshModifiedState();
        return success;
    }

    public boolean removeModifiers(String identifier) {
        boolean success = false;
        Iterator<RectModifier> iter = this.modifiers.iterator();
        while (iter.hasNext()) {
            RectModifier modifier = iter.next();
            if (!modifier.getIdentifier().equals(identifier)) continue;
            iter.remove();
            if (modifier.getSource() != null && !this.hasModifiersFor(modifier.getSource())) {
                modifier.getSource().dim().removeListener(this.ourListener);
            }
            success = true;
        }
        this.refreshModifiedState();
        return success;
    }

    private boolean hasModifiersFor(RectHolder holder) {
        for (RectModifier rModifier : this.modifiers) {
            if (rModifier.getSource() == null || !rModifier.getSource().equals(holder)) continue;
            return true;
        }
        return false;
    }

    public void addListener(RectListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean removeListener(RectListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public float degrees() {
        return this.modifiedState().degrees();
    }

    @Override
    public float originX() {
        return this.modifiedState().originX();
    }

    @Override
    public float originY() {
        return this.modifiedState().originY();
    }

    @Override
    public float scale() {
        return this.modifiedState().scale();
    }

    @Override
    public float maxX() {
        return this.modifiedState().maxX();
    }

    @Override
    public float maxY() {
        return this.modifiedState().maxY();
    }

    @Override
    public float x() {
        return this.modifiedState().x();
    }

    @Override
    public float y() {
        return this.modifiedState().y();
    }

    @Override
    public float width() {
        return this.modifiedState().width();
    }

    @Override
    public float height() {
        return this.modifiedState().height();
    }

    @Override
    public boolean isCenteredX() {
        return this.modifiedState().isCenteredX();
    }

    @Override
    public boolean isCenteredY() {
        return this.modifiedState().isCenteredY();
    }

    @Override
    public boolean intersects(float x, float y) {
        return this.modifiedState().intersects(x, y);
    }

    @Override
    public boolean intersects(Rect dim) {
        return this.modifiedState().intersects(dim);
    }

    @Override
    public boolean snapToIntegers() {
        return this.modifiedState().snapToIntegers();
    }

    @Override
    public RectBuilder rebuild() {
        return this.modifiedState().rebuild();
    }

    public String toString() {
        return this.modifiedState.toString();
    }

    @Override
    public float centerX() {
        return this.modifiedState.centerX();
    }

    @Override
    public float centerY() {
        return this.modifiedState.centerY();
    }

    @Override
    public Pos2D center() {
        return this.modifiedState.center();
    }

    @Override
    public Pos2D min() {
        return this.modifiedState.min();
    }
}

