/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.rect;

public class Pos2D {
    public static Pos2D ORIGIN = Pos2D.flush(0.0f, 0.0f);
    private final float x;
    private final float y;

    private Pos2D(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public static Pos2D flush() {
        return new Pos2DBuilder().flush();
    }

    public static Pos2D flush(float x, float y) {
        return new Pos2D(x, y);
    }

    public static Pos2DBuilder build() {
        return new Pos2DBuilder();
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public String toString() {
        return "Position() X: '" + this.x + "', Y: '" + this.y + "'";
    }

    public Pos2DBuilder clone() {
        return new Pos2DBuilder(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Pos2D)) {
            return false;
        }
        Pos2D pos = (Pos2D)obj;
        return pos.x() == this.x() && pos.y() == this.y();
    }

    public static class Pos2DBuilder {
        private float x;
        private float y;

        private Pos2DBuilder() {
        }

        private Pos2DBuilder(Pos2D pos) {
            this.x = pos.x;
            this.y = pos.y;
        }

        private Pos2DBuilder(Pos2DBuilder builder) {
            this.x = builder.x;
            this.y = builder.y;
        }

        public Pos2DBuilder x(float x) {
            this.x = x;
            return this;
        }

        public Pos2DBuilder y(float y) {
            this.y = y;
            return this;
        }

        public Pos2DBuilder addX(float x) {
            return this.add(x, 0.0f);
        }

        public Pos2DBuilder addY(float y) {
            return this.add(0.0f, y);
        }

        public Pos2DBuilder subtractX(float x) {
            return this.subtract(x, 0.0f);
        }

        public Pos2DBuilder subtractY(float y) {
            return this.subtract(0.0f, y);
        }

        public Pos2DBuilder subtract(float x, float y) {
            return this.add(-x, -y);
        }

        public Pos2DBuilder subtract(Pos2D pos) {
            if (pos == null) {
                return this;
            }
            return this.add(-pos.x, -pos.y);
        }

        public Pos2DBuilder add(float x, float y) {
            this.x += x;
            this.y += y;
            return this;
        }

        public Pos2DBuilder add(Pos2D pos) {
            if (pos == null) {
                return this;
            }
            return this.add(pos.x, pos.y);
        }

        public Pos2D flush() {
            return new Pos2D(this.x, this.y);
        }
    }
}

