/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.rect;

import com.gildedgames.orbis.lib.client.rect.RectHolder;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class RectModifier {
    private final RectHolder source;
    private final ModifierType modifying;
    private final RectModification modification;
    private String identifier;

    public RectModifier(String identifier, RectModification modification, ModifierType modifying) {
        this(identifier, null, modification, modifying);
    }

    public RectModifier(String identifier, RectHolder source, RectModification modification, ModifierType modifying) {
        this.identifier = identifier;
        this.source = source;
        this.modification = modification;
        this.modifying = modifying;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public RectHolder getSource() {
        return this.source;
    }

    public RectModification getModification() {
        return this.modification;
    }

    public ModifierType getModifying() {
        return this.modifying;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof RectModifier)) {
            return false;
        }
        RectModifier modifier = (RectModifier)obj;
        return modifier.identifier.equals(this.identifier);
    }

    public int hashCode() {
        return new HashCodeBuilder(97, 37).append((Object)this.identifier).toHashCode();
    }

    public static interface RectModification {
        public Object getValue(RectHolder var1, ModifierType var2);
    }

    public static enum ModifierType {
        X{
            private RectModification modification = (modifyingWith, modifying) -> Float.valueOf(modifyingWith.dim().x());

            @Override
            public RectModification getModification() {
                return this.modification;
            }
        }
        ,
        Y{
            private RectModification modification = (modifyingWith, modifying) -> Float.valueOf(modifyingWith.dim().y());

            @Override
            public RectModification getModification() {
                return this.modification;
            }
        }
        ,
        MAX_X{
            private RectModification modification = (modifyingWith, modifying) -> Float.valueOf(modifyingWith.dim().maxX());

            @Override
            public RectModification getModification() {
                return this.modification;
            }
        }
        ,
        MAX_Y{
            private RectModification modification = (modifyingWith, modifying) -> Float.valueOf(modifyingWith.dim().maxY());

            @Override
            public RectModification getModification() {
                return this.modification;
            }
        }
        ,
        POS{
            private RectModification modification;

            @Override
            public RectModification getModification() {
                if (this.modification == null) {
                    this.modification = (modifyingWith, modifying) -> {
                        if (modifying == X) {
                            return Float.valueOf(modifyingWith.dim().x());
                        }
                        if (modifying == Y) {
                            return Float.valueOf(modifyingWith.dim().y());
                        }
                        return 0;
                    };
                }
                return this.modification;
            }
        }
        ,
        WIDTH{
            private RectModification modification = (modifyingWith, modifying) -> Float.valueOf(modifyingWith.dim().width());

            @Override
            public RectModification getModification() {
                return this.modification;
            }
        }
        ,
        HEIGHT{
            private RectModification modification = (modifyingWith, modifying) -> Float.valueOf(modifyingWith.dim().height());

            @Override
            public RectModification getModification() {
                return this.modification;
            }
        }
        ,
        AREA{
            private RectModification modification;

            @Override
            public RectModification getModification() {
                if (this.modification == null) {
                    this.modification = (modifyingWith, modifying) -> {
                        if (modifying == WIDTH) {
                            return Float.valueOf(modifyingWith.dim().width());
                        }
                        if (modifying == HEIGHT) {
                            return Float.valueOf(modifyingWith.dim().height());
                        }
                        return 0;
                    };
                }
                return this.modification;
            }
        }
        ,
        SCALE{
            private RectModification modification = (modifyingWith, modifying) -> Float.valueOf(modifyingWith.dim().scale());

            @Override
            public RectModification getModification() {
                return this.modification;
            }
        }
        ,
        ROTATION{
            private RectModification modification = (modifyingWith, modifying) -> Float.valueOf(modifyingWith.dim().degrees());

            @Override
            public RectModification getModification() {
                return this.modification;
            }
        };


        public abstract RectModification getModification();
    }
}

