/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.client.rect.helpers;

import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.client.rect.Rect;
import com.gildedgames.orbis.lib.client.rect.RectHolder;
import com.gildedgames.orbis.lib.client.rect.helpers.RectCollection;
import com.gildedgames.orbis.lib.client.rect.helpers.RectSeekable;
import com.gildedgames.orbis.lib.client.rect.helpers.RectSeeker;
import com.google.common.collect.Lists;
import java.util.List;

public class RectCollectionBuilder {
    private final List<RectHolder> holders = Lists.newArrayList();
    private final List<RectSeekable> seekables = Lists.newArrayList();

    protected RectCollectionBuilder() {
    }

    public RectCollectionBuilder addDim(Rect dim) {
        this.holders.add(new RectCollection(dim));
        return this;
    }

    public RectCollectionBuilder removeDim(Rect dim) {
        this.holders.remove(new RectCollection(dim));
        return this;
    }

    public RectCollectionBuilder addHolder(RectHolder holder) {
        this.holders.add(holder);
        return this;
    }

    public RectCollectionBuilder removeHolder(RectHolder holder) {
        this.holders.remove(holder);
        return this;
    }

    public RectCollectionBuilder addSeekable(RectSeekable seekable) {
        this.seekables.add(seekable);
        return this;
    }

    public RectCollectionBuilder removeSeekable(RectSeekable seekable) {
        this.seekables.remove(seekable);
        return this;
    }

    public RectCollection flush() {
        RectCollection resultHolder = new RectCollection();
        if (this.holders.isEmpty()) {
            return resultHolder;
        }
        resultHolder.dim().set(this.holders.get(0));
        for (RectHolder holder : this.holders) {
            if (holder == null || holder.dim() == null) continue;
            resultHolder.dim().set(Dim2D.combine(resultHolder.dim(), holder.dim()));
        }
        for (RectSeekable seekable : this.seekables) {
            for (RectSeeker seeker : seekable.getRectSeekers()) {
                if (seeker == null || seeker.dim() == null) continue;
                resultHolder.dim().set(Dim2D.combine(resultHolder.dim(), seeker.dim()));
            }
        }
        return resultHolder;
    }
}

