/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core;

import com.gildedgames.orbis.lib.core.ICreationData;
import com.gildedgames.orbis.lib.util.mc.NBTHelper;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class CreationData
implements ICreationData<CreationData> {
    private Random rand;
    private long seed;
    private BlockPos pos = BlockPos.field_177992_a;
    private World world;
    private EntityPlayer creator;
    private Rotation rotation = Rotation.NONE;
    private boolean placeAir = true;
    private boolean schedules = false;
    private boolean placesVoid = false;
    private boolean spawnEntities = true;
    private int dimId;

    protected CreationData() {
    }

    public CreationData(World world) {
        this.world = world;
        if (world != null) {
            this.rand = world.field_73012_v;
        }
    }

    public CreationData(World world, long seed) {
        this.world = world;
        this.rand = new Random(seed);
    }

    public CreationData(World world, EntityPlayer creator) {
        this(world);
        this.creator = creator;
    }

    @Override
    public CreationData placesVoid(boolean placesVoid) {
        this.placesVoid = placesVoid;
        return this;
    }

    @Override
    public CreationData pos(BlockPos pos) {
        this.pos = pos;
        return this;
    }

    @Override
    public CreationData world(World world) {
        this.world = world;
        if (this.world != null) {
            this.dimId = this.world.field_73011_w.getDimension();
        }
        return this;
    }

    @Override
    public CreationData rotation(Rotation rotation) {
        this.rotation = rotation;
        return this;
    }

    @Override
    public CreationData seed(long seed) {
        this.seed = seed;
        this.rand = new Random(seed);
        return this;
    }

    @Override
    public CreationData creator(EntityPlayer creator) {
        this.creator = creator;
        return this;
    }

    @Override
    public CreationData placesAir(boolean placeAir) {
        this.placeAir = placeAir;
        return this;
    }

    @Override
    public CreationData schedules(boolean schedules) {
        this.schedules = schedules;
        return this;
    }

    @Override
    public CreationData spawnEntities(boolean spawnEntities) {
        this.spawnEntities = spawnEntities;
        return this;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public World getWorld() {
        if (this.world == null) {
            this.world = DimensionManager.getWorld((int)this.dimId);
        }
        return this.world;
    }

    @Override
    public Random getRandom() {
        return this.rand;
    }

    @Override
    public Rotation getRotation() {
        return this.rotation;
    }

    @Override
    public EntityPlayer getCreator() {
        return this.creator;
    }

    @Override
    public boolean placeAir() {
        return this.placeAir;
    }

    @Override
    public boolean schedules() {
        return this.schedules;
    }

    @Override
    public boolean placesVoid() {
        return this.placesVoid;
    }

    @Override
    public boolean spawnsEntities() {
        return this.spawnEntities;
    }

    @Override
    public ICreationData clone() {
        CreationData data = new CreationData(this.world).pos(new BlockPos((Vec3i)this.pos)).rotation(this.rotation).creator(this.creator).placesAir(this.placeAir).schedules(this.schedules).placesVoid(this.placesVoid).spawnEntities(this.spawnEntities);
        data.seed = this.seed;
        data.rand = new Random(this.seed);
        return data;
    }

    @Override
    public boolean shouldCreate(BlockPos pos) {
        return true;
    }

    @Override
    public void write(NBTTagCompound tag) {
        tag.func_74782_a("pos", NBTHelper.writeBlockPos(this.pos));
        tag.func_74778_a("rotation", this.rotation.name());
        tag.func_74757_a("placeAir", this.placeAir);
        tag.func_74757_a("placesVoid", this.placesVoid);
        tag.func_74757_a("schedules", this.schedules);
        tag.func_74757_a("spawnEntities", this.spawnEntities);
        tag.func_74772_a("seed", this.seed);
        if (this.world != null) {
            tag.func_74768_a("dimId", this.world.field_73011_w.getDimension());
        }
    }

    @Override
    public void read(NBTTagCompound tag) {
        this.pos = NBTHelper.readBlockPos(tag.func_74775_l("pos"));
        this.rotation = Rotation.valueOf((String)tag.func_74779_i("rotation"));
        this.placeAir = tag.func_74767_n("placeAir");
        this.placesVoid = tag.func_74767_n("placesVoid");
        this.schedules = tag.func_74767_n("schedules");
        this.spawnEntities = tag.func_74767_n("spawnEntities");
        this.seed = tag.func_74763_f("seed");
        if (tag.func_74764_b("dimId")) {
            this.dimId = tag.func_74762_e("dimId");
        }
        this.rand = new Random(this.seed);
    }
}

